/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.channels.ClosedByInterruptException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.batch.CommandExecutor;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.StringUtils;

public class CommandListener
implements Runnable {
    private static Logger log = Logger.getLogger(CommandListener.class);
    private static CommandListener listener;
    private int port = -1;
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private Thread listenerThread;
    boolean halt = false;
    public static Set<String> fileParams;
    private static final String CRNL = "\r\n";
    private static final String CONTENT_TYPE = "Content-Type: ";
    private static final String HTTP_RESPONSE = "HTTP/1.1 200 OK";
    private static final String HTTP_NO_RESPONSE = "HTTP/1.1 204 No Response";
    private static final String CONTENT_LENGTH = "Content-Length: ";
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    private static final String CONNECTION_CLOSE = "Connection: close";
    private static final String NO_CACHE = "Cache-Control: no-cache, no-store";

    public static synchronized void start(int port) {
        listener = new CommandListener(port);
        CommandListener.listener.listenerThread.start();
    }

    public static synchronized void halt() {
        if (listener != null) {
            CommandListener.listener.halt = true;
            CommandListener.listener.listenerThread.interrupt();
            listener.closeSockets();
            listener = null;
        }
    }

    private CommandListener(int port) {
        this.port = port;
        this.listenerThread = new Thread(this);
    }

    @Override
    public void run() {
        block7: {
            CommandExecutor cmdExe = new CommandExecutor();
            try {
                this.serverSocket = new ServerSocket(this.port);
                log.info("Listening on port " + this.port);
                while (!this.halt) {
                    this.clientSocket = this.serverSocket.accept();
                    this.processClientSession(cmdExe);
                    if (this.clientSocket == null) continue;
                    try {
                        this.clientSocket.close();
                        this.clientSocket = null;
                    }
                    catch (IOException e) {
                        log.error("Error in client socket loop", e);
                    }
                }
            }
            catch (BindException e) {
                log.error(e);
            }
            catch (ClosedByInterruptException e) {
                log.error(e);
            }
            catch (IOException e) {
                if (this.halt) break block7;
                log.error("IO Error on port socket ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClientSession(CommandExecutor cmdExe) throws IOException {
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String inputLine;
            out = new PrintWriter(this.clientSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            while (!this.halt && (inputLine = in.readLine()) != null) {
                String cmd = inputLine;
                if (cmd.startsWith("GET")) {
                    String command = null;
                    Map<String, String> params = null;
                    String[] tokens = inputLine.split(" ");
                    if (tokens.length < 2) {
                        this.sendHTTPResponse(out, "ERROR unexpected command line: " + inputLine);
                        return;
                    }
                    String[] parts = tokens[1].split("\\?");
                    if (parts.length < 2) {
                        this.sendHTTPResponse(out, "ERROR unexpected command line: " + inputLine);
                        return;
                    }
                    command = parts[0];
                    params = this.parseParameters(parts[1]);
                    String nextLine = in.readLine();
                    while (nextLine != null && nextLine.length() > 0) {
                        nextLine = in.readLine();
                    }
                    String callback = params.get("callback");
                    if (callback != null) {
                        this.sendHTTPResponse(out, callback);
                    }
                    this.processGet(command, params, cmdExe);
                    if (callback == null) {
                        this.sendHTTPResponse(out, null);
                    }
                    return;
                }
                Globals.setBatch(true);
                Globals.setSuppressMessages(true);
                String response = cmdExe.execute(inputLine);
                out.println(response);
            }
        }
        catch (IOException e) {
            log.error("Error processing client session", e);
        }
        finally {
            Globals.setSuppressMessages(false);
            Globals.setBatch(false);
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void closeSockets() {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
                this.clientSocket = null;
            }
            catch (IOException e) {
                log.error("Error closing clientSocket", e);
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException e) {
                log.error("Error closing server socket", e);
            }
        }
    }

    private void sendHTTPResponse(PrintWriter out, String result) {
        out.println(result == null ? HTTP_NO_RESPONSE : HTTP_RESPONSE);
        if (result != null) {
            out.print("Content-Type: text/html");
            out.print(CRNL);
            out.print(CONTENT_LENGTH + result.length());
            out.print(CRNL);
            out.print(NO_CACHE);
            out.print(CRNL);
            out.print(CONNECTION_CLOSE);
            out.print(CRNL);
            out.print(CRNL);
            out.print(result);
            out.print(CRNL);
        }
        out.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processGet(String command, Map<String, String> params, CommandExecutor cmdExe) throws IOException {
        String result = "OK";
        Frame mainFrame = IGV.getMainFrame();
        mainFrame.toFront();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setAlwaysOnTop(false);
        String server = params.get("server");
        if (server == null || server.trim().length() < 1) {
            server = PreferenceManager.getInstance().get("IONTORRENT.SERVER");
        } else {
            PreferenceManager.getInstance().put("IONTORRENT.SERVER", server);
        }
        if (command.equals("/load")) {
            String fp;
            String file = null;
            Iterator<String> i$ = fileParams.iterator();
            while (i$.hasNext() && (file = params.get(fp = i$.next())) == null) {
            }
            String genome = params.get("genome");
            if (genome == null) {
                genome = params.get("db");
            }
            if (genome != null) {
                if (IGV.getInstance().getSelectableGenomeIDs().contains(genome)) {
                    IGV.getInstance().selectGenomeFromList(genome);
                } else {
                    IGV.getInstance().loadGenome(genome.trim(), null);
                }
            }
            if (file == null) return "ERROR Parameter \"file\" is required";
            PreferenceManager.getInstance().put("IONTORRENT.RESULTS", file);
            String mergeValue = params.get("merge");
            if (mergeValue != null) {
                mergeValue = URLDecoder.decode(mergeValue, "UTF-8");
            }
            boolean merge = mergeValue != null ? mergeValue.equalsIgnoreCase("true") : !file.endsWith(".xml") && !file.endsWith(".php") && !file.endsWith(".php3");
            String name = params.get("name");
            String locus = params.get("locus");
            return cmdExe.loadFiles(file, locus, merge, name, params);
        }
        if (!command.equals("/reload")) {
            if (!command.equals("/goto")) return "ERROR Unknown command: " + command;
        }
        String locus = params.get("locus");
        IGV.getInstance().goToLocus(locus);
        return result;
    }

    private Map<String, String> parseParameters(String parameterString) {
        String[] kvPairs;
        parameterString = parameterString.replace("&amp;", "&");
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kvString : kvPairs = parameterString.split("&")) {
            String[] kv = kvString.split("=", 2);
            if (kv.length == 1) {
                params.put(kv[0], null);
                continue;
            }
            String key = StringUtils.decodeURL(kv[0]);
            boolean cmdExeWillDecode = fileParams.contains(key) && CommandExecutor.needsDecode(kv[1]);
            String value = cmdExeWillDecode ? kv[1] : StringUtils.decodeURL(kv[1]);
            params.put(kv[0], value);
        }
        return params;
    }

    static {
        String[] fps = new String[]{"file", "bigDataURL", "sessionURL", "dataURL"};
        fileParams = new LinkedHashSet<String>(Arrays.asList(fps));
        fileParams = Collections.unmodifiableSet(fileParams);
    }
}

