/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SimpleTimer {
    private static final Logger logger = Logger.getLogger(SimpleTimer.class);
    protected static final double NANO_TO_SECOND_DOUBLE = 1.0 / (double)TimeUnit.SECONDS.toNanos(1L);
    private static final long MILLI_TO_NANO = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ThreadLocal<NumberFormat> NUMBER_FORMAT = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NumberFormat.getIntegerInstance();
        }
    };
    private static final long CLOCK_DRIFT = TimeUnit.SECONDS.toNanos(5L);
    private final String name;
    private long nanoTimeOffset;
    private long elapsedTimeNano = 0L;
    private long startTimeNano = 0L;
    private boolean running = false;

    public SimpleTimer() {
        this("Anonymous");
    }

    public SimpleTimer(String name) {
        if (name == null) {
            throw new IllegalArgumentException("SimpleTimer name cannot be null");
        }
        this.name = name;
        this.nanoTimeOffset = SimpleTimer.getNanoOffset();
    }

    public synchronized String getName() {
        return this.name;
    }

    @Ensures(value={"elapsedTimeNano == 0l"})
    public synchronized SimpleTimer start() {
        this.elapsedTimeNano = 0L;
        return this.restart();
    }

    public synchronized SimpleTimer restart() {
        this.running = true;
        this.startTimeNano = this.currentTimeNano();
        this.nanoTimeOffset = SimpleTimer.getNanoOffset();
        return this;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public long currentTime() {
        return System.currentTimeMillis();
    }

    public long currentTimeNano() {
        return System.nanoTime();
    }

    @Requires(value={"startTimeNano != 0l"})
    public synchronized SimpleTimer stop() {
        if (this.running) {
            this.running = false;
            if (this.ensureClockSync()) {
                this.elapsedTimeNano += this.currentTimeNano() - this.startTimeNano;
            }
        }
        return this;
    }

    public synchronized double getElapsedTime() {
        return SimpleTimer.nanoToSecondsAsDouble(this.getElapsedTimeNano());
    }

    protected static double nanoToSecondsAsDouble(long nano) {
        return (double)nano * NANO_TO_SECOND_DOUBLE;
    }

    public synchronized long getElapsedTimeNano() {
        if (this.running && this.ensureClockSync()) {
            return this.currentTimeNano() - this.startTimeNano + this.elapsedTimeNano;
        }
        return this.elapsedTimeNano;
    }

    public synchronized void addElapsed(SimpleTimer toAdd) {
        this.elapsedTimeNano += toAdd.getElapsedTimeNano();
    }

    private static long getNanoOffset() {
        return System.nanoTime() - System.currentTimeMillis() * MILLI_TO_NANO;
    }

    private boolean ensureClockSync() {
        boolean ret;
        long currentOffset = SimpleTimer.getNanoOffset();
        long diff = Math.abs(currentOffset - this.nanoTimeOffset);
        boolean bl = ret = diff <= CLOCK_DRIFT;
        if (!ret) {
            NumberFormat numberFormat = NUMBER_FORMAT.get();
            String msg = String.format("Clock drift of %s - %s = %s nanoseconds detected, vs. max allowable drift of %s. Assuming checkpoint/restart event.", numberFormat.format(currentOffset), numberFormat.format(this.nanoTimeOffset), numberFormat.format(diff), numberFormat.format(CLOCK_DRIFT));
            logger.warn((Object)msg);
        }
        this.nanoTimeOffset = currentOffset;
        return ret;
    }
}

