/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.progressmeter;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;

class ProgressMeterData {
    private final double elapsedSeconds;
    private final long unitsProcessed;
    private final long bpProcessed;

    @Requires(value={"unitsProcessed >= 0", "bpProcessed >= 0", "elapsedSeconds >= 0"})
    public ProgressMeterData(double elapsedSeconds, long unitsProcessed, long bpProcessed) {
        this.elapsedSeconds = elapsedSeconds;
        this.unitsProcessed = unitsProcessed;
        this.bpProcessed = bpProcessed;
    }

    @Ensures(value={"result >= 0.0"})
    public double getElapsedSeconds() {
        return this.elapsedSeconds;
    }

    @Ensures(value={"result >= 0"})
    public long getUnitsProcessed() {
        return this.unitsProcessed;
    }

    @Ensures(value={"result >= 0"})
    public long getBpProcessed() {
        return this.bpProcessed;
    }

    @Ensures(value={"result >= 0.0"})
    public double secondsPerMillionElements() {
        return this.elapsedSeconds * 1000000.0 / (double)Math.max(this.unitsProcessed, 1L);
    }

    @Ensures(value={"result >= 0.0"})
    public double secondsPerMillionBP() {
        return this.elapsedSeconds * 1000000.0 / (double)Math.max(this.bpProcessed, 1L);
    }

    @Requires(value={"targetSize >= 0"})
    @Ensures(value={"result >= 0.0", "result <= 1.0"})
    public double calculateFractionGenomeTargetCompleted(long targetSize) {
        return 1.0 * (double)this.bpProcessed / (double)Math.max(targetSize, 1L);
    }
}

