/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.jna.drmaa.v1_0;

import com.sun.jna.Pointer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.gatk.utils.jna.drmaa.v1_0.JnaSession;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.FileTransferMode;
import org.ggf.drmaa.InvalidAttributeValueException;
import org.ggf.drmaa.JobTemplate;
import org.ggf.drmaa.PartialTimestamp;

public class JnaJobTemplate
implements JobTemplate {
    private final JnaSession session;
    private final Pointer jt;

    public JnaJobTemplate(JnaSession session, Pointer jt) {
        this.session = session;
        this.jt = jt;
    }

    public Pointer getPointer() {
        return this.jt;
    }

    public void setRemoteCommand(String s) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_remote_command", s);
    }

    public String getRemoteCommand() throws DrmaaException {
        return JnaSession.getAttribute(this.jt, "drmaa_remote_command");
    }

    public void setArgs(List list) throws DrmaaException {
        JnaSession.setVectorAttribute(this.jt, "drmaa_v_argv", list);
    }

    public List getArgs() throws DrmaaException {
        return JnaSession.getVectorAttribute(this.jt, "drmaa_v_argv");
    }

    public void setJobSubmissionState(int state) throws DrmaaException {
        String stateString;
        if (state == 0) {
            stateString = "drmaa_hold";
        } else if (state == 1) {
            stateString = "drmaa_active";
        } else {
            throw new InvalidAttributeValueException("jobSubmissionState attribute is invalid");
        }
        JnaSession.setAttribute(this.jt, "drmaa_js_state", stateString);
    }

    public int getJobSubmissionState() throws DrmaaException {
        int state;
        String stateString = JnaSession.getAttribute(this.jt, "drmaa_js_state");
        if ("drmaa_hold".equals(stateString)) {
            state = 0;
        } else if ("drmaa_active".equals(stateString)) {
            state = 1;
        } else {
            throw new InvalidAttributeValueException("jobSubmissionState attribute is invalid");
        }
        return state;
    }

    public void setJobEnvironment(Map env) throws DrmaaException {
        JnaSession.setVectorAttribute(this.jt, "drmaa_v_env", JnaSession.mapToCollection(env));
    }

    public Map getJobEnvironment() throws DrmaaException {
        return JnaSession.collectionToMap(JnaSession.getVectorAttribute(this.jt, "drmaa_v_env"));
    }

    public void setWorkingDirectory(String s) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_wd", s);
    }

    public String getWorkingDirectory() throws DrmaaException {
        return JnaSession.getAttribute(this.jt, "drmaa_wd");
    }

    public void setJobCategory(String s) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_job_category", s);
    }

    public String getJobCategory() throws DrmaaException {
        return JnaSession.getAttribute(this.jt, "drmaa_job_category");
    }

    public void setNativeSpecification(String s) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_native_specification", s);
    }

    public String getNativeSpecification() throws DrmaaException {
        return JnaSession.getAttribute(this.jt, "drmaa_native_specification");
    }

    public void setEmail(Set set) throws DrmaaException {
        JnaSession.setVectorAttribute(this.jt, "drmaa_v_email", set);
    }

    public Set getEmail() throws DrmaaException {
        return new LinkedHashSet<String>(JnaSession.getVectorAttribute(this.jt, "drmaa_v_email"));
    }

    public void setBlockEmail(boolean b) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_block_email", b ? "1" : "0");
    }

    public boolean getBlockEmail() throws DrmaaException {
        return "1".equals(JnaSession.getAttribute(this.jt, "drmaa_block_email"));
    }

    public void setStartTime(PartialTimestamp partialTimestamp) throws DrmaaException {
        JnaSession.setPartialTime(this.jt, "drmaa_start_time", partialTimestamp);
    }

    public PartialTimestamp getStartTime() throws DrmaaException {
        return JnaSession.getPartialTime(this.jt, "drmaa_start_time");
    }

    public void setJobName(String s) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_job_name", s);
    }

    public String getJobName() throws DrmaaException {
        return JnaSession.getAttribute(this.jt, "drmaa_job_name");
    }

    public void setInputPath(String s) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_input_path", s);
    }

    public String getInputPath() throws DrmaaException {
        return JnaSession.getAttribute(this.jt, "drmaa_input_path");
    }

    public void setOutputPath(String s) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_output_path", s);
    }

    public String getOutputPath() throws DrmaaException {
        return JnaSession.getAttribute(this.jt, "drmaa_output_path");
    }

    public void setErrorPath(String s) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_error_path", s);
    }

    public String getErrorPath() throws DrmaaException {
        return JnaSession.getAttribute(this.jt, "drmaa_error_path");
    }

    public void setJoinFiles(boolean b) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_join_files", b ? "y" : "n");
    }

    public boolean getJoinFiles() throws DrmaaException {
        return "y".equals(JnaSession.getAttribute(this.jt, "drmaa_join_files"));
    }

    public void setTransferFiles(FileTransferMode fileTransferMode) throws DrmaaException {
        StringBuilder buf = new StringBuilder();
        if (fileTransferMode.getInputStream()) {
            buf.append('i');
        }
        if (fileTransferMode.getOutputStream()) {
            buf.append('o');
        }
        if (fileTransferMode.getErrorStream()) {
            buf.append('e');
        }
        JnaSession.setAttribute(this.jt, "drmaa_transfer_files", buf.toString());
    }

    public FileTransferMode getTransferFiles() throws DrmaaException {
        String mode = JnaSession.getAttribute(this.jt, "drmaa_transfer_files");
        if (mode == null) {
            return null;
        }
        FileTransferMode fileTransferMode = new FileTransferMode();
        fileTransferMode.setInputStream(mode.indexOf(105) >= 0);
        fileTransferMode.setOutputStream(mode.indexOf(111) >= 0);
        fileTransferMode.setErrorStream(mode.indexOf(101) >= 0);
        return fileTransferMode;
    }

    public void setDeadlineTime(PartialTimestamp partialTimestamp) throws DrmaaException {
        JnaSession.setPartialTime(this.jt, "drmaa_deadline_time", partialTimestamp);
    }

    public PartialTimestamp getDeadlineTime() throws DrmaaException {
        return JnaSession.getPartialTime(this.jt, "drmaa_deadline_time");
    }

    public void setHardWallclockTimeLimit(long l) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_wct_hlimit", JnaSession.formatLimit(l));
    }

    public long getHardWallclockTimeLimit() throws DrmaaException {
        return JnaSession.parseLimit(JnaSession.getAttribute(this.jt, "drmaa_wct_hlimit"));
    }

    public void setSoftWallclockTimeLimit(long l) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_wct_slimit", JnaSession.formatLimit(l));
    }

    public long getSoftWallclockTimeLimit() throws DrmaaException {
        return JnaSession.parseLimit(JnaSession.getAttribute(this.jt, "drmaa_wct_slimit"));
    }

    public void setHardRunDurationLimit(long l) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_duration_hlimit", JnaSession.formatLimit(l));
    }

    public long getHardRunDurationLimit() throws DrmaaException {
        return JnaSession.parseLimit(JnaSession.getAttribute(this.jt, "drmaa_duration_hlimit"));
    }

    public void setSoftRunDurationLimit(long l) throws DrmaaException {
        JnaSession.setAttribute(this.jt, "drmaa_duration_slimit", JnaSession.formatLimit(l));
    }

    public long getSoftRunDurationLimit() throws DrmaaException {
        return JnaSession.parseLimit(JnaSession.getAttribute(this.jt, "drmaa_duration_slimit"));
    }

    public Set getAttributeNames() throws DrmaaException {
        return JnaSession.getAttrNames();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JnaJobTemplate)) {
            return false;
        }
        JnaJobTemplate other = (JnaJobTemplate)obj;
        return this.jt.equals((Object)other.jt) && this.session.equals(other.session);
    }

    public int hashCode() {
        return this.jt.hashCode();
    }
}

