/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.text.XReadLines;

public class ProcessUtils {
    private static Logger logger = Logger.getLogger(ProcessUtils.class);

    public static int runCommandAndWait(String command) {
        if (command == null) {
            throw new IllegalArgumentException("command cannot be null");
        }
        if (command.equals("")) {
            throw new IllegalArgumentException("command cannot be the empty string");
        }
        try {
            logger.debug((Object)("Running command: " + command));
            Process p = Runtime.getRuntime().exec(command);
            int result = p.waitFor();
            if (logger.isDebugEnabled()) {
                for (String line : new XReadLines(p.getInputStream())) {
                    logger.debug((Object)("command: " + line));
                }
                for (String line : new XReadLines(p.getErrorStream())) {
                    logger.error((Object)("command: " + line));
                }
            }
            logger.debug((Object)("Command exited with result: " + result));
            return result;
        }
        catch (Exception e) {
            throw new ReviewedGATKException("Error running command:" + command, e);
        }
    }
}

