/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayConverter
implements ObjectConverter {
    private String _separator;
    private int _size;
    private Class<?> _elementClass;
    private Class<?>[] _elementClasses;
    private boolean _useTokenizer;

    public ArrayConverter(String separator, int size, Class<?> elementClass) {
        this._separator = separator;
        this._size = size;
        this._elementClass = elementClass;
    }

    public ArrayConverter(String separator, int size, Class<?>[] elementClasses) {
        if (separator == null || separator.trim().length() == 0) {
            throw new IllegalArgumentException("separator cannot be empty.");
        }
        if (elementClasses == null) {
            throw new IllegalArgumentException("elementClasses cannot be null.");
        }
        if (size != elementClasses.length) {
            throw new IllegalArgumentException("size must be equal to the length of elementClasses.");
        }
        this._separator = separator;
        this._size = size;
        this._elementClasses = elementClasses;
    }

    public String arrayToString(Object[] objects, ConverterContext context) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < objects.length; ++i) {
            Object o = objects[i];
            buffer.append(this.toString(i, o, context));
            if (i == objects.length - 1) continue;
            buffer.append(this._separator);
        }
        return new String(buffer);
    }

    protected String toString(int i, Object o, ConverterContext context) {
        return this._elementClass != null ? ObjectConverterManager.toString(o, this._elementClass, context) : ObjectConverterManager.toString(o, this._elementClasses[i], context);
    }

    public Object[] arrayFromString(String string, ConverterContext context) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (this.isUseTokenizer()) {
            StringTokenizer token = new StringTokenizer(string, this._separator);
            Object[] objects = new Object[this._size != -1 ? this._size : token.countTokens()];
            for (int i = 0; i < objects.length && token.hasMoreTokens(); ++i) {
                String s = token.nextToken().trim();
                objects[i] = this.fromString(i, s, context);
            }
            return objects;
        }
        String[] ss = string.split(this._separator);
        Object[] objects = new Object[this._size != -1 ? this._size : ss.length];
        for (int i = 0; i < objects.length && i < ss.length; ++i) {
            String s = ss[i].trim();
            objects[i] = this.fromString(i, s, context);
        }
        return objects;
    }

    protected Object fromString(int i, String s, ConverterContext context) {
        return this._elementClass != null ? ObjectConverterManager.fromString(s, this._elementClass, context) : ObjectConverterManager.fromString(s, this._elementClasses[i], context);
    }

    public Class<?> getElementClass() {
        return this._elementClass;
    }

    public boolean isUseTokenizer() {
        return this._useTokenizer;
    }

    public void setUseTokenizer(boolean useTokenizer) {
        this._useTokenizer = useTokenizer;
    }
}

