/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.baq;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequence;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.collections.Pair;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.sam.ReadUtils;

public class BAQ {
    private static final Logger logger = Logger.getLogger(BAQ.class);
    private static final boolean DEBUG = false;
    public static final String BAQ_TAG = "BQ";
    private static double[] qual2prob = new double[256];
    public static final double DEFAULT_GOP = 40.0;
    public double cd = -1.0;
    private double ce = 0.1;
    private int cb = 7;
    private boolean includeClippedBases = false;
    private byte minBaseQual = (byte)4;
    private static final double EM = 0.33333333333;
    private static final double EI = 0.25;
    private double[][][] EPSILONS = new double[256][256][94];

    private double convertFromPhredScale(double x2) {
        return Math.pow(10.0, -x2 / 10.0);
    }

    public byte getMinBaseQual() {
        return this.minBaseQual;
    }

    public double getGapOpenProb() {
        return this.cd;
    }

    public double getGapExtensionProb() {
        return this.ce;
    }

    public int getBandWidth() {
        return this.cb;
    }

    public BAQ() {
        this(40.0);
    }

    public BAQ(double gapOpenPenalty) {
        this.cd = this.convertFromPhredScale(gapOpenPenalty);
        this.initializeCachedData();
    }

    public BAQ(double d2, double e2, int b2, byte minBaseQual, boolean includeClippedBases) {
        this.cd = d2;
        this.ce = e2;
        this.cb = b2;
        this.minBaseQual = minBaseQual;
        this.includeClippedBases = includeClippedBases;
        this.initializeCachedData();
    }

    private void initializeCachedData() {
        for (int i2 = 0; i2 < 256; ++i2) {
            for (int j2 = 0; j2 < 256; ++j2) {
                for (int q2 = 0; q2 <= 93; ++q2) {
                    this.EPSILONS[i2][j2][q2] = 1.0;
                }
            }
        }
        for (char b1 : "ACGTacgt".toCharArray()) {
            for (char b2 : "ACGTacgt".toCharArray()) {
                for (int q3 = 0; q3 <= 93; ++q3) {
                    double e2;
                    double qual = qual2prob[(int)(q3 < this.minBaseQual ? this.minBaseQual : q3)];
                    this.EPSILONS[(byte)b1][(byte)b2][q3] = e2 = Character.toLowerCase(b1) == Character.toLowerCase(b2) ? 1.0 - qual : qual * 0.33333333333;
                }
            }
        }
    }

    protected double calcEpsilon(byte ref, byte read, byte qualB) {
        return this.EPSILONS[ref][read][qualB];
    }

    public int hmm_glocal(byte[] ref, byte[] query, int qstart, int l_query, byte[] _iqual, int[] state, byte[] q2) {
        int v01;
        int v10;
        int v11;
        int u2;
        double e2;
        int i2;
        int k2;
        double sI;
        int bw;
        if (ref == null) {
            throw new ReviewedGATKException("BUG: ref sequence is null");
        }
        if (query == null) {
            throw new ReviewedGATKException("BUG: query sequence is null");
        }
        if (_iqual == null) {
            throw new ReviewedGATKException("BUG: query quality vector is null");
        }
        if (query.length != _iqual.length) {
            throw new ReviewedGATKException("BUG: read sequence length != qual length");
        }
        if (l_query < 1) {
            throw new ReviewedGATKException("BUG: length of query sequence < 0: " + l_query);
        }
        if (qstart < 0) {
            throw new ReviewedGATKException("BUG: query sequence start < 0: " + qstart);
        }
        int l_ref = ref.length;
        int n2 = bw = l_ref > l_query ? l_ref : l_query;
        if (this.cb < Math.abs(l_ref - l_query)) {
            bw = Math.abs(l_ref - l_query) + 3;
        }
        if (bw > this.cb) {
            bw = this.cb;
        }
        if (bw < Math.abs(l_ref - l_query)) {
            bw = Math.abs(l_ref - l_query);
        }
        int bw2 = bw * 2 + 1;
        double[][] f2 = new double[l_query + 1][bw2 * 3 + 6];
        double[][] b2 = new double[l_query + 1][bw2 * 3 + 6];
        double[] s2 = new double[l_query + 2];
        double sM = sI = 1.0 / (double)(2 * l_query + 2);
        double bM = (1.0 - this.cd) / (double)l_ref;
        double bI = this.cd / (double)l_ref;
        double[] m2 = new double[9];
        m2[0] = (1.0 - this.cd - this.cd) * (1.0 - sM);
        m2[1] = m2[2] = this.cd * (1.0 - sM);
        m2[3] = (1.0 - this.ce) * (1.0 - sI);
        m2[4] = this.ce * (1.0 - sI);
        m2[5] = 0.0;
        m2[6] = 1.0 - this.ce;
        m2[7] = 0.0;
        m2[8] = this.ce;
        s2[0] = 1.0;
        f2[0][BAQ.set_u((int)bw, (int)0, (int)0)] = 1.0;
        double[] fi = f2[1];
        int beg = 1;
        int end = l_ref < bw + 1 ? l_ref : bw + 1;
        double sum = 0.0;
        for (k2 = beg; k2 <= end; ++k2) {
            double e3 = this.calcEpsilon(ref[k2 - 1], query[qstart], _iqual[qstart]);
            int u3 = BAQ.set_u(bw, 1, k2);
            fi[u3 + 0] = e3 * bM;
            fi[u3 + 1] = 0.25 * bI;
            sum += fi[u3] + fi[u3 + 1];
        }
        s2[1] = sum;
        int _beg = BAQ.set_u(bw, 1, beg);
        int _end = BAQ.set_u(bw, 1, end);
        _end += 2;
        k2 = _beg;
        while (k2 <= _end) {
            int n3 = k2++;
            fi[n3] = fi[n3] / sum;
        }
        for (i2 = 2; i2 <= l_query; ++i2) {
            fi = f2[i2];
            double[] fi1 = f2[i2 - 1];
            int beg2 = 1;
            int end2 = l_ref;
            byte qyi = query[qstart + i2 - 1];
            int x2 = i2 - bw;
            beg2 = beg2 > x2 ? beg2 : x2;
            x2 = i2 + bw;
            end2 = end2 < x2 ? end2 : x2;
            double sum2 = 0.0;
            for (k2 = beg2; k2 <= end2; ++k2) {
                e2 = this.calcEpsilon(ref[k2 - 1], qyi, _iqual[qstart + i2 - 1]);
                u2 = BAQ.set_u(bw, i2, k2);
                v11 = BAQ.set_u(bw, i2 - 1, k2 - 1);
                v10 = BAQ.set_u(bw, i2 - 1, k2);
                v01 = BAQ.set_u(bw, i2, k2 - 1);
                fi[u2 + 0] = e2 * (m2[0] * fi1[v11 + 0] + m2[3] * fi1[v11 + 1] + m2[6] * fi1[v11 + 2]);
                fi[u2 + 1] = 0.25 * (m2[1] * fi1[v10 + 0] + m2[4] * fi1[v10 + 1]);
                fi[u2 + 2] = m2[2] * fi[v01 + 0] + m2[8] * fi[v01 + 2];
                sum2 += fi[u2] + fi[u2 + 1] + fi[u2 + 2];
            }
            s2[i2] = sum2;
            int _beg2 = BAQ.set_u(bw, i2, beg2);
            int _end2 = BAQ.set_u(bw, i2, end2);
            _end2 += 2;
            k2 = _beg2;
            sum2 = 1.0 / sum2;
            while (k2 <= _end2) {
                int n4 = k2++;
                fi[n4] = fi[n4] * sum2;
            }
        }
        double sum3 = 0.0;
        for (k2 = 1; k2 <= l_ref; ++k2) {
            int u4 = BAQ.set_u(bw, l_query, k2);
            if (u4 < 3 || u4 >= bw2 * 3 + 3) continue;
            sum3 += f2[l_query][u4 + 0] * sM + f2[l_query][u4 + 1] * sI;
        }
        s2[l_query + 1] = sum3;
        for (k2 = 1; k2 <= l_ref; ++k2) {
            int u5 = BAQ.set_u(bw, l_query, k2);
            double[] bi = b2[l_query];
            if (u5 < 3 || u5 >= bw2 * 3 + 3) continue;
            bi[u5 + 0] = sM / s2[l_query] / s2[l_query + 1];
            bi[u5 + 1] = sI / s2[l_query] / s2[l_query + 1];
        }
        for (i2 = l_query - 1; i2 >= 1; --i2) {
            int beg3 = 1;
            int end3 = l_ref;
            double[] bi = b2[i2];
            double[] bi1 = b2[i2 + 1];
            double y = i2 > 1 ? 1.0 : 0.0;
            byte qyi1 = query[qstart + i2];
            int x3 = i2 - bw;
            beg3 = beg3 > x3 ? beg3 : x3;
            x3 = i2 + bw;
            for (k2 = end3 = end3 < x3 ? end3 : x3; k2 >= beg3; --k2) {
                u2 = BAQ.set_u(bw, i2, k2);
                v11 = BAQ.set_u(bw, i2 + 1, k2 + 1);
                v10 = BAQ.set_u(bw, i2 + 1, k2);
                v01 = BAQ.set_u(bw, i2, k2 + 1);
                e2 = (k2 >= l_ref ? 0.0 : this.calcEpsilon(ref[k2], qyi1, _iqual[qstart + i2])) * bi1[v11];
                bi[u2 + 0] = e2 * m2[0] + 0.25 * m2[1] * bi1[v10 + 1] + m2[2] * bi[v01 + 2];
                bi[u2 + 1] = e2 * m2[3] + 0.25 * m2[4] * bi1[v10 + 1];
                bi[u2 + 2] = (e2 * m2[6] + m2[8] * bi[v01 + 2]) * y;
            }
            int _beg3 = BAQ.set_u(bw, i2, beg3);
            int _end3 = BAQ.set_u(bw, i2, end3);
            _end3 += 2;
            k2 = _beg3;
            y = 1.0 / s2[i2];
            while (k2 <= _end3) {
                int n5 = k2++;
                bi[n5] = bi[n5] * y;
            }
        }
        int beg4 = 1;
        int end4 = l_ref < bw + 1 ? l_ref : bw + 1;
        double sum4 = 0.0;
        for (k2 = end4; k2 >= beg4; --k2) {
            int u6 = BAQ.set_u(bw, 1, k2);
            double e4 = this.calcEpsilon(ref[k2 - 1], query[qstart], _iqual[qstart]);
            if (u6 < 3 || u6 >= bw2 * 3 + 3) continue;
            sum4 += e4 * b2[1][u6 + 0] * bM + 0.25 * b2[1][u6 + 1] * bI;
        }
        double d2 = sum4 / s2[0];
        b2[0][BAQ.set_u((int)bw, (int)0, (int)0)] = d2;
        double pb = d2;
        for (i2 = 1; i2 <= l_query; ++i2) {
            double sum5 = 0.0;
            double max = 0.0;
            double[] fi2 = f2[i2];
            double[] bi = b2[i2];
            int beg5 = 1;
            int end5 = l_ref;
            int max_k = -1;
            int x4 = i2 - bw;
            beg5 = beg5 > x4 ? beg5 : x4;
            x4 = i2 + bw;
            end5 = end5 < x4 ? end5 : x4;
            for (k2 = beg5; k2 <= end5; ++k2) {
                int u7 = BAQ.set_u(bw, i2, k2);
                double z = fi2[u7 + 0] * bi[u7 + 0];
                sum5 += z;
                if (z > max) {
                    max = z;
                    max_k = k2 - 1 << 2 | 0;
                }
                z = fi2[u7 + 1] * bi[u7 + 1];
                sum5 += z;
                if (!(z > max)) continue;
                max = z;
                max_k = k2 - 1 << 2 | 1;
            }
            max /= sum5;
            sum5 *= s2[i2];
            if (state != null) {
                state[qstart + i2 - 1] = max_k;
            }
            if (q2 == null) continue;
            k2 = (int)(-4.343 * Math.log(1.0 - max) + 0.499);
            q2[qstart + i2 - 1] = (byte)(k2 > 100 ? 99 : (k2 < this.minBaseQual ? (int)this.minBaseQual : k2));
        }
        return 0;
    }

    public static boolean stateIsIndel(int state) {
        return (state & 3) != 0;
    }

    public static int stateAlignedPosition(int state) {
        return state >> 2;
    }

    private static int set_u(int b2, int i2, int k2) {
        int x2 = i2 - b2;
        x2 = x2 > 0 ? x2 : 0;
        return (k2 + 1 - x2) * 3;
    }

    public static byte[] getBAQTag(SAMRecord read) {
        String s2 = read.getStringAttribute(BAQ_TAG);
        return s2 != null ? s2.getBytes() : null;
    }

    public static String encodeBQTag(SAMRecord read, byte[] baq) {
        byte[] bqTag = new byte[baq.length];
        for (int i2 = 0; i2 < bqTag.length; ++i2) {
            byte baq_i;
            int bq = read.getBaseQualities()[i2] + 64;
            int tag = bq - (baq_i = baq[i2]);
            if (tag < 0) {
                throw new ReviewedGATKException("BAQ tag calculation error.  BAQ value above base quality at " + read);
            }
            if (tag > 127) {
                throw new UserException.MisencodedBAM(read, "we encountered an extremely high quality score (" + read.getBaseQualities()[i2] + ") with BAQ correction factor of " + baq_i);
            }
            bqTag[i2] = (byte)tag;
        }
        return new String(bqTag);
    }

    public static void addBAQTag(SAMRecord read, byte[] baq) {
        read.setAttribute(BAQ_TAG, (Object)BAQ.encodeBQTag(read, baq));
    }

    public static boolean hasBAQTag(SAMRecord read) {
        return read.getStringAttribute(BAQ_TAG) != null;
    }

    public static byte[] calcBAQFromTag(SAMRecord read, boolean overwriteOriginalQuals, boolean useRawQualsIfNoBAQTag) {
        byte[] rawQuals;
        byte[] newQuals = rawQuals = read.getBaseQualities();
        byte[] baq = BAQ.getBAQTag(read);
        if (baq != null) {
            newQuals = overwriteOriginalQuals ? rawQuals : new byte[rawQuals.length];
            for (int i2 = 0; i2 < rawQuals.length; ++i2) {
                byte rawQual = rawQuals[i2];
                int baq_delta = baq[i2] - 64;
                int newval = rawQual - baq_delta;
                if (newval < 0) {
                    throw new UserException.MalformedBAM(read, "BAQ tag error: the BAQ value is larger than the base quality");
                }
                newQuals[i2] = (byte)newval;
            }
        } else if (!useRawQualsIfNoBAQTag) {
            throw new IllegalStateException("Required BAQ tag to be present, but none was on read " + read.getReadName());
        }
        return newQuals;
    }

    public static byte calcBAQFromTag(SAMRecord read, int offset, boolean useRawQualsIfNoBAQTag) {
        byte rawQual;
        byte newQual = rawQual = read.getBaseQualities()[offset];
        byte[] baq = BAQ.getBAQTag(read);
        if (baq != null) {
            int baq_delta = baq[offset] - 64;
            int newval = rawQual - baq_delta;
            if (newval < 0) {
                throw new UserException.MalformedBAM(read, "BAQ tag error: the BAQ value is larger than the base quality");
            }
            newQual = (byte)newval;
        } else if (!useRawQualsIfNoBAQTag) {
            throw new IllegalStateException("Required BAQ tag to be present, but none was on read " + read.getReadName());
        }
        return newQual;
    }

    public BAQCalculationResult calcBAQFromHMM(SAMRecord read, IndexedFastaSequenceFile refReader) {
        int offset = this.getBandWidth() / 2;
        long readStart = this.includeClippedBases ? (long)read.getUnclippedStart() : (long)read.getAlignmentStart();
        long start = Math.max(readStart - (long)offset - (long)ReadUtils.getFirstInsertionOffset(read), 0L);
        long stop = (this.includeClippedBases ? read.getUnclippedEnd() : read.getAlignmentEnd()) + offset + ReadUtils.getLastInsertionOffset(read);
        if (stop > (long)refReader.getSequenceDictionary().getSequence(read.getReferenceName()).getSequenceLength()) {
            return null;
        }
        ReferenceSequence refSeq = refReader.getSubsequenceAt(read.getReferenceName(), start, stop);
        return this.calcBAQFromHMM(read, refSeq.getBases(), (int)(start - readStart));
    }

    public BAQCalculationResult calcBAQFromHMM(byte[] ref, byte[] query, byte[] quals, int queryStart, int queryEnd) {
        if (queryStart < 0) {
            throw new ReviewedGATKException("BUG: queryStart < 0: " + queryStart);
        }
        if (queryEnd < 0) {
            throw new ReviewedGATKException("BUG: queryEnd < 0: " + queryEnd);
        }
        if (queryEnd < queryStart) {
            throw new ReviewedGATKException("BUG: queryStart < queryEnd : " + queryStart + " end =" + queryEnd);
        }
        BAQCalculationResult baqResult = new BAQCalculationResult(query, quals, ref);
        int queryLen = queryEnd - queryStart;
        this.hmm_glocal(baqResult.refBases, baqResult.readBases, queryStart, queryLen, baqResult.rawQuals, baqResult.state, baqResult.bq);
        return baqResult;
    }

    private final Pair<Integer, Integer> calculateQueryRange(SAMRecord read) {
        int queryStart = -1;
        int queryStop = -1;
        int readI = 0;
        block5: for (CigarElement elt : read.getCigar().getCigarElements()) {
            switch (elt.getOperator()) {
                case N: {
                    return null;
                }
                case H: 
                case P: 
                case D: {
                    continue block5;
                }
                case I: 
                case S: 
                case M: 
                case EQ: 
                case X: {
                    int prev = readI;
                    readI += elt.getLength();
                    if (!this.includeClippedBases && elt.getOperator() == CigarOperator.S) continue block5;
                    if (queryStart == -1) {
                        queryStart = prev;
                    }
                    queryStop = readI;
                    continue block5;
                }
            }
            throw new ReviewedGATKException("BUG: Unexpected CIGAR element " + elt + " in read " + read.getReadName());
        }
        if (queryStop == queryStart) {
            return null;
        }
        return new Pair<Integer, Integer>(queryStart, queryStop);
    }

    public BAQCalculationResult calcBAQFromHMM(SAMRecord read, byte[] ref, int refOffset) {
        Pair<Integer, Integer> queryRange = this.calculateQueryRange(read);
        if (queryRange == null) {
            return null;
        }
        int queryStart = queryRange.getFirst();
        int queryEnd = queryRange.getSecond();
        BAQCalculationResult baqResult = this.calcBAQFromHMM(ref, read.getReadBases(), read.getBaseQualities(), queryStart, queryEnd);
        int readI = 0;
        int refI = 0;
        block8: for (CigarElement elt : read.getCigar().getCigarElements()) {
            int l2 = elt.getLength();
            switch (elt.getOperator()) {
                case N: {
                    return null;
                }
                case H: 
                case P: {
                    continue block8;
                }
                case S: {
                    refI += l2;
                }
                case I: {
                    int i2;
                    for (i2 = readI; i2 < readI + l2; ++i2) {
                        baqResult.bq[i2] = baqResult.rawQuals[i2];
                    }
                    readI += l2;
                    continue block8;
                }
                case D: {
                    refI += l2;
                    continue block8;
                }
                case M: {
                    int i2;
                    for (i2 = readI; i2 < readI + l2; ++i2) {
                        int expectedPos = refI - refOffset + (i2 - readI);
                        baqResult.bq[i2] = this.capBaseByBAQ(baqResult.rawQuals[i2], baqResult.bq[i2], baqResult.state[i2], expectedPos);
                    }
                    readI += l2;
                    refI += l2;
                    continue block8;
                }
            }
            throw new ReviewedGATKException("BUG: Unexpected CIGAR element " + elt + " in read " + read.getReadName());
        }
        if (readI != read.getReadLength()) {
            System.arraycopy(baqResult.rawQuals, 0, baqResult.bq, 0, baqResult.bq.length);
        }
        return baqResult;
    }

    public byte capBaseByBAQ(byte oq, byte bq, int state, int expectedPos) {
        boolean isIndel = BAQ.stateIsIndel(state);
        int pos = BAQ.stateAlignedPosition(state);
        byte b2 = isIndel || pos != expectedPos ? this.minBaseQual : (bq < oq ? bq : oq);
        return b2;
    }

    public byte[] baqRead(SAMRecord read, IndexedFastaSequenceFile refReader, CalculationMode calculationType, QualityMode qmode) {
        byte[] BAQQuals;
        block7: {
            block8: {
                boolean readHasBAQTag;
                block9: {
                    BAQQuals = read.getBaseQualities();
                    if (calculationType == CalculationMode.OFF || this.excludeReadFromBAQ(read)) break block7;
                    readHasBAQTag = BAQ.hasBAQTag(read);
                    if (calculationType != CalculationMode.RECALCULATE && readHasBAQTag) break block8;
                    BAQCalculationResult hmmResult = this.calcBAQFromHMM(read, refReader);
                    if (hmmResult == null) break block9;
                    switch (qmode) {
                        case ADD_TAG: {
                            BAQ.addBAQTag(read, hmmResult.bq);
                            break block7;
                        }
                        case OVERWRITE_QUALS: {
                            System.arraycopy(hmmResult.bq, 0, read.getBaseQualities(), 0, hmmResult.bq.length);
                            break block7;
                        }
                        case DONT_MODIFY: {
                            BAQQuals = hmmResult.bq;
                            break block7;
                        }
                        default: {
                            throw new ReviewedGATKException("BUG: unexpected qmode " + (Object)((Object)qmode));
                        }
                    }
                }
                if (readHasBAQTag) {
                    read.setAttribute(BAQ_TAG, null);
                }
                break block7;
            }
            if (qmode == QualityMode.OVERWRITE_QUALS) {
                BAQ.calcBAQFromTag(read, true, false);
            }
        }
        return BAQQuals;
    }

    public boolean excludeReadFromBAQ(SAMRecord read) {
        return read.getReadUnmappedFlag() || read.getReadFailsVendorQualityCheckFlag() || read.getDuplicateReadFlag();
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            BAQ.qual2prob[i2] = Math.pow(10.0, (double)(-i2) / 10.0);
        }
    }

    public static class BAQCalculationResult {
        public byte[] refBases;
        public byte[] rawQuals;
        public byte[] readBases;
        public byte[] bq;
        public int[] state;

        public BAQCalculationResult(SAMRecord read, byte[] ref) {
            this(read.getBaseQualities(), read.getReadBases(), ref);
        }

        public BAQCalculationResult(byte[] bases, byte[] quals, byte[] ref) {
            this.rawQuals = quals;
            this.readBases = bases;
            this.bq = new byte[this.rawQuals.length];
            this.state = new int[this.rawQuals.length];
            this.refBases = ref;
        }
    }

    public static enum QualityMode {
        ADD_TAG,
        OVERWRITE_QUALS,
        DONT_MODIFY;

    }

    public static enum CalculationMode {
        OFF,
        CALCULATE_AS_NECESSARY,
        RECALCULATE;

    }
}

