/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.broad.igv.dev.db.DBManager;

public class SQLInputStream
extends InputStream {
    private ResultSet rs;
    private boolean convertToString;
    private DataOutputStream dataOutputStream;
    private ByteArrayOutputStream byteOutputStream;
    private InputStream inputStream;
    private static final int bufferSize = 10000;
    private static final byte[] TAB_BYTES = "\t".getBytes();
    private static final byte[] NEWLINE_BYTES = "\n".getBytes();
    private int minColIndex;
    private int maxColIndex;

    public SQLInputStream(ResultSet rs, boolean convertToString) throws IOException {
        this(rs, convertToString, 1, Integer.MAX_VALUE);
    }

    public SQLInputStream(ResultSet rs, boolean convertToString, int minColIndex, int maxColIndex) throws IOException {
        this.rs = rs;
        this.convertToString = convertToString;
        this.minColIndex = minColIndex;
        this.maxColIndex = maxColIndex;
        this.byteOutputStream = new ByteArrayOutputStream(10000);
        this.dataOutputStream = new DataOutputStream(this.byteOutputStream);
        this.fillRow();
    }

    private boolean fillRow() throws IOException {
        return this.fillRow(this.minColIndex, this.maxColIndex);
    }

    private boolean fillRow(int minColIndex, int maxColIndex) throws IOException {
        this.byteOutputStream.reset();
        try {
            if (this.rs.isAfterLast() || !this.rs.next()) {
                return false;
            }
            if (this.convertToString) {
                String[] tokens;
                for (String tok : tokens = DBManager.lineToArray(this.rs, minColIndex, maxColIndex, false)) {
                    this.dataOutputStream.write(tok.getBytes());
                    this.dataOutputStream.write(TAB_BYTES);
                }
                this.dataOutputStream.write(NEWLINE_BYTES);
            } else {
                int maxCol = Math.min(this.rs.getMetaData().getColumnCount(), maxColIndex);
                block6: for (int cc = minColIndex; cc <= maxCol; ++cc) {
                    int type = this.rs.getMetaData().getColumnType(cc);
                    switch (type) {
                        case 4: 
                        case 16: {
                            int val = this.rs.getInt(cc);
                            this.dataOutputStream.writeInt(val);
                            continue block6;
                        }
                        default: {
                            String sval = this.rs.getString(cc);
                            this.dataOutputStream.writeUTF(sval);
                        }
                    }
                }
            }
        }
        catch (SQLException e2) {
            throw new IOException(e2);
        }
        this.dataOutputStream.flush();
        this.setBuf(this.byteOutputStream.toByteArray());
        return true;
    }

    private synchronized void setBuf(byte[] buf) {
        this.inputStream = new ByteArrayInputStream(buf);
    }

    @Override
    public int read() throws IOException {
        int next = this.inputStream.read();
        if (next < 0) {
            if (this.fillRow()) {
                return this.inputStream.read();
            }
            return -1;
        }
        return next;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int numRead = this.inputStream.read(b2, off, len);
        if (this.inputStream.available() <= 0) {
            this.fillRow();
        }
        return numRead;
    }

    @Override
    public void close() throws IOException {
        try {
            this.dataOutputStream.close();
            super.close();
            this.rs.close();
        }
        catch (SQLException e2) {
            throw new IOException(e2);
        }
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    public boolean hasNext() {
        try {
            return !this.rs.isAfterLast();
        }
        catch (SQLException e2) {
            return false;
        }
    }
}

