/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.rans;

import java.nio.ByteBuffer;

class Encoding {
    Encoding() {
    }

    static void RansEncSymbolInit(RansEncSymbol s2, int start, int freq, int scale_bits) {
        s2.x_max = (0x800000 >> scale_bits << 8) * freq;
        s2.cmpl_freq = (1 << scale_bits) - freq;
        if (freq < 2) {
            s2.rcp_freq = -1;
            s2.rcp_shift = 0;
            s2.bias = start + (1 << scale_bits) - 1;
        } else {
            int shift = 0;
            while ((long)freq > 1L << shift) {
                ++shift;
            }
            s2.rcp_freq = (int)(((1L << shift + 31) + (long)freq - 1L) / (long)freq);
            s2.rcp_shift = shift - 1;
            s2.bias = start;
        }
        s2.rcp_shift += 32;
    }

    static int RansEncPutSymbol(int r2, ByteBuffer ptr, RansEncSymbol sym) {
        assert (sym.x_max != 0);
        int x2 = r2;
        int x_max = sym.x_max;
        if (x2 >= x_max && x2 >= x_max) {
            ptr.put((byte)(x2 & 0xFF));
            if ((x2 >>= 8) >= x_max) {
                ptr.put((byte)(x2 & 0xFF));
                x2 >>= 8;
            }
        }
        long q2 = (long)x2 * (0xFFFFFFFFL & (long)sym.rcp_freq) >> sym.rcp_shift;
        r2 = (int)((long)(x2 + sym.bias) + q2 * (long)sym.cmpl_freq);
        return r2;
    }

    static class RansEncSymbol {
        int x_max;
        int rcp_freq;
        int bias;
        int cmpl_freq;
        int rcp_shift;

        RansEncSymbol() {
        }
    }
}

