/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class CramContainerIterator
implements Iterator<Container> {
    private CramHeader cramHeader;
    private InputStream inputStream;
    private Container nextContainer;
    private boolean eof = false;
    private long offset = 0L;

    public CramContainerIterator(InputStream inputStream) throws IOException {
        this.cramHeader = CramIO.readCramHeader(inputStream);
        this.inputStream = inputStream;
    }

    void readNextContainer() {
        try {
            CountingInputStream cis = new CountingInputStream(this.inputStream);
            this.nextContainer = ContainerIO.readContainer(this.cramHeader.getVersion(), (InputStream)cis);
            long containerSizeInBytes = cis.getCount();
            this.nextContainer.offset = this.offset;
            this.offset += containerSizeInBytes;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        if (this.nextContainer.isEOF()) {
            this.eof = true;
            this.nextContainer = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.eof) {
            return false;
        }
        if (this.nextContainer == null) {
            this.readNextContainer();
        }
        return !this.eof;
    }

    @Override
    public Container next() {
        Container result = this.nextContainer;
        this.nextContainer = null;
        return result;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Read only iterator.");
    }

    public CramHeader getCramHeader() {
        return this.cramHeader;
    }

    public void close() {
        this.nextContainer = null;
        this.cramHeader = null;
        try {
            this.inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

