/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Ensure that all mate-pair information is in sync between each read and its mate pair.  If no OUTPUT file is supplied then the output is written to a temporary file and then copied over the INPUT file.  Reads marked with the secondary alignment flag are written to the output file unchanged.", usageShort="Ensure that all mate-pair information is in sync between each read and its mate pair", programGroup=SamOrBam.class)
public class FixMateInformation
extends CommandLineProgram {
    @Option(shortName="I", doc="The input file to fix.")
    public List<File> INPUT;
    @Option(shortName="O", optional=true, doc="The output file to write to. If no output file is supplied, the input file is overwritten.")
    public File OUTPUT;
    @Option(shortName="SO", optional=true, doc="Optional sort order if the OUTPUT file should be sorted differently than the INPUT file.")
    public SAMFileHeader.SortOrder SORT_ORDER;
    @Option(doc="If true, assume that the input file is queryname sorted, even if the header says otherwise.", shortName="AS")
    public boolean ASSUME_SORTED = false;
    @Option(shortName="MC", optional=true, doc="Adds the mate CIGAR tag (MC) if true, does not if false.")
    public Boolean ADD_MATE_CIGAR = true;
    private static final Log log = Log.getInstance(FixMateInformation.class);
    protected SAMFileWriter out;

    public static void main(String[] args) {
        new FixMateInformation().instanceMainWithExit(args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doWork() {
        SamPairUtil.SetMateInfoIterator iterator;
        SAMFileHeader header;
        CloseableIterator<SAMRecord> tmp;
        boolean differentOutputSpecified;
        boolean allQueryNameSorted = true;
        ArrayList<SamReader> readers = new ArrayList<SamReader>();
        for (File f2 : this.INPUT) {
            IOUtil.assertFileIsReadable(f2);
            SAMFileReader reader = new SAMFileReader(f2);
            readers.add(reader);
            if (reader.getFileHeader().getSortOrder() == SAMFileHeader.SortOrder.queryname) continue;
            allQueryNameSorted = false;
        }
        if (this.OUTPUT != null) {
            this.OUTPUT = this.OUTPUT.getAbsoluteFile();
        }
        boolean bl = differentOutputSpecified = this.OUTPUT != null;
        if (differentOutputSpecified) {
            IOUtil.assertFileIsWritable(this.OUTPUT);
        } else {
            if (this.INPUT.size() != 1) {
                throw new PicardException("Must specify either an explicit OUTPUT file or a single INPUT file to be overridden.");
            }
            File soleInput = this.INPUT.get(0).getAbsoluteFile();
            File dir = soleInput.getParentFile().getAbsoluteFile();
            try {
                IOUtil.assertFileIsWritable(soleInput);
                IOUtil.assertDirectoryIsWritable(dir);
                this.OUTPUT = File.createTempFile(soleInput.getName() + ".being_fixed.", ".bam", dir);
            }
            catch (IOException ioe) {
                throw new RuntimeIOException("Could not create tmp file in " + dir.getAbsolutePath());
            }
        }
        if (this.INPUT.size() > 1) {
            ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(readers.size());
            for (SAMFileReader sAMFileReader : readers) {
                headers.add(sAMFileReader.getFileHeader());
            }
            SAMFileHeader.SortOrder sortOrder = allQueryNameSorted ? SAMFileHeader.SortOrder.queryname : SAMFileHeader.SortOrder.unsorted;
            SamFileHeaderMerger samFileHeaderMerger = new SamFileHeaderMerger(sortOrder, headers, false);
            tmp = new MergingSamRecordIterator(samFileHeaderMerger, readers, false);
            header = samFileHeaderMerger.getMergedHeader();
        } else {
            tmp = ((SAMFileReader)readers.get(0)).iterator();
            header = ((SAMFileReader)readers.get(0)).getFileHeader();
        }
        if (this.ASSUME_SORTED || allQueryNameSorted) {
            iterator = new SamPairUtil.SetMateInfoIterator(new PeekableIterator<SAMRecord>(tmp), this.ADD_MATE_CIGAR);
        } else {
            log.info("Sorting input into queryname order.");
            final SortingCollection<SAMRecord> sorter = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(header), new SAMRecordQueryNameComparator(), (int)this.MAX_RECORDS_IN_RAM, this.TMP_DIR);
            while (tmp.hasNext()) {
                sorter.add((SAMRecord)tmp.next());
            }
            iterator = new SamPairUtil.SetMateInfoIterator((Iterator<SAMRecord>)new PeekableIterator<SAMRecord>(sorter.iterator()){

                @Override
                public void close() {
                    super.close();
                    sorter.cleanup();
                }
            }, this.ADD_MATE_CIGAR);
            log.info("Sorting by queryname complete.");
        }
        SAMFileHeader.SortOrder outputSortOrder = this.SORT_ORDER == null ? ((SAMFileReader)readers.get(0)).getFileHeader().getSortOrder() : this.SORT_ORDER;
        log.info("Output will be sorted by " + (Object)((Object)outputSortOrder));
        header.setSortOrder(outputSortOrder);
        if (this.CREATE_INDEX.booleanValue() && header.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("Can't CREATE_INDEX unless sort order is coordinate");
        }
        this.createSamFileWriter(header);
        log.info("Traversing query name sorted records and fixing up mate pair information.");
        ProgressLogger progress = new ProgressLogger(log);
        while (((PeekableIterator)iterator).hasNext()) {
            SAMRecord record = (SAMRecord)((PeekableIterator)iterator).next();
            this.out.addAlignment(record);
            progress.record(record);
        }
        iterator.close();
        if (header.getSortOrder() == SAMFileHeader.SortOrder.queryname) {
            log.info("Closing output file.");
        } else {
            log.info("Finished processing reads; re-sorting output file.");
        }
        this.closeWriter();
        if (differentOutputSpecified) return 0;
        log.info("Replacing input file with fixed file.");
        File soleInput = this.INPUT.get(0).getAbsoluteFile();
        File old = new File(soleInput.getParentFile(), soleInput.getName() + ".old");
        if (!old.exists() && soleInput.renameTo(old)) {
            File oldIndex;
            if (!this.OUTPUT.renameTo(soleInput)) {
                log.error("Could not move new file to " + soleInput.getAbsolutePath());
                log.error("Input file preserved as: " + old.getAbsolutePath());
                log.error("New file preserved as: " + this.OUTPUT.getAbsolutePath());
                return 1;
            }
            if (!old.delete()) {
                log.warn("Could not delete old file: " + old.getAbsolutePath());
                return 1;
            }
            if (this.CREATE_INDEX == false) return 0;
            File file = new File(this.OUTPUT.getParent(), this.OUTPUT.getName().substring(0, this.OUTPUT.getName().length() - 4) + ".bai");
            if (file.renameTo(oldIndex = new File(soleInput.getParent(), soleInput.getName().substring(0, soleInput.getName().length() - 4) + ".bai"))) return 0;
            log.warn("Could not overwrite index file: " + oldIndex.getAbsolutePath());
            return 0;
        }
        log.error("Could not move input file out of the way: " + soleInput.getAbsolutePath());
        if (this.OUTPUT.delete()) return 1;
        log.error("Could not delete temporary file: " + this.OUTPUT.getAbsolutePath());
        return 1;
    }

    protected void createSamFileWriter(SAMFileHeader header) {
        this.out = new SAMFileWriterFactory().makeSAMOrBAMWriter(header, header.getSortOrder() == SAMFileHeader.SortOrder.queryname, this.OUTPUT);
    }

    protected void writeAlignment(SAMRecord sam) {
        this.out.addAlignment(sam);
    }

    protected void closeWriter() {
        this.out.close();
    }
}

