/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.AbstractList;
import java.util.ArrayList;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.AbstractPathElement;

abstract class AbstractPathElementList<V, E, T extends AbstractPathElement<V, E>>
extends AbstractList<T> {
    protected Graph<V, E> graph;
    protected int maxSize;
    protected ArrayList<T> pathElements = new ArrayList();
    protected V vertex;

    protected AbstractPathElementList(Graph<V, E> graph, int n2, AbstractPathElementList<V, E, T> abstractPathElementList, E e2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize is negative or 0");
        }
        if (abstractPathElementList == null) {
            throw new NullPointerException("elementList is null");
        }
        if (e2 == null) {
            throw new NullPointerException("edge is null");
        }
        this.graph = graph;
        this.maxSize = n2;
        this.vertex = Graphs.getOppositeVertex(graph, e2, abstractPathElementList.getVertex());
    }

    protected AbstractPathElementList(Graph<V, E> graph, int n2, T t2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize is negative or 0");
        }
        if (t2 == null) {
            throw new NullPointerException("pathElement is null");
        }
        if (((AbstractPathElement)t2).getPrevEdge() != null) {
            throw new IllegalArgumentException("path must be empty");
        }
        this.graph = graph;
        this.maxSize = n2;
        this.vertex = ((AbstractPathElement)t2).getVertex();
        this.pathElements.add(t2);
    }

    protected AbstractPathElementList(Graph<V, E> graph, int n2, V v2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize is negative or 0");
        }
        this.graph = graph;
        this.maxSize = n2;
        this.vertex = v2;
    }

    @Override
    public T get(int n2) {
        return (T)((AbstractPathElement)this.pathElements.get(n2));
    }

    public V getVertex() {
        return this.vertex;
    }

    @Override
    public int size() {
        return this.pathElements.size();
    }
}

