/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.bson.util.Assertions;
import org.bson.util.CopyOnWriteMap;
import org.bson.util.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComputingMap<K, V>
implements Map<K, V>,
Function<K, V> {
    private final ConcurrentMap<K, V> map;
    private final Function<K, V> function;

    public static <K, V> Map<K, V> create(Function<K, V> function) {
        return new ComputingMap(CopyOnWriteMap.newHashMap(), function);
    }

    ComputingMap(ConcurrentMap<K, V> map, Function<K, V> function) {
        this.map = Assertions.notNull("map", map);
        this.function = Assertions.notNull("function", function);
    }

    @Override
    public V get(Object key) {
        Object v2;
        while ((v2 = this.map.get(key)) == null) {
            Object k2 = key;
            V value = this.function.apply(k2);
            if (value == null) {
                return null;
            }
            this.map.putIfAbsent(k2, value);
        }
        return v2;
    }

    @Override
    public V apply(K k2) {
        return this.get(k2);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.map.replace(key, value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m2) {
        this.map.putAll(m2);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o2) {
        return this.map.equals(o2);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

