/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import com.google.java.contract.Ensures;
import org.broadinstitute.gatk.utils.MathUtils;

public class QualityUtils {
    public static final byte MAX_SAM_QUAL_SCORE = 93;
    private static final double RAW_MIN_PHRED_SCALED_QUAL = Math.log10(Double.MIN_VALUE);
    protected static final double MIN_PHRED_SCALED_QUAL = -10.0 * RAW_MIN_PHRED_SCALED_QUAL;
    public static final byte MAX_REASONABLE_Q_SCORE = 60;
    public static final byte MIN_USABLE_Q_SCORE = 6;
    public static final int MAPPING_QUALITY_UNAVAILABLE = 255;
    public static final int MAX_QUAL = 254;
    private static double[] qualToErrorProbCache = new double[255];
    private static double[] qualToProbLog10Cache = new double[255];

    private QualityUtils() {
    }

    @Ensures(value={"result >= 0.0 && result <= 1.0"})
    public static double qualToProb(byte qual) {
        return 1.0 - QualityUtils.qualToErrorProb(qual);
    }

    @Ensures(value={"result >= 0.0 && result <= 1.0"})
    public static double qualToProb(double qual) {
        if (qual < 0.0) {
            throw new IllegalArgumentException("qual must be >= 0.0 but got " + qual);
        }
        return 1.0 - QualityUtils.qualToErrorProb(qual);
    }

    @Ensures(value={"result <= 0.0"})
    public static double qualToProbLog10(byte qual) {
        return qualToProbLog10Cache[qual & 0xFF];
    }

    @Ensures(value={"result >= 0.0 && result <= 1.0"})
    public static double qualToErrorProb(double qual) {
        if (qual < 0.0) {
            throw new IllegalArgumentException("qual must be >= 0.0 but got " + qual);
        }
        return Math.pow(10.0, qual / -10.0);
    }

    @Ensures(value={"result >= 0.0 && result <= 1.0"})
    public static double qualToErrorProb(byte qual) {
        return qualToErrorProbCache[qual & 0xFF];
    }

    @Ensures(value={"result <= 0.0"})
    public static double qualToErrorProbLog10(byte qual) {
        return QualityUtils.qualToErrorProbLog10(qual & 0xFF);
    }

    @Ensures(value={"result <= 0.0"})
    public static double qualToErrorProbLog10(double qual) {
        if (qual < 0.0) {
            throw new IllegalArgumentException("qual must be >= 0.0 but got " + qual);
        }
        return qual / -10.0;
    }

    public static byte errorProbToQual(double errorRate) {
        return QualityUtils.errorProbToQual(errorRate, (byte)93);
    }

    public static byte errorProbToQual(double errorRate, byte maxQual) {
        if (!MathUtils.goodProbability(errorRate)) {
            throw new IllegalArgumentException("errorRate must be good probability but got " + errorRate);
        }
        double d2 = Math.round(-10.0 * Math.log10(errorRate));
        return QualityUtils.boundQual((int)d2, maxQual);
    }

    public static byte errorProbToQual(double prob, int maxQual) {
        if (maxQual < 0 || maxQual > 255) {
            throw new IllegalArgumentException("maxQual must be between 0-255 but got " + maxQual);
        }
        return QualityUtils.errorProbToQual(prob, (byte)(maxQual & 0xFF));
    }

    public static byte trueProbToQual(double prob) {
        return QualityUtils.trueProbToQual(prob, (byte)93);
    }

    @Ensures(value={"(result & 0xFF) >= 1 && (result & 0xFF) <= (maxQual & 0xFF)"})
    public static byte trueProbToQual(double trueProb, byte maxQual) {
        if (!MathUtils.goodProbability(trueProb)) {
            throw new IllegalArgumentException("trueProb must be good probability but got " + trueProb);
        }
        double lp = Math.round(-10.0 * MathUtils.log10OneMinusX(trueProb));
        return QualityUtils.boundQual((int)lp, maxQual);
    }

    public static byte trueProbToQual(double prob, int maxQual) {
        if (maxQual < 0 || maxQual > 255) {
            throw new IllegalArgumentException("maxQual must be between 0-255 but got " + maxQual);
        }
        return QualityUtils.trueProbToQual(prob, (byte)(maxQual & 0xFF));
    }

    @Ensures(value={"result >= 0.0"})
    public static double phredScaleCorrectRate(double trueRate) {
        return QualityUtils.phredScaleLog10ErrorRate(MathUtils.log10OneMinusX(trueRate));
    }

    @Ensures(value={"result >= 0.0"})
    public static double phredScaleLog10CorrectRate(double trueRateLog10) {
        return QualityUtils.phredScaleCorrectRate(Math.pow(10.0, trueRateLog10));
    }

    @Ensures(value={"result >= 0.0"})
    public static double phredScaleErrorRate(double errorRate) {
        return QualityUtils.phredScaleLog10ErrorRate(Math.log10(errorRate));
    }

    @Ensures(value={"result >= 0.0"})
    public static double phredScaleLog10ErrorRate(double errorRateLog10) {
        if (!MathUtils.goodLog10Probability(errorRateLog10)) {
            throw new IllegalArgumentException("errorRateLog10 must be good probability but got " + errorRateLog10);
        }
        return Math.abs(-10.0 * Math.max(errorRateLog10, RAW_MIN_PHRED_SCALED_QUAL));
    }

    @Ensures(value={"(result & 0xFF) >= 1 && (result & 0xFF) <= (MAX_SAM_QUAL_SCORE & 0xFF)"})
    public static byte boundQual(int qual) {
        return QualityUtils.boundQual(qual, (byte)93);
    }

    @Ensures(value={"(result & 0xFF) >= 1 && (result & 0xFF) <= (maxQual & 0xFF)"})
    public static byte boundQual(int qual, byte maxQual) {
        return (byte)(Math.max(Math.min(qual, maxQual & 0xFF), 1) & 0xFF);
    }

    static {
        for (int i2 = 0; i2 <= 254; ++i2) {
            QualityUtils.qualToErrorProbCache[i2] = QualityUtils.qualToErrorProb(i2);
            QualityUtils.qualToProbLog10Cache[i2] = Math.log10(1.0 - qualToErrorProbCache[i2]);
        }
    }
}

