/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stats;

import java.io.PrintWriter;

public class Distribution {
    private int minBin = 0;
    private int maxBin;
    private int nBins;
    private final double[] freq;
    private int n;

    public Distribution(int maxBin) {
        this.maxBin = maxBin;
        int nBins = maxBin - this.minBin + 1;
        this.freq = new double[nBins];
    }

    public Distribution(int minBin, int maxBin) {
        this.minBin = minBin;
        this.maxBin = maxBin;
        int nBins = maxBin - minBin + 1;
        this.freq = new double[nBins];
    }

    public void addDataPoint(int i2) {
        int idx;
        int bin = i2 - this.minBin;
        int n2 = idx = Math.max(0, Math.min(this.nBins - 1, i2));
        this.freq[n2] = this.freq[n2] + 1.0;
        ++this.n;
    }

    public double[] getDist() {
        return this.freq;
    }

    public void print(PrintWriter pw) {
        boolean start = false;
        for (int i2 = 0; i2 <= this.maxBin; ++i2) {
            start = true;
            float frac = (float)this.freq[i2] / (float)this.n;
            pw.println(i2 - this.minBin + "\t" + this.freq[i2]);
        }
    }
}

