/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGV;

public class UIUtilities {
    private static final Logger log = Logger.getLogger(UIUtilities.class);
    private static final StringBuffer scratchBuffer = new StringBuffer();

    public static Color showColorChooserDialog(String dialogTitle, Color defaultColor) {
        Color color = null;
        JColorChooser chooser = new JColorChooser();
        chooser.setColor(defaultColor);
        do {
            int response;
            if ((response = JOptionPane.showConfirmDialog(IGV.getMainFrame(), chooser, dialogTitle, 2)) != 2 && response != -1) continue;
            return null;
        } while ((color = chooser.getColor()) == null);
        return color;
    }

    public static boolean showConfirmationDialog(Component parent, String message) {
        int status = JOptionPane.showConfirmDialog(parent, message, null, 2, -1, null);
        return status != 2 && status != -1;
    }

    public static String getcommaSeparatedRGBString(Color color) {
        if (color != null) {
            scratchBuffer.delete(0, scratchBuffer.length());
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            scratchBuffer.append(red);
            scratchBuffer.append(",");
            scratchBuffer.append(green);
            scratchBuffer.append(",");
            scratchBuffer.append(blue);
        }
        return scratchBuffer.toString();
    }

    public static void centerWindow(Window window) {
        Dimension dimension = window.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x2 = (screenSize.width - dimension.width) / 2;
        int y = (screenSize.height - dimension.height) / 2;
        window.setLocation(x2, y);
        window.requestFocus();
    }

    public static void invokeOnEventThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeAndWaitOnEventThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e2) {
                log.error("Error invoking runnable", e2);
            }
            catch (InvocationTargetException e3) {
                log.error("Error invoking runnable", e3);
            }
        }
    }

    public static String bringToFront() {
        Frame mainFrame = IGV.getMainFrame();
        mainFrame.toFront();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setAlwaysOnTop(false);
        return "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activateMainFrame() {
        Frame mainFrame = IGV.getMainFrame();
        try {
            Point oldMouseLocation = MouseInfo.getPointerInfo().getLocation();
            Robot robot = new Robot();
            robot.mouseMove(mainFrame.getX() + 200, mainFrame.getY() + 5);
            robot.mousePress(1024);
            robot.mouseRelease(1024);
            robot.mouseMove((int)oldMouseLocation.getX(), (int)oldMouseLocation.getY());
        }
        catch (Exception exception) {}
    }
}

