/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedHashMap;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.broad.igv.ui.util.SnapshotUtilities;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.Utilities;

public class SnapshotFileChooser
extends JFileChooser {
    private static LinkedHashMap<SnapshotFileType, SnapshotFileFilter> SNAPSHOT_TYPE_TO_FILTER = new LinkedHashMap();
    boolean accepted = false;
    File previousFile;

    public static SnapshotFileType getSnapshotFileType(String fileExtension) {
        String extension = fileExtension.toLowerCase();
        SnapshotFileType type = SnapshotFileType.NULL;
        if (".jpg".equalsIgnoreCase(fileExtension)) {
            type = SnapshotFileType.JPEG;
        }
        for (SnapshotFileType iterType : SnapshotFileType.values()) {
            if (type != SnapshotFileType.NULL) break;
            if (!iterType.getExtension().equalsIgnoreCase(extension)) continue;
            type = iterType;
        }
        return type;
    }

    public SnapshotFileChooser(File directory, File selectedFile) {
        super(directory);
        this.setPreviousFile(selectedFile);
        this.init();
    }

    @Override
    public void approveSelection() {
        this.accepted = true;
        super.approveSelection();
    }

    public void setPreviousFile(File file) {
        this.previousFile = file;
        this.setSelectedFile(this.previousFile);
    }

    public File getPreviousFile() {
        return this.previousFile;
    }

    @Override
    public void cancelSelection() {
        this.setSelectedFile(null);
        super.cancelSelection();
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        dialog.setLocation(300, 200);
        dialog.setResizable(false);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                if (!SnapshotFileChooser.this.accepted) {
                    SnapshotFileChooser.this.setSelectedFile(null);
                }
            }
        });
        return dialog;
    }

    private void init() {
        FileFilter[] fileFilters;
        if (SnapshotUtilities.canExportScreenshotEps()) {
            SNAPSHOT_TYPE_TO_FILTER.put(SnapshotFileType.EPS, new SnapshotFileFilter(SnapshotFileType.EPS));
        }
        if ((fileFilters = SNAPSHOT_TYPE_TO_FILTER.values().toArray(new FileFilter[SNAPSHOT_TYPE_TO_FILTER.size()])) != null) {
            for (FileFilter fileFilter : fileFilters) {
                this.addChoosableFileFilter(fileFilter);
            }
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
                File oldFile = null;
                String property = e2.getPropertyName();
                if ("SelectedFileChangedProperty".equals(property)) {
                    oldFile = (File)e2.getOldValue();
                } else if ("fileFilterChanged".equals(property) && e2.getOldValue() instanceof SnapshotFileFilter && e2.getNewValue() instanceof SnapshotFileFilter) {
                    SnapshotFileFilter newFilter = (SnapshotFileFilter)e2.getNewValue();
                    File currentDirectory = SnapshotFileChooser.this.getCurrentDirectory();
                    File previousFile = SnapshotFileChooser.this.getPreviousFile();
                    if (previousFile != null) {
                        File file = null;
                        file = currentDirectory != null ? new File(currentDirectory, previousFile.getName()) : previousFile;
                        final File selectedFile = Utilities.changeFileExtension(file, newFilter.getExtension());
                        UIUtilities.invokeOnEventThread(new Runnable(){

                            @Override
                            public void run() {
                                SnapshotFileChooser.this.setPreviousFile(selectedFile);
                                SnapshotFileChooser.this.validate();
                            }
                        });
                    }
                }
            }
        });
        this.setFileFilter(SNAPSHOT_TYPE_TO_FILTER.get((Object)SnapshotFileType.PNG));
    }

    static {
        SNAPSHOT_TYPE_TO_FILTER.put(SnapshotFileType.JPEG, new SnapshotFileFilter(SnapshotFileType.JPEG));
        SNAPSHOT_TYPE_TO_FILTER.put(SnapshotFileType.SVG, new SnapshotFileFilter(SnapshotFileType.SVG));
        SNAPSHOT_TYPE_TO_FILTER.put(SnapshotFileType.PNG, new SnapshotFileFilter(SnapshotFileType.PNG));
    }

    public static class SnapshotFileFilter
    extends FileFilter {
        private SnapshotFileType type = SnapshotFileType.EPS;

        public SnapshotFileFilter(SnapshotFileType type) {
            this.type = type;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(this.type.getExtension());
        }

        @Override
        public String getDescription() {
            return this.type.getDescription();
        }

        public String getExtension() {
            return this.type.getExtension();
        }

        public boolean accept(File file, String name) {
            return name.toLowerCase().endsWith(this.type.getExtension());
        }
    }

    public static enum SnapshotFileType {
        NULL("", ""),
        EPS(".eps", "Encapsulated Postscript Files (*.eps)"),
        PDF(".pdf", "Portable Document FormatFles (*.pdf)"),
        SVG(".svg", "Scalable Vector Graphics Files (*.svg)"),
        PNG(".png", "Portable Network Graphics Files (*.png)"),
        JPEG(".jpeg", "Joint Photographic Experts Group Files (*.jpeg)");

        private String fileExtension;
        private String fileDescription;

        private SnapshotFileType(String extension, String description) {
            this.fileExtension = extension;
            this.fileDescription = description;
        }

        public String getExtension() {
            return this.fileExtension;
        }

        public String getDescription() {
            return this.fileDescription;
        }
    }
}

