/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;

public class FontChooser
extends JDialog {
    private Font selectedFont;
    boolean canceled = false;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JComboBox sizeComboBox;
    private JLabel label1;
    private JCheckBox boldCB;
    private JCheckBox italicCB;
    private JTextPane exampleLabel;
    private JScrollPane scrollPane1;
    private JList fontList;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public FontChooser(Dialog owner, Font font) {
        super(owner);
        this.initComponents();
        this.setTitle("Font Chooser");
        this.init(font);
    }

    private void init(Font font) {
        this.selectedFont = font;
        String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontList.setListData(fontFamilies);
        String family = font.getFamily();
        this.fontList.setSelectedValue(font.getFamily(), true);
        this.sizeComboBox.setSelectedItem(String.valueOf(font.getSize()));
        this.exampleLabel.setFont(font);
    }

    private void fontListValueChanged(ListSelectionEvent e2) {
        this.updateFont();
    }

    private void sizeComboBoxActionPerformed(ActionEvent e2) {
        this.updateFont();
    }

    private void boldCBActionPerformed(ActionEvent e2) {
        this.updateFont();
    }

    private void italicCBActionPerformed(ActionEvent e2) {
        this.updateFont();
    }

    private void okButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.canceled = true;
        this.setVisible(false);
    }

    private void updateFont() {
        String fontName = (String)this.fontList.getSelectedValue();
        int size = Integer.parseInt((String)this.sizeComboBox.getSelectedItem());
        boolean isBold = this.boldCB.isSelected();
        boolean isItalic = this.italicCB.isSelected();
        int attrs = 0;
        if (isBold) {
            attrs = 1;
        }
        if (isItalic) {
            attrs |= 2;
        }
        this.selectedFont = new Font(fontName, attrs, size);
        this.exampleLabel.setFont(this.selectedFont);
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.sizeComboBox = new JComboBox();
        this.label1 = new JLabel();
        this.boldCB = new JCheckBox();
        this.italicCB = new JCheckBox();
        this.exampleLabel = new JTextPane();
        this.scrollPane1 = new JScrollPane();
        this.fontList = new JList();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.sizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"6", "8", "9", "10", "11", "12", "14", "16", "20", "24"}));
        this.sizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FontChooser.this.sizeComboBoxActionPerformed(e2);
            }
        });
        this.label1.setText("Size");
        this.label1.setLabelFor(this.sizeComboBox);
        this.boldCB.setText("<html><b>Bold");
        this.boldCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FontChooser.this.boldCBActionPerformed(e2);
            }
        });
        this.italicCB.setText("<html><i>Italic");
        this.italicCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FontChooser.this.italicCBActionPerformed(e2);
            }
        });
        this.exampleLabel.setText("Lorem ipsum dolor sit amet, consectetur adipiscing elit.");
        this.fontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                FontChooser.this.fontListValueChanged(e2);
            }
        });
        this.scrollPane1.setViewportView(this.fontList);
        GroupLayout contentPanelLayout = new GroupLayout(this.contentPanel);
        this.contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup().add(contentPanelLayout.createSequentialGroup().addContainerGap().add(this.scrollPane1, -2, 274, -2).add(22, 22, 22).add(contentPanelLayout.createParallelGroup(2).add(contentPanelLayout.createSequentialGroup().add(contentPanelLayout.createParallelGroup().add(contentPanelLayout.createSequentialGroup().add(this.label1, -2, 52, -2).addPreferredGap(0).add(this.sizeComboBox, -2, -1, -2)).add(this.boldCB, -2, -1, -2).add(this.italicCB, -2, -1, -2)).add(66, 66, 66)).add(contentPanelLayout.createSequentialGroup().add(this.exampleLabel, -2, 198, -2).addContainerGap()))));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup().add(contentPanelLayout.createSequentialGroup().addContainerGap().add(contentPanelLayout.createParallelGroup().add(this.scrollPane1, -1, 264, Short.MAX_VALUE).add(contentPanelLayout.createSequentialGroup().add(contentPanelLayout.createParallelGroup(3).add(this.label1, -2, 22, -2).add(this.sizeComboBox, -2, -1, -2)).addPreferredGap(0).add(this.boldCB, -2, -1, -2).add(5, 5, 5).add(this.italicCB, -2, -1, -2).addPreferredGap(0, 57, Short.MAX_VALUE).add(this.exampleLabel, -2, 123, -2))).addContainerGap()));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FontChooser.this.okButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FontChooser.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(530, 365);
        this.setLocationRelativeTo(this.getOwner());
    }
}

