/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Locus;
import org.broad.igv.lists.GeneList;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.SearchCommand;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;

public class FrameManager {
    private static List<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
    private static ReferenceFrame defaultFrame;
    public static final String DEFAULT_FRAME_NAME = "genome";

    public static synchronized ReferenceFrame getDefaultFrame() {
        if (defaultFrame == null) {
            defaultFrame = new ReferenceFrame(DEFAULT_FRAME_NAME);
        }
        return defaultFrame;
    }

    public static List<ReferenceFrame> getFrames() {
        return frames;
    }

    public static ReferenceFrame getFrame(String frameName) {
        for (ReferenceFrame frame : frames) {
            if (!frame.getName().equals(frameName)) continue;
            return frame;
        }
        return null;
    }

    public static void setFrames(List<ReferenceFrame> f2) {
        frames = f2;
    }

    public static boolean isGeneListMode() {
        return frames.size() > 1;
    }

    public static int getStateHash() {
        if (FrameManager.isGeneListMode()) {
            String hs = "";
            for (ReferenceFrame frame : frames) {
                hs = hs + frame.getStateHash();
            }
            return hs.hashCode();
        }
        return defaultFrame.getStateHash();
    }

    public static void setToDefaultFrame(String searchString) {
        Locus locus;
        frames.clear();
        if (searchString != null && (locus = FrameManager.getLocus(searchString, 0)) != null) {
            FrameManager.getDefaultFrame().jumpTo(locus);
        }
        frames.add(FrameManager.getDefaultFrame());
        FrameManager.getDefaultFrame().recordHistory();
    }

    private static boolean addNewFrame(String searchString) {
        boolean locusAdded = false;
        Locus locus = FrameManager.getLocus(searchString);
        if (locus != null) {
            ReferenceFrame referenceFrame = new ReferenceFrame(searchString);
            referenceFrame.jumpTo(locus);
            locusAdded = frames.add(referenceFrame);
        }
        return locusAdded;
    }

    public static void resetFrames(GeneList gl) {
        frames.clear();
        if (gl == null) {
            frames.add(FrameManager.getDefaultFrame());
        } else {
            ArrayList<String> lociNotFound = new ArrayList<String>();
            List<String> loci = gl.getLoci();
            if (loci.size() == 1) {
                Locus locus = FrameManager.getLocus(loci.get(0));
                if (locus == null) {
                    lociNotFound.add(loci.get(0));
                } else {
                    IGV.getInstance().getSession().setCurrentGeneList(null);
                    FrameManager.getDefaultFrame().jumpTo(locus.getChr(), locus.getStart(), locus.getEnd());
                }
            } else {
                for (String searchString : gl.getLoci()) {
                    if (FrameManager.addNewFrame(searchString)) continue;
                    lociNotFound.add(searchString);
                }
            }
            if (lociNotFound.size() > 1) {
                StringBuffer message = new StringBuffer();
                message.append("<html>The following loci could not be found in the currently loaded annotation sets: <br>");
                for (String s2 : lociNotFound) {
                    message.append(s2 + " ");
                }
                MessageUtils.showMessage(message.toString());
            }
        }
    }

    public static double getMinimumScale() {
        double minScale = Double.MAX_VALUE;
        for (ReferenceFrame frame : frames) {
            minScale = Math.min(minScale, frame.getScale());
        }
        return minScale;
    }

    public static Locus getLocus(String searchString) {
        int flankingRegion = PreferenceManager.getInstance().getAsInt("FLANKING_REGION");
        return FrameManager.getLocus(searchString, flankingRegion);
    }

    public static Locus getLocus(String searchString, int flankingRegion) {
        SearchCommand cmd = new SearchCommand(FrameManager.getDefaultFrame(), searchString);
        List<SearchCommand.SearchResult> results = cmd.runSearch(searchString);
        Locus locus = null;
        for (SearchCommand.SearchResult result : results) {
            int start;
            if (result.getType() == SearchCommand.ResultType.ERROR) continue;
            int delta = 0;
            if (result.getType() != SearchCommand.ResultType.LOCUS) {
                delta = flankingRegion < 0 ? -flankingRegion * (result.getEnd() - result.getStart()) / 100 : flankingRegion;
            }
            if ((start = result.getStart() - delta) < 0 && result.getStart() >= -1) {
                start = 0;
            }
            locus = new Locus(result.getChr(), start, result.getEnd() + delta);
            break;
        }
        return locus;
    }

    public static void removeFrame(ReferenceFrame frame) {
        frames.remove(frame);
    }

    public static void sortFrames(final Track t2) {
        Collections.sort(frames, new Comparator<ReferenceFrame>(){

            @Override
            public int compare(ReferenceFrame o1, ReferenceFrame o2) {
                float s2;
                float s1 = t2.getRegionScore(o1.getChromosome().getName(), (int)o1.getOrigin(), (int)o1.getEnd(), o1.getZoom(), RegionScoreType.SCORE, o1.getName());
                return s1 == (s2 = t2.getRegionScore(o2.getChromosome().getName(), (int)o2.getOrigin(), (int)o2.getEnd(), o2.getZoom(), RegionScoreType.SCORE, o2.getName())) ? 0 : (s1 > s2 ? -1 : 1);
            }
        });
    }

    public static void incrementZoom(int zoom) {
        if (FrameManager.isGeneListMode()) {
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                frame.doZoomIncrement(zoom);
            }
        } else {
            FrameManager.getDefaultFrame().doZoomIncrement(zoom);
        }
    }

    static {
        frames.add(FrameManager.getDefaultFrame());
    }
}

