/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.panel.DataPanelContainer;
import org.broad.igv.ui.panel.TrackPanel;

public class FitDataToWindowMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(FitDataToWindowMenuAction.class);
    IGV mainFrame;

    public FitDataToWindowMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        for (TrackPanel tp : IGV.getInstance().getTrackPanels()) {
            this.fitTracksToPanel(tp.getScrollPane().getDataPanel());
        }
        this.mainFrame.doRefresh();
    }

    private boolean fitTracksToPanel(DataPanelContainer dataPanel) {
        boolean success = true;
        int availableHeight = dataPanel.getVisibleHeight();
        int visibleTrackCount = 0;
        Collection<TrackGroup> groups = dataPanel.getTrackGroups();
        for (TrackGroup group : groups) {
            List<Track> tracks = group.getVisibleTracks();
            for (Track track : tracks) {
                if (!track.isVisible()) continue;
                ++visibleTrackCount;
            }
        }
        if (visibleTrackCount > 0) {
            int groupGapHeight = (groups.size() + 1) * 10;
            double adjustedAvailableHeight = Math.max(1, availableHeight - groupGapHeight);
            double delta = adjustedAvailableHeight / (double)visibleTrackCount;
            if (delta < 1.0) {
                delta = 1.0;
            }
            int iTotal = 0;
            double target = 0.0;
            for (TrackGroup group : groups) {
                List<Track> tracks = group.getVisibleTracks();
                for (Track track : tracks) {
                    int height = (int)((target += delta) - (double)iTotal);
                    track.setHeight(height);
                    iTotal += height;
                }
            }
        }
        return success;
    }
}

