/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.tribble.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;

public class PackedFeatures<T extends Feature> {
    protected String trackName;
    protected String chr;
    protected int start;
    protected int end;
    protected List<T> features;
    protected List<FeatureRow> rows;
    private static Logger log = Logger.getLogger(PackedFeatures.class);
    protected int maxFeatureLength = 0;
    protected static int maxLevels = 200;

    PackedFeatures() {
    }

    PackedFeatures(String chr, int start, int end) {
        this.chr = chr;
        this.start = start;
        this.end = end;
        this.features = Collections.emptyList();
        this.rows = Collections.emptyList();
    }

    PackedFeatures(String chr, int start, int end, Iterator<T> iter, String trackName) {
        this.trackName = trackName;
        this.chr = chr;
        this.start = start;
        this.end = end;
        this.features = new ArrayList<T>(1000);
        this.rows = this.packFeatures(iter);
    }

    protected int getFeatureStartForPacking(Feature feature) {
        return feature.getStart();
    }

    protected int getFeatureEndForPacking(Feature feature) {
        return feature.getEnd();
    }

    int getRowCount() {
        return this.getRows().size();
    }

    public boolean containsInterval(String chr, int start, int end) {
        return this.getChr().equals(chr) && start >= this.getStart() && end <= this.getEnd();
    }

    public boolean overlapsInterval(String chr, int start, int end) {
        return this.getChr().equals(chr) && start <= this.end && end >= this.start;
    }

    List<FeatureRow> packFeatures(Iterator iter) {
        ArrayList<FeatureRow> rows = new ArrayList<FeatureRow>(10);
        if (iter == null || !iter.hasNext()) {
            return rows;
        }
        this.maxFeatureLength = 0;
        int totalCount = 0;
        LinkedHashMap<Integer, PriorityQueue<Feature>> bucketArray = new LinkedHashMap<Integer, PriorityQueue<Feature>>();
        Comparator pqComparator = new Comparator<T>(){

            @Override
            public int compare(Feature row1, Feature row2) {
                return row2.getEnd() - row2.getStart() - (row1.getEnd() - row2.getStart());
            }
        };
        while (iter.hasNext()) {
            Feature feature = (Feature)iter.next();
            this.maxFeatureLength = Math.max(this.maxFeatureLength, this.getFeatureEndForPacking(feature) - this.getFeatureStartForPacking(feature));
            this.features.add(feature);
            int bucketNumber = this.getFeatureStartForPacking(feature);
            PriorityQueue<Feature> bucket = (PriorityQueue<Feature>)bucketArray.get(bucketNumber);
            if (bucket == null) {
                bucket = new PriorityQueue<Feature>(5, pqComparator);
                bucketArray.put(bucketNumber, bucket);
            }
            bucket.add(feature);
            ++totalCount;
        }
        FeatureRow currentRow = new FeatureRow();
        int allocatedCount = 0;
        int nextStart = Integer.MIN_VALUE;
        int lastAllocatedCount = -1;
        while (allocatedCount < totalCount && rows.size() < maxLevels) {
            if (lastAllocatedCount == allocatedCount) {
                if (!IGV.hasInstance()) break;
                String msg = "Infinite loop detected while packing features for track: " + this.getTrackName() + ".<br>Not all features will be shown." + "<br>Please contact igv-team@broadinstitute.org";
                log.error(msg);
                MessageUtils.showMessage(msg);
                break;
            }
            lastAllocatedCount = allocatedCount;
            PriorityQueue bucket = null;
            ArrayList<Integer> emptyBucketKeys = new ArrayList<Integer>();
            for (Integer key : bucketArray.keySet()) {
                if (key < nextStart) continue;
                bucket = (PriorityQueue)bucketArray.get(key);
                Feature feature = (Feature)bucket.poll();
                if (bucket.isEmpty()) {
                    emptyBucketKeys.add(key);
                }
                currentRow.addFeature(feature);
                nextStart = currentRow.end + 5;
                ++allocatedCount;
            }
            for (Integer key : emptyBucketKeys) {
                bucketArray.remove(key);
            }
            if (currentRow.features.size() > 0) {
                rows.add(currentRow);
                lastAllocatedCount = 0;
            }
            currentRow = new FeatureRow();
            nextStart = 0;
        }
        if (currentRow.features.size() > 0) {
            rows.add(currentRow);
        }
        return rows;
    }

    public String getTrackName() {
        return this.trackName;
    }

    public String getChr() {
        return this.chr;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public List<T> getFeatures() {
        return this.features;
    }

    public List<FeatureRow> getRows() {
        return this.rows;
    }

    public int getMaxFeatureLength() {
        return this.maxFeatureLength;
    }

    public class FeatureRow {
        int start;
        int end;
        List<T> features = new ArrayList(100);

        public void addFeature(T feature) {
            if (this.features.isEmpty()) {
                this.start = PackedFeatures.this.getFeatureStartForPacking((Feature)feature);
            }
            this.features.add(feature);
            this.end = PackedFeatures.this.getFeatureEndForPacking((Feature)feature);
        }

        public List<T> getFeatures() {
            return this.features;
        }
    }
}

