/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.cram;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.ref.ReferenceSource;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.util.ObjectCache;

public class IGVReferenceSource
extends ReferenceSource {
    ObjectCache<String, byte[]> cachedSequences = new ObjectCache(2);

    @Override
    public synchronized byte[] getReferenceBases(SAMSequenceRecord record, boolean tryNameVariants) {
        String name = record.getSequenceName();
        String igvName = GenomeManager.getInstance().getCurrentGenome().getCanonicalChrName(name);
        byte[] bases = this.cachedSequences.get(igvName);
        if (bases == null) {
            Chromosome chromosome = GenomeManager.getInstance().getCurrentGenome().getChromosome(igvName);
            bases = GenomeManager.getInstance().getCurrentGenome().getSequence(igvName, 0, chromosome.getLength());
            this.cachedSequences.put(igvName, bases);
        }
        return bases;
    }
}

