/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.genome.GenomeBuilderPane;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;

public class GenomeBuilderDialog
extends JDialog {
    boolean canceled;
    File archiveFile;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private GenomeBuilderPane panel1;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public GenomeBuilderDialog(Frame owner, IGV igv) {
        super(owner);
        this.setModal(true);
        this.initComponents();
        this.panel1.setIgv(igv);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public File getArchiveFile() {
        return this.archiveFile;
    }

    private void okButtonActionPerformed(ActionEvent e2) {
        boolean valid = this.validateFields();
        if (valid) {
            this.archiveFile = this.chooseArchiveFile();
            this.canceled = this.archiveFile == null;
            this.setVisible(false);
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private File chooseArchiveFile() {
        File dir = PreferenceManager.getInstance().getLastGenomeImportDirectory();
        File initFile = new File(this.getGenomeId() + ".genome");
        return FileDialogUtils.chooseFile("Save .genome file", dir, initFile, 1);
    }

    private boolean validateFields() {
        StringBuffer errors = new StringBuffer();
        String id = this.getGenomeId();
        String name = this.getGenomeDisplayName();
        String fastaFile = this.getFastaFileName();
        if (id == null || id.length() == 0) {
            errors.append(errors.length() == 0 ? "<html>" : "<br>");
            errors.append("Unique ID is required");
        }
        if (name == null || name.length() == 0) {
            errors.append(errors.length() == 0 ? "<html>" : "<br>");
            errors.append("Descriptive name is required");
        }
        if (fastaFile == null || fastaFile.length() == 0) {
            errors.append(errors.length() == 0 ? "<html>" : "<br>");
            errors.append("FASTA file is required");
        }
        if (errors.length() == 0) {
            return true;
        }
        MessageUtils.showMessage(errors.toString());
        return false;
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel1 = new GenomeBuilderPane();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.panel1, "Center");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GenomeBuilderDialog.this.okButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GenomeBuilderDialog.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(870, 430);
        this.setLocationRelativeTo(this.getOwner());
    }

    public String getCytobandFileName() {
        return this.panel1.getCytobandFileName();
    }

    public String getGeneAnnotFileName() {
        return this.panel1.getGeneAnnotFileName();
    }

    public String getFastaFileName() {
        return this.panel1.getFastaFileName();
    }

    public String getChrAliasFileName() {
        return this.panel1.getChrAliasFileName();
    }

    public String getGenomeDisplayName() {
        return this.panel1.getGenomeDisplayName();
    }

    public String getGenomeId() {
        return this.panel1.getGenomeId();
    }

    public String getArchiveFileName() {
        return this.panel1.getArchiveFileName();
    }
}

