/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cbio;

import biz.source_code.base64Coder.Base64Coder;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.Utilities;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.DirectedMultigraph;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeneNetwork
extends DirectedMultigraph<Node, Node> {
    private Logger log = Logger.getLogger(GeneNetwork.class);
    public static final String NODE_TAG = "node";
    public static final String EDGE_TAG = "edge";
    public static final String KEY = "key";
    public static final String LABEL = "label";
    static final String REAL_URL = "http://www.cbioportal.org/public-portal/network.do";
    static final String TEST_URL = "http://awabi.cbio.mskcc.org/public-portal/network.do";
    static String BASE_URL = "http://www.cbioportal.org/public-portal/network.do";
    private static final String common_parms = "format=gml&gzip=on";
    private static final String GENE_LIST = "gene_list";
    private List<Node> schema = new ArrayList<Node>();
    private NamedNodeMap graphAttr;
    private Document origDocument;
    static Map<String, RegionScoreType> attributeMap = new LinkedHashMap<String, RegionScoreType>();
    private static Map<String, float[]> bounds = new HashMap<String, float[]>(8);
    private DirectedMultigraph<Node, Node> origGraph;
    private static final Set<String> geneTypes = new HashSet<String>(5);
    static final Predicate<Node> isGene;
    static final Predicate<Node> isNotGene;
    static final Predicate<Node> inQuery;
    static final String PERCENT_MUTATED = "PERCENT_MUTATED";
    static final String PERCENT_CNA_AMPLIFIED = "PERCENT_CNA_AMPLIFIED";
    static final String PERCENT_CNA_HOMOZYGOUSLY_DELETED = "PERCENT_CNA_HOMOZYGOUSLY_DELETED";
    static final String PERCENT_MRNA_WAY_UP = "PERCENT_MRNA_WAY_UP";
    static final String PERCENT_MRNA_WAY_DOWN = "PERCENT_MRNA_WAY_DOWN";
    public static final String PERCENT_ALTERED = "PERCENT_ALTERED";
    private String sourcePath;

    String getSourcePath() {
        return this.sourcePath;
    }

    GeneNetwork() {
        this(Node.class);
    }

    GeneNetwork(EdgeFactory edgeFactory) {
        super(edgeFactory);
    }

    private GeneNetwork(Class clazz) {
        super(clazz);
    }

    private Set<Node> filter(Predicate<Node> predicate, Collection<Node> objects) {
        HashSet<Node> rejectedSet = new HashSet<Node>(objects.size());
        for (Node v2 : objects) {
            if (predicate.apply(v2)) continue;
            rejectedSet.add(v2);
        }
        return rejectedSet;
    }

    private int filterNodes(Predicate<Node> predicate) {
        Set<Node> rejectedSet = this.filter(predicate, this.vertexSet());
        this.removeAllVertices(rejectedSet);
        return rejectedSet.size();
    }

    public int filterGenes(Predicate<Node> predicate) {
        Predicate<Node> genePredicate = Predicates.or(predicate, isNotGene);
        Predicate<Node> finalPredicate = Predicates.or(genePredicate, inQuery);
        return this.filterNodes(finalPredicate);
    }

    public int filterGenesRange(final String key, final float min, final float max) {
        Predicate<Node> pred = new Predicate<Node>(){

            @Override
            public boolean apply(Node object) {
                String sval = GeneNetwork.getNodeKeyData(object, key);
                if (sval != null) {
                    float fval = Float.parseFloat(sval);
                    return fval >= min && fval <= max;
                }
                return false;
            }
        };
        return this.filterGenes(pred);
    }

    public int filterEdges(Predicate<Node> predicate) {
        Set<Node> rejectedSet = this.filter(predicate, this.edgeSet());
        this.removeAllEdges(rejectedSet);
        return rejectedSet.size();
    }

    public Collection<Node> geneVertexes() {
        return Collections2.filter(this.vertexSet(), isGene);
    }

    public void reset() {
        if (this.origGraph == null) {
            throw new IllegalStateException("Have no original graph to which to reset");
        }
        this.removeAllVertices(new HashSet(this.vertexSet()));
        this.removeAllEdges(new HashSet(this.edgeSet()));
        this.copyGraph(this.origGraph);
    }

    public boolean pruneGraph() {
        Predicate<Node> min_connections = new Predicate<Node>(){

            @Override
            public boolean apply(Node object) {
                return GeneNetwork.this.edgesOf(object).size() >= 1;
            }
        };
        return this.filterGenes(min_connections) > 0;
    }

    static File getCachedFile(String url) {
        String cachedFileName = Math.abs(url.hashCode()) + "_tmp.xml";
        File cachedFile = new File(DirectoryManager.getCacheDirectory(), cachedFileName);
        return cachedFile;
    }

    static String getURLForGeneList(List<String> geneList) {
        String query = StringUtils.join(geneList, ",");
        String url = BASE_URL + "?" + GENE_LIST + "=" + query + "&" + common_parms;
        return url;
    }

    public static GeneNetwork getFromCBIO(List<String> geneList) throws IOException {
        String url = GeneNetwork.getURLForGeneList(geneList);
        File cachedFile = GeneNetwork.getCachedFile(url);
        if (cachedFile.exists()) {
            url = cachedFile.getAbsolutePath();
        }
        GeneNetwork network = new GeneNetwork();
        network.loadNetwork(url);
        return network;
    }

    public int loadNetwork(String path) throws IOException {
        this.origGraph = new DirectedMultigraph(Node.class);
        Object error = null;
        int numNodes = -1;
        try {
            InputStream cbioStream = ParsingUtils.openInputStreamGZ(new ResourceLocator(path));
            this.sourcePath = path;
            Document document = Utilities.createDOMDocumentFromXmlStream(cbioStream);
            if (HttpUtils.isRemoteURL(path)) {
                File cacheFile = GeneNetwork.getCachedFile(path);
                try {
                    this.exportDocument(document, cacheFile.getAbsolutePath());
                }
                catch (IOException e2) {
                    this.log.error("Error caching file: " + e2);
                    cacheFile.delete();
                }
                cacheFile.deleteOnExit();
            }
            this.origDocument = document;
            this.addToSchema(document.getElementsByTagName(KEY));
            this.graphAttr = document.getElementsByTagName("graph").item(0).getAttributes();
            NodeList nodes = document.getElementsByTagName(NODE_TAG);
            int docNodes = nodes.getLength();
            HashMap<String, Node> nodeTable = new HashMap<String, Node>(docNodes);
            for (int nn = 0; nn < docNodes; ++nn) {
                Node node = nodes.item(nn);
                String label = node.getAttributes().getNamedItem("id").getTextContent();
                nodeTable.put(label, node);
                this.origGraph.addVertex(node);
            }
            NodeList edges = document.getElementsByTagName(EDGE_TAG);
            int docEdges = edges.getLength();
            for (int ee = 0; ee < docEdges; ++ee) {
                Node edge = edges.item(ee);
                NamedNodeMap attrs = edge.getAttributes();
                String source = attrs.getNamedItem("source").getTextContent();
                String target = attrs.getNamedItem("target").getTextContent();
                this.origGraph.addEdge((Node)nodeTable.get(source), (Node)nodeTable.get(target), edge);
            }
            this.reset();
            numNodes = this.vertexSet().size();
        }
        catch (ParserConfigurationException e3) {
            throw new IOException(e3);
        }
        catch (SAXException e4) {
            throw new IOException(e4);
        }
        return numNodes;
    }

    private void copyGraph(DirectedMultigraph<Node, Node> origGraph) {
        for (Node sourceV : origGraph.vertexSet()) {
            this.addVertex(sourceV);
            for (Node edge : origGraph.outgoingEdgesOf(sourceV)) {
                Node targetV = (Node)origGraph.getEdgeTarget(edge);
                if (!this.containsVertex(targetV)) {
                    this.addVertex(targetV);
                }
                this.addEdge(sourceV, targetV, edge);
            }
        }
    }

    private void addSchema(Collection<String> dataKeys, String dataType, String typeFor) {
        for (String dataKey : dataKeys) {
            Element key = this.origDocument.createElement(KEY);
            key.setAttribute("id", dataKey);
            key.setAttribute("attr.name", dataKey);
            key.setAttribute("attr.type", dataType.toLowerCase());
            if (typeFor != null) {
                key.setAttribute("for", typeFor);
            }
            this.schema.add(key);
        }
    }

    private void addToSchema(NodeList keys) {
        for (int kk = 0; kk < keys.getLength(); ++kk) {
            this.schema.add(keys.item(kk));
        }
    }

    public static String getNodeAttrValue(Node node, String attrName, String attrValue) {
        NodeList elements = node.getChildNodes();
        for (int ee = 0; ee < elements.getLength(); ++ee) {
            Node el = elements.item(ee);
            try {
                NamedNodeMap map = el.getAttributes();
                Node label = map.getNamedItem(attrName);
                String nodeValue = label.getNodeValue();
                if (nodeValue.compareToIgnoreCase(attrValue) != 0) continue;
                return el.getTextContent();
            }
            catch (NullPointerException e2) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getNodeKeyData(Node node, String key) {
        return GeneNetwork.getNodeAttrValue(node, KEY, key);
    }

    public Document createDocument() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setStrictErrorChecking(false);
            Element globalElement = document.createElement("graphml");
            for (Node node : this.schema) {
                globalElement.appendChild(node);
            }
            Element graphEl = document.createElement("graph");
            for (int aa = 0; aa < this.graphAttr.getLength(); ++aa) {
                Node attr = this.graphAttr.item(aa);
                graphEl.setAttribute(attr.getNodeName(), attr.getTextContent());
            }
            for (Node v2 : this.vertexSet()) {
                graphEl.appendChild(v2);
            }
            for (Node e2 : this.edgeSet()) {
                graphEl.appendChild(e2);
            }
            globalElement.appendChild(graphEl);
            document.appendChild(globalElement);
            return document;
        }
        catch (Exception e3) {
            throw new RuntimeException("Error outputting graph", e3);
        }
    }

    public static int writeEncodedString(String string, OutputStream outputStream, boolean gzip, boolean base64encode) throws IOException {
        byte[] byteData;
        if (gzip) {
            ByteArrayOutputStream gmlByteStream = new ByteArrayOutputStream(string.length() / 20);
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(gmlByteStream);
            gzipOutputStream.write(string.getBytes());
            gzipOutputStream.finish();
            byteData = gmlByteStream.toByteArray();
            gmlByteStream.close();
        } else {
            byteData = string.getBytes();
        }
        int count = 0;
        if (base64encode) {
            char[] gmlData;
            for (char c2 : gmlData = Base64Coder.encode(byteData)) {
                outputStream.write(c2);
                ++count;
            }
        } else {
            outputStream.write(byteData);
            outputStream.flush();
            count += byteData.length;
        }
        outputStream.flush();
        return count;
    }

    private int exportDocument(Document document, String outputPath) throws IOException {
        boolean gzip = outputPath.endsWith(".gz");
        String xmlString = Utilities.getString(document);
        FileOutputStream stream = new FileOutputStream(outputPath);
        int count = GeneNetwork.writeEncodedString(xmlString, stream, gzip, false);
        stream.flush();
        ((OutputStream)stream).close();
        return count;
    }

    int exportGraph(String outputFile) throws IOException {
        return this.exportDocument(this.createDocument(), outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String outputForcBioView() throws IOException {
        String outPath = null;
        BufferedReader reader = null;
        OutputStream outputStream = null;
        try {
            String line;
            File temp = File.createTempFile("cbio", ".html");
            temp.deleteOnExit();
            outPath = temp.getAbsolutePath();
            InputStreamReader fReader = new InputStreamReader(GeneNetwork.class.getResourceAsStream("resources/post_stub.html"));
            reader = new BufferedReader(fReader);
            outputStream = new FileOutputStream(outPath);
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("allthegraphmldatagoeshere")) {
                    GeneNetwork.writeEncodedString(Utilities.getString(this.createDocument()), outputStream, true, true);
                    continue;
                }
                outputStream.write((line + FileUtils.LINE_SEPARATOR).getBytes());
                outputStream.flush();
            }
            outputStream.flush();
        }
        catch (IOException e2) {
            this.log.error("Error writing cBio stub form to " + outPath);
            this.log.error(e2.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return outPath;
    }

    public void annotateAll(List<Track> tracks) {
        this.annotate(tracks, attributeMap.keySet());
    }

    public void annotate(List<Track> tracks, Collection<String> nodeAttributes) {
        Set nodes = this.vertexSet();
        for (Node node : nodes) {
            String name = GeneNetwork.getNodeKeyData(node, LABEL);
            ScoreData data = this.collectScoreData(name, tracks, nodeAttributes);
            float relData = data.getPercentAltered();
            if (relData == 0.0f && !Globals.isTesting()) continue;
            for (String attr : nodeAttributes) {
                Element newData = node.getOwnerDocument().createElement("data");
                newData.setAttribute(KEY, attr);
                newData.setTextContent("" + data.get(attr));
                node.appendChild(newData);
            }
            Element newData = node.getOwnerDocument().createElement("data");
            newData.setAttribute(KEY, PERCENT_ALTERED);
            newData.setTextContent("" + data.getPercentAltered());
            node.appendChild(newData);
        }
        this.addSchema(Arrays.asList(PERCENT_ALTERED), "float", NODE_TAG);
        this.addSchema(nodeAttributes, "float", NODE_TAG);
    }

    public ScoreData collectScoreData(String name, List<Track> tracks, Iterable<String> attributes) {
        ReferenceFrame frame;
        int zoom = 0;
        List<NamedFeature> features = FeatureDB.getFeaturesList(name, Integer.MAX_VALUE);
        List<ReferenceFrame> frames = Globals.isHeadless() ? null : FrameManager.getFrames();
        ReferenceFrame referenceFrame = frame = Globals.isHeadless() ? null : FrameManager.getDefaultFrame();
        if (frames != null) {
            for (ReferenceFrame frm : frames) {
                if (!frm.getName().equalsIgnoreCase(name)) continue;
                frame = frm;
            }
        }
        String frameName = frame != null ? frame.getName() : null;
        ScoreData<String, Float> results = new ScoreData<String, Float>(RegionScoreType.values().length);
        int initCapacity = tracks.size() / 10;
        HashSet allSamples = new HashSet(initCapacity);
        HashSet anyAlteration = new HashSet(initCapacity);
        HashSet<String> samplesForType = new HashSet<String>(initCapacity);
        HashSet<String> alteredSamplesForType = new HashSet<String>(initCapacity);
        for (String attr : attributes) {
            if (!bounds.containsKey(attr)) {
                throw new IllegalArgumentException("Have no bounds for " + attr);
            }
            RegionScoreType type = attributeMap.get(attr);
            float[] curBounds = bounds.get(attr);
            samplesForType.clear();
            alteredSamplesForType.clear();
            for (NamedFeature feat : features) {
                if (!name.equalsIgnoreCase(feat.getName())) continue;
                int featStart = feat.getStart();
                int featEnd = feat.getEnd();
                for (Track track : tracks) {
                    if (!track.isVisible()) continue;
                    String sample = track.getSample();
                    if (!track.isRegionScoreType(type) || alteredSamplesForType.contains(sample)) continue;
                    samplesForType.add(sample);
                    float score = track.getRegionScore(feat.getChr(), featStart, featEnd, zoom, type, frameName, tracks);
                    if (!(score >= curBounds[0]) || !(score <= curBounds[1]) || Float.isNaN(score)) continue;
                    alteredSamplesForType.add(sample);
                }
            }
            allSamples.addAll(samplesForType);
            anyAlteration.addAll(alteredSamplesForType);
            float fractionAltered = (float)alteredSamplesForType.size() / (float)samplesForType.size();
            results.put(attr, Float.valueOf(fractionAltered));
        }
        results.setPercentAltered((float)anyAlteration.size() / (float)allSamples.size());
        return results;
    }

    static {
        attributeMap.put(PERCENT_MUTATED, RegionScoreType.MUTATION_COUNT);
        attributeMap.put(PERCENT_CNA_AMPLIFIED, RegionScoreType.AMPLIFICATION);
        attributeMap.put(PERCENT_CNA_HOMOZYGOUSLY_DELETED, RegionScoreType.DELETION);
        attributeMap.put(PERCENT_MRNA_WAY_UP, RegionScoreType.EXPRESSION);
        attributeMap.put(PERCENT_MRNA_WAY_DOWN, RegionScoreType.EXPRESSION);
        geneTypes.add("Protein");
        isGene = new Predicate<Node>(){

            @Override
            public boolean apply(Node object) {
                String type = GeneNetwork.getNodeKeyData(object, "TYPE");
                return geneTypes.contains(type);
            }
        };
        isNotGene = Predicates.not(isGene);
        inQuery = new Predicate<Node>(){

            @Override
            public boolean apply(Node object) {
                String in_query = GeneNetwork.getNodeAttrValue(object, GeneNetwork.KEY, "IN_QUERY");
                return Boolean.parseBoolean(in_query);
            }
        };
        float max_val = 2048.0f;
        float mut = Float.parseFloat(PreferenceManager.getInstance().get("CBIO_MUTATION_THRESHOLD"));
        bounds.put(PERCENT_MUTATED, new float[]{mut, max_val});
        float amp = Float.parseFloat(PreferenceManager.getInstance().get("CBIO_AMPLIFICATION_THRESHOLD"));
        bounds.put(PERCENT_CNA_AMPLIFIED, new float[]{amp, max_val});
        float del = Float.parseFloat(PreferenceManager.getInstance().get("CBIO_DELETION_THRESHOLD"));
        bounds.put(PERCENT_CNA_HOMOZYGOUSLY_DELETED, new float[]{del, max_val});
        float expUp = Float.parseFloat(PreferenceManager.getInstance().get("CBIO_EXPRESSION_UP_THRESHOLD"));
        bounds.put(PERCENT_MRNA_WAY_UP, new float[]{expUp, max_val});
        float expDown = Float.parseFloat(PreferenceManager.getInstance().get("CBIO_EXPRESSION_DOWN_THRESHOLD"));
        bounds.put(PERCENT_MRNA_WAY_DOWN, new float[]{-max_val, -expDown});
    }

    public static class ScoreData<K, V>
    extends HashMap<K, V> {
        private float percentAltered;

        public ScoreData(int size) {
            super(size);
        }

        public void setPercentAltered(float percentAltered) {
            this.percentAltered = percentAltered;
        }

        public float getPercentAltered() {
            return this.percentAltered;
        }
    }
}

