/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.nonstiff;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math.ode.AbstractIntegrator;
import org.apache.commons.math.ode.sampling.AbstractStepInterpolator;

abstract class RungeKuttaStepInterpolator
extends AbstractStepInterpolator {
    protected double[][] yDotK;
    protected AbstractIntegrator integrator;

    protected RungeKuttaStepInterpolator() {
        this.yDotK = null;
        this.integrator = null;
    }

    public RungeKuttaStepInterpolator(RungeKuttaStepInterpolator interpolator) {
        super(interpolator);
        if (interpolator.currentState != null) {
            int dimension = this.currentState.length;
            this.yDotK = new double[interpolator.yDotK.length][];
            for (int k2 = 0; k2 < interpolator.yDotK.length; ++k2) {
                this.yDotK[k2] = new double[dimension];
                System.arraycopy(interpolator.yDotK[k2], 0, this.yDotK[k2], 0, dimension);
            }
        } else {
            this.yDotK = null;
        }
        this.integrator = null;
    }

    public void reinitialize(AbstractIntegrator rkIntegrator, double[] y, double[][] yDotArray, boolean forward) {
        this.reinitialize(y, forward);
        this.yDotK = yDotArray;
        this.integrator = rkIntegrator;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeBaseExternal(out);
        int n2 = this.currentState == null ? -1 : this.currentState.length;
        int kMax = this.yDotK == null ? -1 : this.yDotK.length;
        out.writeInt(kMax);
        for (int k2 = 0; k2 < kMax; ++k2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                out.writeDouble(this.yDotK[k2][i2]);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        double t2 = this.readBaseExternal(in);
        int n2 = this.currentState == null ? -1 : this.currentState.length;
        int kMax = in.readInt();
        this.yDotK = kMax < 0 ? (double[][])null : (double[][])new double[kMax][];
        for (int k2 = 0; k2 < kMax; ++k2) {
            this.yDotK[k2] = n2 < 0 ? null : new double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.yDotK[k2][i2] = in.readDouble();
            }
        }
        this.integrator = null;
        if (this.currentState != null) {
            this.setInterpolatedTime(t2);
        } else {
            this.interpolatedTime = t2;
        }
    }
}

