/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.polynomials;

import org.apache.commons.math.DuplicateSampleAbscissaException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class PolynomialFunctionLagrangeForm
implements UnivariateRealFunction {
    private double[] coefficients;
    private final double[] x;
    private final double[] y;
    private boolean coefficientsComputed;

    public PolynomialFunctionLagrangeForm(double[] x2, double[] y) throws IllegalArgumentException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x2, y);
        this.x = new double[x2.length];
        this.y = new double[y.length];
        System.arraycopy(x2, 0, this.x, 0, x2.length);
        System.arraycopy(y, 0, this.y, 0, y.length);
        this.coefficientsComputed = false;
    }

    public double value(double z) throws FunctionEvaluationException {
        try {
            return PolynomialFunctionLagrangeForm.evaluate(this.x, this.y, z);
        }
        catch (DuplicateSampleAbscissaException e2) {
            throw new FunctionEvaluationException(z, e2.getSpecificPattern(), e2.getGeneralPattern(), e2.getArguments());
        }
    }

    public int degree() {
        return this.x.length - 1;
    }

    public double[] getInterpolatingPoints() {
        double[] out = new double[this.x.length];
        System.arraycopy(this.x, 0, out, 0, this.x.length);
        return out;
    }

    public double[] getInterpolatingValues() {
        double[] out = new double[this.y.length];
        System.arraycopy(this.y, 0, out, 0, this.y.length);
        return out;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] out = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, out, 0, this.coefficients.length);
        return out;
    }

    public static double evaluate(double[] x2, double[] y, double z) throws DuplicateSampleAbscissaException, IllegalArgumentException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x2, y);
        int nearest = 0;
        int n2 = x2.length;
        double[] c2 = new double[n2];
        double[] d2 = new double[n2];
        double min_dist = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < n2; ++i2) {
            c2[i2] = y[i2];
            d2[i2] = y[i2];
            double dist = FastMath.abs(z - x2[i2]);
            if (!(dist < min_dist)) continue;
            nearest = i2;
            min_dist = dist;
        }
        double value = y[nearest];
        for (int i3 = 1; i3 < n2; ++i3) {
            for (int j2 = 0; j2 < n2 - i3; ++j2) {
                double tc = x2[j2] - z;
                double td = x2[i3 + j2] - z;
                double divider = x2[j2] - x2[i3 + j2];
                if (divider == 0.0) {
                    throw new DuplicateSampleAbscissaException(x2[i3], i3, i3 + j2);
                }
                double w2 = (c2[j2 + 1] - d2[j2]) / divider;
                c2[j2] = tc * w2;
                d2[j2] = td * w2;
            }
            if ((double)nearest < 0.5 * (double)(n2 - i3 + 1)) {
                value += c2[nearest];
                continue;
            }
            value += d2[--nearest];
        }
        return value;
    }

    protected void computeCoefficients() throws ArithmeticException {
        int n2 = this.degree() + 1;
        this.coefficients = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.coefficients[i2] = 0.0;
        }
        double[] c2 = new double[n2 + 1];
        c2[0] = 1.0;
        for (int i3 = 0; i3 < n2; ++i3) {
            for (int j2 = i3; j2 > 0; --j2) {
                c2[j2] = c2[j2 - 1] - c2[j2] * this.x[i3];
            }
            c2[0] = c2[0] * -this.x[i3];
            c2[i3 + 1] = 1.0;
        }
        double[] tc = new double[n2];
        for (int i4 = 0; i4 < n2; ++i4) {
            double d2 = 1.0;
            for (int j3 = 0; j3 < n2; ++j3) {
                if (i4 == j3) continue;
                d2 *= this.x[i4] - this.x[j3];
            }
            if (d2 == 0.0) {
                for (int k2 = 0; k2 < n2; ++k2) {
                    if (i4 == k2 || this.x[i4] != this.x[k2]) continue;
                    throw MathRuntimeException.createArithmeticException(LocalizedFormats.IDENTICAL_ABSCISSAS_DIVISION_BY_ZERO, i4, k2, this.x[i4]);
                }
            }
            double t2 = this.y[i4] / d2;
            tc[n2 - 1] = c2[n2];
            int n3 = n2 - 1;
            this.coefficients[n3] = this.coefficients[n3] + t2 * tc[n2 - 1];
            for (int j4 = n2 - 2; j4 >= 0; --j4) {
                tc[j4] = c2[j4 + 1] + tc[j4 + 1] * this.x[i4];
                int n4 = j4;
                this.coefficients[n4] = this.coefficients[n4] + t2 * tc[j4];
            }
        }
        this.coefficientsComputed = true;
    }

    public static void verifyInterpolationArray(double[] x2, double[] y) throws IllegalArgumentException {
        if (x2.length != y.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, x2.length, y.length);
        }
        if (x2.length < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.WRONG_NUMBER_OF_POINTS, 2, x2.length);
        }
    }
}

