/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.jexl2.internal.introspection.ClassMap;
import org.apache.commons.jexl2.internal.introspection.MethodKey;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectorBase {
    protected final Log rlog;
    private final Map<Class<?>, ClassMap> classMethodMaps = new HashMap();
    private ClassLoader loader;
    private final Map<MethodKey, Constructor<?>> constructorsMap = new HashMap();
    private final Map<String, Class<?>> constructibleClasses = new HashMap();
    private static final Constructor<?> CTOR_MISS = CacheMiss.class.getConstructors()[0];

    public IntrospectorBase(Log log) {
        this.rlog = log;
        this.loader = this.getClass().getClassLoader();
    }

    public Class<?> getClassByName(String className) {
        try {
            return Class.forName(className, false, this.loader);
        }
        catch (ClassNotFoundException xignore) {
            return null;
        }
    }

    public Method getMethod(Class<?> c2, MethodKey key) {
        try {
            ClassMap classMap = this.getMap(c2);
            return classMap.findMethod(key);
        }
        catch (MethodKey.AmbiguousException xambiguous) {
            if (this.rlog != null && this.rlog.isInfoEnabled()) {
                this.rlog.info("ambiguous method invocation: " + c2.getName() + "." + key.debugString(), xambiguous);
            }
            return null;
        }
    }

    public Field getField(Class<?> c2, String key) {
        ClassMap classMap = this.getMap(c2);
        return classMap.findField(c2, key);
    }

    public String[] getFieldNames(Class<?> c2) {
        if (c2 == null) {
            return new String[0];
        }
        ClassMap classMap = this.getMap(c2);
        return classMap.getFieldNames();
    }

    public String[] getMethodNames(Class<?> c2) {
        if (c2 == null) {
            return new String[0];
        }
        ClassMap classMap = this.getMap(c2);
        return classMap.getMethodNames();
    }

    public Method[] getMethods(Class<?> c2, String methodName) {
        if (c2 == null) {
            return null;
        }
        ClassMap classMap = this.getMap(c2);
        return classMap.get(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoader(ClassLoader cloader) {
        ClassLoader previous = this.loader;
        if (cloader == null) {
            cloader = this.getClass().getClassLoader();
        }
        if (!cloader.equals(this.loader)) {
            Class clazz;
            Map.Entry<Object, Object> entry;
            Iterator<Map.Entry<Object, Object>> entries;
            Map<Object, Object> map = this.constructorsMap;
            synchronized (map) {
                entries = this.constructorsMap.entrySet().iterator();
                while (entries.hasNext()) {
                    entry = entries.next();
                    clazz = entry.getValue().getDeclaringClass();
                    if (!IntrospectorBase.isLoadedBy(previous, clazz)) continue;
                    entries.remove();
                    this.constructibleClasses.remove(entry.getKey().getMethod());
                }
            }
            map = this.classMethodMaps;
            synchronized (map) {
                entries = this.classMethodMaps.entrySet().iterator();
                while (entries.hasNext()) {
                    entry = entries.next();
                    clazz = (Class)entry.getKey();
                    if (!IntrospectorBase.isLoadedBy(previous, clazz)) continue;
                    entries.remove();
                }
            }
            this.loader = cloader;
        }
    }

    private static boolean isLoadedBy(ClassLoader loader, Class<?> clazz) {
        if (loader != null) {
            for (ClassLoader cloader = clazz.getClassLoader(); cloader != null; cloader = cloader.getParent()) {
                if (!cloader.equals(loader)) continue;
                return true;
            }
        }
        return false;
    }

    public Constructor<?> getConstructor(MethodKey key) {
        return this.getConstructor(null, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constructor<?> getConstructor(Class<?> c2, MethodKey key) {
        Constructor<?> ctor = null;
        Map<MethodKey, Constructor<?>> map = this.constructorsMap;
        synchronized (map) {
            ctor = this.constructorsMap.get(key);
            if (CTOR_MISS.equals(ctor)) {
                return null;
            }
            if (ctor == null) {
                String cname = key.getMethod();
                Class<?> clazz = this.constructibleClasses.get(cname);
                try {
                    if (clazz == null) {
                        clazz = c2 != null && c2.getName().equals(key.getMethod()) ? c2 : this.loader.loadClass(cname);
                        this.constructibleClasses.put(cname, clazz);
                    }
                    LinkedList l2 = new LinkedList();
                    for (Constructor<?> ictor : clazz.getConstructors()) {
                        l2.add(ictor);
                    }
                    ctor = key.getMostSpecificConstructor(l2);
                    if (ctor != null) {
                        this.constructorsMap.put(key, ctor);
                    } else {
                        this.constructorsMap.put(key, CTOR_MISS);
                    }
                }
                catch (ClassNotFoundException xnotfound) {
                    if (this.rlog != null && this.rlog.isInfoEnabled()) {
                        this.rlog.info("unable to find class: " + cname + "." + key.debugString(), xnotfound);
                    }
                    ctor = null;
                }
                catch (MethodKey.AmbiguousException xambiguous) {
                    if (this.rlog != null && this.rlog.isInfoEnabled()) {
                        this.rlog.info("ambiguous constructor invocation: " + cname + "." + key.debugString(), xambiguous);
                    }
                    ctor = null;
                }
            }
            return ctor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassMap getMap(Class<?> c2) {
        Map<Class<?>, ClassMap> map = this.classMethodMaps;
        synchronized (map) {
            ClassMap classMap = this.classMethodMaps.get(c2);
            if (classMap == null) {
                classMap = new ClassMap(c2, this.rlog);
                this.classMethodMaps.put(c2, classMap);
            }
            return classMap;
        }
    }

    private static class CacheMiss {
    }
}

