/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListWrapper
extends AbstractList<Object> {
    private final Object array;

    public ArrayListWrapper(Object anArray) {
        if (!anArray.getClass().isArray()) {
            throw new IllegalArgumentException(anArray.getClass() + " is not an array");
        }
        this.array = anArray;
    }

    @Override
    public Object get(int index) {
        return Array.get(this.array, index);
    }

    @Override
    public Object set(int index, Object element) {
        Object old = this.get(index);
        Array.set(this.array, index, element);
        return old;
    }

    @Override
    public int size() {
        return Array.getLength(this.array);
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] a2 = new Object[size];
        for (int i2 = 0; i2 < size; ++i2) {
            a2[i2] = this.get(i2);
        }
        return a2;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        int size = this.size();
        if (a2.length < size) {
            Object[] x2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), size);
            System.arraycopy(a2, a2.length, x2, 0, a2.length);
        }
        for (int i2 = 0; i2 < size; ++i2) {
            a2[i2] = this.get(i2);
        }
        if (a2.length > size) {
            a2[size] = null;
        }
        return a2;
    }

    @Override
    public int indexOf(Object o2) {
        int size = this.size();
        if (o2 == null) {
            for (int i2 = 0; i2 < size; ++i2) {
                if (this.get(i2) != null) continue;
                return i2;
            }
        } else {
            for (int i3 = 0; i3 < size; ++i3) {
                if (!o2.equals(this.get(i3))) continue;
                return i3;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o2) {
        return this.indexOf(o2) != -1;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        return super.iterator();
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        return super.containsAll(c2);
    }

    @Override
    public int lastIndexOf(Object o2) {
        return super.lastIndexOf(o2);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return super.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return super.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public boolean add(Object o2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean remove(Object o2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(Collection<? extends Object> c2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

