/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.awt.geom.AffineTransform;
import java.io.Reader;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.TransformListHandler;
import org.apache.batik.parser.TransformListParser;

public class AWTTransformProducer
implements TransformListHandler {
    protected AffineTransform affineTransform;

    public static AffineTransform createAffineTransform(Reader r2) throws ParseException {
        TransformListParser p2 = new TransformListParser();
        AWTTransformProducer th = new AWTTransformProducer();
        p2.setTransformListHandler(th);
        p2.parse(r2);
        return th.getAffineTransform();
    }

    public static AffineTransform createAffineTransform(String s2) throws ParseException {
        TransformListParser p2 = new TransformListParser();
        AWTTransformProducer th = new AWTTransformProducer();
        p2.setTransformListHandler(th);
        p2.parse(s2);
        return th.getAffineTransform();
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public void startTransformList() throws ParseException {
        this.affineTransform = new AffineTransform();
    }

    public void matrix(float a2, float b2, float c2, float d2, float e2, float f2) throws ParseException {
        this.affineTransform.concatenate(new AffineTransform(a2, b2, c2, d2, e2, f2));
    }

    public void rotate(float theta) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getRotateInstance(Math.toRadians(theta)));
    }

    public void rotate(float theta, float cx, float cy) throws ParseException {
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(theta), cx, cy);
        this.affineTransform.concatenate(at);
    }

    public void translate(float tx) throws ParseException {
        AffineTransform at = AffineTransform.getTranslateInstance(tx, 0.0);
        this.affineTransform.concatenate(at);
    }

    public void translate(float tx, float ty) throws ParseException {
        AffineTransform at = AffineTransform.getTranslateInstance(tx, ty);
        this.affineTransform.concatenate(at);
    }

    public void scale(float sx) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getScaleInstance(sx, sx));
    }

    public void scale(float sx, float sy) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getScaleInstance(sx, sy));
    }

    public void skewX(float skx) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getShearInstance(Math.tan(Math.toRadians(skx)), 0.0));
    }

    public void skewY(float sky) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getShearInstance(0.0, Math.tan(Math.toRadians(sky))));
    }

    public void endTransformList() throws ParseException {
    }
}

