/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.AnimatableGenericSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ClipBridge;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.dom.svg.SVGOMUseElement;
import org.apache.batik.ext.awt.image.renderable.ClipRable;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGClipPathElementBridge
extends AnimatableGenericSVGBridge
implements ClipBridge {
    public String getLocalName() {
        return "clipPath";
    }

    public ClipRable createClip(BridgeContext ctx, Element clipElement, Element clipedElement, GraphicsNode clipedNode) {
        Filter filter;
        String s2 = clipElement.getAttributeNS(null, "transform");
        AffineTransform Tx = s2.length() != 0 ? SVGUtilities.convertTransform(clipElement, "transform", s2, ctx) : new AffineTransform();
        s2 = clipElement.getAttributeNS(null, "clipPathUnits");
        int coordSystemType = s2.length() == 0 ? 1 : (int)SVGUtilities.parseCoordinateSystem(clipElement, "clipPathUnits", s2, ctx);
        if (coordSystemType == 2) {
            Tx = SVGUtilities.toObjectBBox(Tx, clipedNode);
        }
        Area clipPath = new Area();
        GVTBuilder builder = ctx.getGVTBuilder();
        boolean hasChildren = false;
        Node node = clipElement.getFirstChild();
        while (node != null) {
            Element child;
            GraphicsNode clipNode;
            if (node.getNodeType() == 1 && (clipNode = builder.build(ctx, child = (Element)node)) != null) {
                Node shadowChild;
                hasChildren = true;
                if (child instanceof SVGOMUseElement && (shadowChild = ((SVGOMUseElement)child).getCSSFirstChild()) != null && shadowChild.getNodeType() == 1) {
                    child = (Element)shadowChild;
                }
                int wr = CSSUtilities.convertClipRule(child);
                GeneralPath path = new GeneralPath(clipNode.getOutline());
                path.setWindingRule(wr);
                AffineTransform at = clipNode.getTransform();
                if (at == null) {
                    at = Tx;
                } else {
                    at.preConcatenate(Tx);
                }
                Shape outline = at.createTransformedShape(path);
                ShapeNode outlineNode = new ShapeNode();
                outlineNode.setShape(outline);
                ClipRable clip = CSSUtilities.convertClipPath(child, outlineNode, ctx);
                if (clip != null) {
                    Area area = new Area(outline);
                    area.subtract(new Area(clip.getClipPath()));
                    outline = area;
                }
                clipPath.add(new Area(outline));
            }
            node = node.getNextSibling();
        }
        if (!hasChildren) {
            return null;
        }
        ShapeNode clipPathNode = new ShapeNode();
        clipPathNode.setShape(clipPath);
        ClipRable clipElementClipPath = CSSUtilities.convertClipPath(clipElement, clipPathNode, ctx);
        if (clipElementClipPath != null) {
            clipPath.subtract(new Area(clipElementClipPath.getClipPath()));
        }
        if ((filter = clipedNode.getFilter()) == null) {
            filter = clipedNode.getGraphicsNodeRable(true);
        }
        boolean useAA = false;
        RenderingHints hints = CSSUtilities.convertShapeRendering(clipElement, null);
        if (hints != null) {
            Object o2 = hints.get(RenderingHints.KEY_ANTIALIASING);
            useAA = o2 == RenderingHints.VALUE_ANTIALIAS_ON;
        }
        return new ClipRable8Bit(filter, clipPath, useAA);
    }
}

