/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.batik.anim.AnimationEngine;
import org.apache.batik.anim.AnimationException;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.anim.values.AnimatableAngleOrIdentValue;
import org.apache.batik.anim.values.AnimatableAngleValue;
import org.apache.batik.anim.values.AnimatableBooleanValue;
import org.apache.batik.anim.values.AnimatableColorValue;
import org.apache.batik.anim.values.AnimatableIntegerValue;
import org.apache.batik.anim.values.AnimatableLengthListValue;
import org.apache.batik.anim.values.AnimatableLengthOrIdentValue;
import org.apache.batik.anim.values.AnimatableLengthValue;
import org.apache.batik.anim.values.AnimatableNumberListValue;
import org.apache.batik.anim.values.AnimatableNumberOrIdentValue;
import org.apache.batik.anim.values.AnimatableNumberOrPercentageValue;
import org.apache.batik.anim.values.AnimatableNumberValue;
import org.apache.batik.anim.values.AnimatablePaintValue;
import org.apache.batik.anim.values.AnimatablePathDataValue;
import org.apache.batik.anim.values.AnimatablePointListValue;
import org.apache.batik.anim.values.AnimatablePreserveAspectRatioValue;
import org.apache.batik.anim.values.AnimatableRectValue;
import org.apache.batik.anim.values.AnimatableStringValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.bridge.AnimationSupport;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGAnimationElementBridge;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.parser.DefaultLengthHandler;
import org.apache.batik.parser.DefaultPreserveAspectRatioHandler;
import org.apache.batik.parser.FloatArrayProducer;
import org.apache.batik.parser.LengthArrayProducer;
import org.apache.batik.parser.LengthHandler;
import org.apache.batik.parser.LengthListParser;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.NumberListParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathArrayProducer;
import org.apache.batik.parser.PathParser;
import org.apache.batik.parser.PointsParser;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.apache.batik.util.RunnableQueue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.events.EventTarget;

public class SVGAnimationEngine
extends AnimationEngine {
    protected BridgeContext ctx;
    protected CSSEngine cssEngine;
    protected boolean started;
    protected AnimationTickRunnable animationTickRunnable;
    protected UncomputedAnimatableStringValueFactory uncomputedAnimatableStringValueFactory = new UncomputedAnimatableStringValueFactory();
    protected AnimatableLengthOrIdentFactory animatableLengthOrIdentFactory = new AnimatableLengthOrIdentFactory();
    protected AnimatableNumberOrIdentFactory animatableNumberOrIdentFactory = new AnimatableNumberOrIdentFactory(false);
    protected Factory[] factories = new Factory[]{null, new AnimatableIntegerValueFactory(), new AnimatableNumberValueFactory(), new AnimatableLengthValueFactory(), null, new AnimatableAngleValueFactory(), new AnimatableColorValueFactory(), new AnimatablePaintValueFactory(), null, null, this.uncomputedAnimatableStringValueFactory, null, null, new AnimatableNumberListValueFactory(), new AnimatableLengthListValueFactory(), this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.animatableLengthOrIdentFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, this.uncomputedAnimatableStringValueFactory, new AnimatablePathDataFactory(), this.uncomputedAnimatableStringValueFactory, null, this.animatableNumberOrIdentFactory, this.uncomputedAnimatableStringValueFactory, null, new AnimatableNumberOrIdentFactory(true), new AnimatableAngleOrIdentFactory(), null, new AnimatablePointListValueFactory(), new AnimatablePreserveAspectRatioValueFactory(), null, this.uncomputedAnimatableStringValueFactory, null, null, null, null, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableLengthOrIdentFactory, this.animatableNumberOrIdentFactory, null, null, new AnimatableNumberOrPercentageValueFactory(), null, new AnimatableBooleanValueFactory(), new AnimatableRectValueFactory()};
    protected boolean isSVG12;
    protected LinkedList initialBridges = new LinkedList();
    protected StyleMap dummyStyleMap;
    protected AnimationThread animationThread;
    protected int animationLimitingMode;
    protected float animationLimitingAmount;
    protected static final Set animationEventNames11 = new HashSet();
    protected static final Set animationEventNames12 = new HashSet();

    public SVGAnimationEngine(Document doc, BridgeContext ctx) {
        super(doc);
        this.ctx = ctx;
        SVGOMDocument d2 = (SVGOMDocument)doc;
        this.cssEngine = d2.getCSSEngine();
        this.dummyStyleMap = new StyleMap(this.cssEngine.getNumberOfProperties());
        this.isSVG12 = d2.isSVG12();
    }

    public void dispose() {
        SVGAnimationEngine sVGAnimationEngine = this;
        synchronized (sVGAnimationEngine) {
            this.pause();
            super.dispose();
        }
    }

    public void addInitialBridge(SVGAnimationElementBridge b2) {
        if (this.initialBridges != null) {
            this.initialBridges.add(b2);
        }
    }

    public boolean hasStarted() {
        return this.started;
    }

    public AnimatableValue parseAnimatableValue(Element animElt, AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
        SVGOMElement elt = (SVGOMElement)target.getElement();
        int type = isCSS ? elt.getPropertyType(ln) : elt.getAttributeType(ns, ln);
        Factory factory = this.factories[type];
        if (factory == null) {
            String an = ns == null ? ln : '{' + ns + '}' + ln;
            throw new BridgeException(this.ctx, animElt, "attribute.not.animatable", new Object[]{target.getElement().getNodeName(), an});
        }
        return this.factories[type].createValue(target, ns, ln, isCSS, s2);
    }

    public AnimatableValue getUnderlyingCSSValue(Element animElt, AnimationTarget target, String pn) {
        ValueManager[] vms = this.cssEngine.getValueManagers();
        int idx = this.cssEngine.getPropertyIndex(pn);
        if (idx != -1) {
            int type = vms[idx].getPropertyType();
            Factory factory = this.factories[type];
            if (factory == null) {
                throw new BridgeException(this.ctx, animElt, "attribute.not.animatable", new Object[]{target.getElement().getNodeName(), pn});
            }
            SVGStylableElement e2 = (SVGStylableElement)target.getElement();
            CSSStyleDeclaration over = e2.getOverrideStyle();
            String oldValue = over.getPropertyValue(pn);
            if (oldValue != null) {
                over.removeProperty(pn);
            }
            Value v2 = this.cssEngine.getComputedStyle(e2, null, idx);
            if (oldValue != null && !oldValue.equals("")) {
                over.setProperty(pn, oldValue, null);
            }
            return this.factories[type].createValue(target, pn, v2);
        }
        return null;
    }

    public void pause() {
        super.pause();
        UpdateManager um = this.ctx.getUpdateManager();
        if (um != null) {
            um.getUpdateRunnableQueue().setIdleRunnable(null);
        }
    }

    public void unpause() {
        super.unpause();
        UpdateManager um = this.ctx.getUpdateManager();
        if (um != null) {
            um.getUpdateRunnableQueue().setIdleRunnable(this.animationTickRunnable);
        }
    }

    public float getCurrentTime() {
        boolean p2 = this.pauseTime != 0L;
        this.unpause();
        float t2 = this.timedDocumentRoot.getCurrentTime();
        if (p2) {
            this.pause();
        }
        return t2;
    }

    public float setCurrentTime(float t2) {
        float ret = super.setCurrentTime(t2);
        if (this.animationTickRunnable != null) {
            this.animationTickRunnable.resume();
        }
        return ret;
    }

    protected TimedDocumentRoot createDocumentRoot() {
        return new AnimationRoot();
    }

    public void start(long documentStartTime) {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date(documentStartTime));
                this.timedDocumentRoot.resetDocument(cal);
                Object[] bridges = this.initialBridges.toArray();
                this.initialBridges = null;
                int i2 = 0;
                while (i2 < bridges.length) {
                    SVGAnimationElementBridge bridge = (SVGAnimationElementBridge)bridges[i2];
                    bridge.initializeAnimation();
                    ++i2;
                }
                int i3 = 0;
                while (i3 < bridges.length) {
                    SVGAnimationElementBridge bridge = (SVGAnimationElementBridge)bridges[i3];
                    bridge.initializeTimedElement();
                    ++i3;
                }
                UpdateManager um = this.ctx.getUpdateManager();
                if (um != null) {
                    RunnableQueue q2 = um.getUpdateRunnableQueue();
                    this.animationTickRunnable = new AnimationTickRunnable(q2, this);
                    q2.setIdleRunnable(this.animationTickRunnable);
                }
            }
            catch (AnimationException ex) {
                throw new BridgeException(this.ctx, ex.getElement().getElement(), ex.getMessage());
            }
        }
        catch (Exception ex) {
            if (this.ctx.getUserAgent() == null) {
                ex.printStackTrace();
            }
            this.ctx.getUserAgent().displayError(ex);
        }
    }

    public void setAnimationLimitingNone() {
        this.animationLimitingMode = 0;
    }

    public void setAnimationLimitingCPU(float pc) {
        this.animationLimitingMode = 1;
        this.animationLimitingAmount = pc;
    }

    public void setAnimationLimitingFPS(float fps) {
        this.animationLimitingMode = 2;
        this.animationLimitingAmount = fps;
    }

    static {
        String[] eventNamesCommon = new String[]{"click", "mousedown", "mouseup", "mouseover", "mousemove", "mouseout", "beginEvent", "endEvent"};
        String[] eventNamesSVG11 = new String[]{"DOMSubtreeModified", "DOMNodeInserted", "DOMNodeRemoved", "DOMNodeRemovedFromDocument", "DOMNodeInsertedIntoDocument", "DOMAttrModified", "DOMCharacterDataModified", "SVGLoad", "SVGUnload", "SVGAbort", "SVGError", "SVGResize", "SVGScroll", "repeatEvent"};
        String[] eventNamesSVG12 = new String[]{"load", "resize", "scroll", "zoom"};
        int i2 = 0;
        while (i2 < eventNamesCommon.length) {
            animationEventNames11.add(eventNamesCommon[i2]);
            animationEventNames12.add(eventNamesCommon[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < eventNamesSVG11.length) {
            animationEventNames11.add(eventNamesSVG11[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < eventNamesSVG12.length) {
            animationEventNames12.add(eventNamesSVG12[i4]);
            ++i4;
        }
    }

    protected class AnimatableStringValueFactory
    extends CSSValueFactory {
        protected AnimatableStringValueFactory() {
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget target, String pn, Value v2) {
            return new AnimatableStringValue(target, v2.getCssText());
        }
    }

    protected class AnimatablePaintValueFactory
    extends CSSValueFactory {
        protected AnimatablePaintValueFactory() {
        }

        protected AnimatablePaintValue createColorPaintValue(AnimationTarget t2, Color c2) {
            return AnimatablePaintValue.createColorPaintValue((AnimationTarget)t2, (float)((float)c2.getRed() / 255.0f), (float)((float)c2.getGreen() / 255.0f), (float)((float)c2.getBlue() / 255.0f));
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget target, String pn, Value v2) {
            if (v2.getCssValueType() == 1) {
                switch (v2.getPrimitiveType()) {
                    case 21: {
                        return AnimatablePaintValue.createNonePaintValue((AnimationTarget)target);
                    }
                    case 25: {
                        Paint p2 = PaintServer.convertPaint(target.getElement(), null, v2, 1.0f, SVGAnimationEngine.this.ctx);
                        return this.createColorPaintValue(target, (Color)p2);
                    }
                    case 20: {
                        return AnimatablePaintValue.createURIPaintValue((AnimationTarget)target, (String)v2.getStringValue());
                    }
                }
            } else {
                Value v1 = v2.item(0);
                switch (v1.getPrimitiveType()) {
                    case 25: {
                        Paint p3 = PaintServer.convertPaint(target.getElement(), null, v2, 1.0f, SVGAnimationEngine.this.ctx);
                        return this.createColorPaintValue(target, (Color)p3);
                    }
                    case 20: {
                        Value v22 = v2.item(1);
                        switch (v22.getPrimitiveType()) {
                            case 21: {
                                return AnimatablePaintValue.createURINonePaintValue((AnimationTarget)target, (String)v1.getStringValue());
                            }
                            case 25: {
                                Paint p4 = PaintServer.convertPaint(target.getElement(), null, v2.item(1), 1.0f, SVGAnimationEngine.this.ctx);
                                return this.createColorPaintValue(target, (Color)p4);
                            }
                        }
                    }
                }
            }
            return null;
        }
    }

    protected class AnimatableColorValueFactory
    extends CSSValueFactory {
        protected AnimatableColorValueFactory() {
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget target, String pn, Value v2) {
            Paint p2 = PaintServer.convertPaint(target.getElement(), null, v2, 1.0f, SVGAnimationEngine.this.ctx);
            if (p2 instanceof Color) {
                Color c2 = (Color)p2;
                return new AnimatableColorValue(target, (float)c2.getRed() / 255.0f, (float)c2.getGreen() / 255.0f, (float)c2.getBlue() / 255.0f);
            }
            return null;
        }
    }

    protected class AnimatableAngleOrIdentFactory
    extends CSSValueFactory {
        protected AnimatableAngleOrIdentFactory() {
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget target, String pn, Value v2) {
            short unit;
            if (v2 instanceof StringValue) {
                return new AnimatableAngleOrIdentValue(target, v2.getStringValue());
            }
            FloatValue fv = (FloatValue)v2;
            switch (fv.getPrimitiveType()) {
                case 1: 
                case 11: {
                    unit = 2;
                    break;
                }
                case 12: {
                    unit = 3;
                    break;
                }
                case 13: {
                    unit = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new AnimatableAngleOrIdentValue(target, fv.getFloatValue(), unit);
        }
    }

    protected class AnimatableAngleValueFactory
    extends CSSValueFactory {
        protected AnimatableAngleValueFactory() {
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget target, String pn, Value v2) {
            short unit;
            FloatValue fv = (FloatValue)v2;
            switch (fv.getPrimitiveType()) {
                case 1: 
                case 11: {
                    unit = 2;
                    break;
                }
                case 12: {
                    unit = 3;
                    break;
                }
                case 13: {
                    unit = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new AnimatableAngleValue(target, fv.getFloatValue(), unit);
        }
    }

    protected class AnimatableNumberOrIdentFactory
    extends CSSValueFactory {
        protected boolean numericIdents;

        public AnimatableNumberOrIdentFactory(boolean numericIdents) {
            this.numericIdents = numericIdents;
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget target, String pn, Value v2) {
            if (v2 instanceof StringValue) {
                return new AnimatableNumberOrIdentValue(target, v2.getStringValue());
            }
            FloatValue fv = (FloatValue)v2;
            return new AnimatableNumberOrIdentValue(target, fv.getFloatValue(), this.numericIdents);
        }
    }

    protected class AnimatableLengthOrIdentFactory
    extends CSSValueFactory {
        protected AnimatableLengthOrIdentFactory() {
        }

        protected AnimatableValue createAnimatableValue(AnimationTarget target, String pn, Value v2) {
            if (v2 instanceof StringValue) {
                return new AnimatableLengthOrIdentValue(target, v2.getStringValue());
            }
            short pcInterp = target.getPercentageInterpretation(null, pn, true);
            FloatValue fv = (FloatValue)v2;
            return new AnimatableLengthOrIdentValue(target, fv.getPrimitiveType(), fv.getFloatValue(), pcInterp);
        }
    }

    protected class UncomputedAnimatableStringValueFactory
    implements Factory {
        protected UncomputedAnimatableStringValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            return new AnimatableStringValue(target, s2);
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            return new AnimatableStringValue(target, v2.getCssText());
        }
    }

    protected class AnimatablePathDataFactory
    implements Factory {
        protected PathParser parser = new PathParser();
        protected PathArrayProducer producer = new PathArrayProducer();

        public AnimatablePathDataFactory() {
            this.parser.setPathHandler(this.producer);
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            try {
                this.parser.parse(s2);
                return new AnimatablePathDataValue(target, this.producer.getPathCommands(), this.producer.getPathParameters());
            }
            catch (ParseException e2) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            return null;
        }
    }

    protected class AnimatablePointListValueFactory
    implements Factory {
        protected PointsParser parser = new PointsParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatablePointListValueFactory() {
            this.parser.setPointsHandler(this.producer);
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            try {
                this.parser.parse(s2);
                return new AnimatablePointListValue(target, this.producer.getFloatArray());
            }
            catch (ParseException e2) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            return null;
        }
    }

    protected class AnimatableRectValueFactory
    implements Factory {
        protected NumberListParser parser = new NumberListParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatableRectValueFactory() {
            this.parser.setNumberListHandler(this.producer);
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            try {
                this.parser.parse(s2);
                float[] r2 = this.producer.getFloatArray();
                if (r2.length != 4) {
                    return null;
                }
                return new AnimatableRectValue(target, r2[0], r2[1], r2[2], r2[3]);
            }
            catch (ParseException e2) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            return null;
        }
    }

    protected class AnimatableNumberListValueFactory
    implements Factory {
        protected NumberListParser parser = new NumberListParser();
        protected FloatArrayProducer producer = new FloatArrayProducer();

        public AnimatableNumberListValueFactory() {
            this.parser.setNumberListHandler(this.producer);
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            try {
                this.parser.parse(s2);
                return new AnimatableNumberListValue(target, this.producer.getFloatArray());
            }
            catch (ParseException e2) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            return null;
        }
    }

    protected class AnimatableLengthListValueFactory
    implements Factory {
        protected LengthListParser parser = new LengthListParser();
        protected LengthArrayProducer producer = new LengthArrayProducer();

        public AnimatableLengthListValueFactory() {
            this.parser.setLengthListHandler(this.producer);
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            try {
                short pcInterp = target.getPercentageInterpretation(ns, ln, isCSS);
                this.parser.parse(s2);
                return new AnimatableLengthListValue(target, this.producer.getLengthTypeArray(), this.producer.getLengthValueArray(), pcInterp);
            }
            catch (ParseException e2) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            return null;
        }
    }

    protected class AnimatableLengthValueFactory
    implements Factory {
        protected short type;
        protected float value;
        protected LengthParser parser = new LengthParser();
        protected LengthHandler handler = new DefaultLengthHandler(this){
            private final /* synthetic */ AnimatableLengthValueFactory this$1;
            {
                this.this$1 = this$1;
            }

            public void startLength() throws ParseException {
                this.this$1.type = 1;
            }

            public void lengthValue(float v2) throws ParseException {
                this.this$1.value = v2;
            }

            public void em() throws ParseException {
                this.this$1.type = (short)3;
            }

            public void ex() throws ParseException {
                this.this$1.type = (short)4;
            }

            public void in() throws ParseException {
                this.this$1.type = (short)8;
            }

            public void cm() throws ParseException {
                this.this$1.type = (short)6;
            }

            public void mm() throws ParseException {
                this.this$1.type = (short)7;
            }

            public void pc() throws ParseException {
                this.this$1.type = (short)10;
            }

            public void pt() throws ParseException {
                this.this$1.type = (short)9;
            }

            public void px() throws ParseException {
                this.this$1.type = (short)5;
            }

            public void percentage() throws ParseException {
                this.this$1.type = (short)2;
            }

            public void endLength() throws ParseException {
            }
        };

        public AnimatableLengthValueFactory() {
            this.parser.setLengthHandler(this.handler);
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            short pcInterp = target.getPercentageInterpretation(ns, ln, isCSS);
            try {
                this.parser.parse(s2);
                return new AnimatableLengthValue(target, this.type, this.value, pcInterp);
            }
            catch (ParseException e2) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            return new AnimatableIntegerValue(target, Math.round(v2.getFloatValue()));
        }
    }

    protected class AnimatablePreserveAspectRatioValueFactory
    implements Factory {
        protected short align;
        protected short meetOrSlice;
        protected PreserveAspectRatioParser parser = new PreserveAspectRatioParser();
        protected DefaultPreserveAspectRatioHandler handler = new DefaultPreserveAspectRatioHandler(this){
            private final /* synthetic */ AnimatablePreserveAspectRatioValueFactory this$1;
            {
                this.this$1 = this$1;
            }

            public void startPreserveAspectRatio() throws ParseException {
                this.this$1.align = 0;
                this.this$1.meetOrSlice = 0;
            }

            public void none() throws ParseException {
                this.this$1.align = 1;
            }

            public void xMaxYMax() throws ParseException {
                this.this$1.align = (short)10;
            }

            public void xMaxYMid() throws ParseException {
                this.this$1.align = (short)7;
            }

            public void xMaxYMin() throws ParseException {
                this.this$1.align = (short)4;
            }

            public void xMidYMax() throws ParseException {
                this.this$1.align = (short)9;
            }

            public void xMidYMid() throws ParseException {
                this.this$1.align = (short)6;
            }

            public void xMidYMin() throws ParseException {
                this.this$1.align = (short)3;
            }

            public void xMinYMax() throws ParseException {
                this.this$1.align = (short)8;
            }

            public void xMinYMid() throws ParseException {
                this.this$1.align = (short)5;
            }

            public void xMinYMin() throws ParseException {
                this.this$1.align = (short)2;
            }

            public void meet() throws ParseException {
                this.this$1.meetOrSlice = 1;
            }

            public void slice() throws ParseException {
                this.this$1.meetOrSlice = (short)2;
            }
        };

        public AnimatablePreserveAspectRatioValueFactory() {
            this.parser.setPreserveAspectRatioHandler(this.handler);
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            try {
                this.parser.parse(s2);
                return new AnimatablePreserveAspectRatioValue(target, this.align, this.meetOrSlice);
            }
            catch (ParseException e2) {
                return null;
            }
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            return null;
        }
    }

    protected class AnimatableNumberOrPercentageValueFactory
    implements Factory {
        protected AnimatableNumberOrPercentageValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            boolean pc;
            float v2;
            if (s2.charAt(s2.length() - 1) == '%') {
                v2 = Float.parseFloat(s2.substring(0, s2.length() - 1));
                pc = true;
            } else {
                v2 = Float.parseFloat(s2);
                pc = false;
            }
            return new AnimatableNumberOrPercentageValue(target, v2, pc);
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            switch (v2.getPrimitiveType()) {
                case 2: {
                    return new AnimatableNumberOrPercentageValue(target, v2.getFloatValue(), true);
                }
                case 1: {
                    return new AnimatableNumberOrPercentageValue(target, v2.getFloatValue());
                }
            }
            return null;
        }
    }

    protected class AnimatableNumberValueFactory
    implements Factory {
        protected AnimatableNumberValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            return new AnimatableNumberValue(target, Float.parseFloat(s2));
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            return new AnimatableNumberValue(target, v2.getFloatValue());
        }
    }

    protected class AnimatableIntegerValueFactory
    implements Factory {
        protected AnimatableIntegerValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            return new AnimatableIntegerValue(target, Integer.parseInt(s2));
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            return new AnimatableIntegerValue(target, Math.round(v2.getFloatValue()));
        }
    }

    protected class AnimatableBooleanValueFactory
    implements Factory {
        protected AnimatableBooleanValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            return new AnimatableBooleanValue(target, "true".equals(s2));
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            return new AnimatableBooleanValue(target, "true".equals(v2.getCssText()));
        }
    }

    protected abstract class CSSValueFactory
    implements Factory {
        protected CSSValueFactory() {
        }

        public AnimatableValue createValue(AnimationTarget target, String ns, String ln, boolean isCSS, String s2) {
            return this.createValue(target, ln, this.createCSSValue(target, ln, s2));
        }

        public AnimatableValue createValue(AnimationTarget target, String pn, Value v2) {
            CSSStylableElement elt = (CSSStylableElement)target.getElement();
            v2 = this.computeValue(elt, pn, v2);
            return this.createAnimatableValue(target, pn, v2);
        }

        protected abstract AnimatableValue createAnimatableValue(AnimationTarget var1, String var2, Value var3);

        protected Value createCSSValue(AnimationTarget t2, String pn, String s2) {
            CSSStylableElement elt = (CSSStylableElement)t2.getElement();
            Value v2 = SVGAnimationEngine.this.cssEngine.parsePropertyValue(elt, pn, s2);
            return this.computeValue(elt, pn, v2);
        }

        protected Value computeValue(CSSStylableElement elt, String pn, Value v2) {
            ValueManager[] vms = SVGAnimationEngine.this.cssEngine.getValueManagers();
            int idx = SVGAnimationEngine.this.cssEngine.getPropertyIndex(pn);
            if (idx != -1) {
                if (v2.getCssValueType() == 0) {
                    if ((elt = CSSEngine.getParentCSSStylableElement(elt)) != null) {
                        return SVGAnimationEngine.this.cssEngine.getComputedStyle(elt, null, idx);
                    }
                    return vms[idx].getDefaultValue();
                }
                v2 = vms[idx].computeValue(elt, null, SVGAnimationEngine.this.cssEngine, idx, SVGAnimationEngine.this.dummyStyleMap, v2);
            }
            return v2;
        }
    }

    protected static interface Factory {
        public AnimatableValue createValue(AnimationTarget var1, String var2, String var3, boolean var4, String var5);

        public AnimatableValue createValue(AnimationTarget var1, String var2, Value var3);
    }

    protected class AnimationThread
    extends Thread {
        protected Calendar time = Calendar.getInstance();
        protected RunnableQueue runnableQueue;
        protected Ticker ticker;

        protected AnimationThread() {
            this.runnableQueue = SVGAnimationEngine.this.ctx.getUpdateManager().getUpdateRunnableQueue();
            this.ticker = new Ticker();
        }

        public void run() {
            while (true) {
                this.time.setTime(new Date());
                this.ticker.t = SVGAnimationEngine.this.timedDocumentRoot.convertWallclockTime(this.time);
                try {
                    this.runnableQueue.invokeAndWait(this.ticker);
                }
                catch (InterruptedException e2) {
                    return;
                }
            }
        }

        protected class Ticker
        implements Runnable {
            protected float t;

            protected Ticker() {
            }

            public void run() {
                SVGAnimationEngine.super.tick(this.t, false);
            }
        }
    }

    protected static class AnimationTickRunnable
    implements RunnableQueue.IdleRunnable {
        protected Calendar time = Calendar.getInstance();
        protected long waitTime;
        protected RunnableQueue q;
        private static final int NUM_TIMES = 8;
        protected long[] times = new long[8];
        protected long sumTime;
        protected int timeIndex;
        protected WeakReference engRef;
        protected static final int MAX_EXCEPTION_COUNT = 10;
        protected int exceptionCount;

        public AnimationTickRunnable(RunnableQueue q2, SVGAnimationEngine eng) {
            this.q = q2;
            this.engRef = new WeakReference<SVGAnimationEngine>(eng);
            Arrays.fill(this.times, 100L);
            this.sumTime = 800L;
        }

        public void resume() {
            Object lock;
            this.waitTime = 0L;
            Object object = lock = this.q.getIteratorLock();
            synchronized (object) {
                lock.notify();
            }
        }

        public long getWaitTime() {
            return this.waitTime;
        }

        public void run() {
            SVGAnimationEngine eng;
            SVGAnimationEngine sVGAnimationEngine = eng = this.getAnimationEngine();
            synchronized (sVGAnimationEngine) {
                int animationLimitingMode;
                block17: {
                    animationLimitingMode = eng.animationLimitingMode;
                    float animationLimitingAmount = eng.animationLimitingAmount;
                    try {
                        try {
                            long before = System.currentTimeMillis();
                            this.time.setTime(new Date(before));
                            float t2 = eng.timedDocumentRoot.convertWallclockTime(this.time);
                            float t22 = SVGAnimationEngine.super.tick(t2, false);
                            long after = System.currentTimeMillis();
                            long dur = after - before;
                            if (dur == 0L) {
                                dur = 1L;
                            }
                            this.sumTime -= this.times[this.timeIndex];
                            this.sumTime += dur;
                            this.times[this.timeIndex] = dur;
                            this.timeIndex = (this.timeIndex + 1) % 8;
                            if (t22 == Float.POSITIVE_INFINITY) {
                                this.waitTime = Long.MAX_VALUE;
                            } else {
                                this.waitTime = before + (long)(t22 * 1000.0f) - 1000L;
                                if (this.waitTime < after) {
                                    this.waitTime = after;
                                }
                                if (animationLimitingMode != 0) {
                                    float ave = (float)this.sumTime / 8.0f;
                                    float delay = animationLimitingMode == 1 ? ave / animationLimitingAmount - ave : 1000.0f / animationLimitingAmount - ave;
                                    long newWaitTime = after + (long)delay;
                                    if (newWaitTime > this.waitTime) {
                                        this.waitTime = newWaitTime;
                                    }
                                }
                            }
                        }
                        catch (AnimationException ex) {
                            throw new BridgeException(eng.ctx, ex.getElement().getElement(), ex.getMessage());
                        }
                        this.exceptionCount = 0;
                    }
                    catch (Exception ex) {
                        if (++this.exceptionCount >= 10) break block17;
                        if (eng.ctx.getUserAgent() == null) {
                            ex.printStackTrace();
                        }
                        eng.ctx.getUserAgent().displayError(ex);
                    }
                }
                if (animationLimitingMode == 0) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }

        protected SVGAnimationEngine getAnimationEngine() {
            return (SVGAnimationEngine)((Object)this.engRef.get());
        }
    }

    protected static class DebugAnimationTickRunnable
    extends AnimationTickRunnable {
        float t = 0.0f;

        public DebugAnimationTickRunnable(RunnableQueue q2, SVGAnimationEngine eng) {
            super(q2, eng);
            this.waitTime = Long.MAX_VALUE;
            new Thread(this){
                private final /* synthetic */ DebugAnimationTickRunnable this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    BufferedReader r2 = new BufferedReader(new InputStreamReader(System.in));
                    System.out.println("Enter times.");
                    while (true) {
                        String s2;
                        try {
                            s2 = r2.readLine();
                        }
                        catch (IOException e2) {
                            s2 = null;
                        }
                        if (s2 == null) {
                            System.exit(0);
                        }
                        this.this$0.t = Float.parseFloat(s2);
                        this.this$0.resume();
                    }
                }
            }.start();
        }

        public void resume() {
            Object lock;
            this.waitTime = 0L;
            Object object = lock = this.q.getIteratorLock();
            synchronized (object) {
                lock.notify();
            }
        }

        public long getWaitTime() {
            long wt = this.waitTime;
            this.waitTime = Long.MAX_VALUE;
            return wt;
        }

        public void run() {
            SVGAnimationEngine eng;
            SVGAnimationEngine sVGAnimationEngine = eng = this.getAnimationEngine();
            synchronized (sVGAnimationEngine) {
                try {
                    try {
                        SVGAnimationEngine.super.tick(this.t, false);
                    }
                    catch (AnimationException ex) {
                        throw new BridgeException(eng.ctx, ex.getElement().getElement(), ex.getMessage());
                    }
                }
                catch (Exception ex) {
                    if (eng.ctx.getUserAgent() == null) {
                        ex.printStackTrace();
                    }
                    eng.ctx.getUserAgent().displayError(ex);
                }
            }
        }
    }

    protected class AnimationRoot
    extends TimedDocumentRoot {
        public AnimationRoot() {
            super(!SVGAnimationEngine.this.isSVG12, SVGAnimationEngine.this.isSVG12);
        }

        protected String getEventNamespaceURI(String eventName) {
            if (!SVGAnimationEngine.this.isSVG12) {
                return null;
            }
            if (eventName.equals("focusin") || eventName.equals("focusout") || eventName.equals("activate") || animationEventNames12.contains(eventName)) {
                return "http://www.w3.org/2001/xml-events";
            }
            return null;
        }

        protected String getEventType(String eventName) {
            if (eventName.equals("focusin")) {
                return "DOMFocusIn";
            }
            if (eventName.equals("focusout")) {
                return "DOMFocusOut";
            }
            if (eventName.equals("activate")) {
                return "DOMActivate";
            }
            if (SVGAnimationEngine.this.isSVG12 ? animationEventNames12.contains(eventName) : animationEventNames11.contains(eventName)) {
                return eventName;
            }
            return null;
        }

        protected String getRepeatEventName() {
            return "repeatEvent";
        }

        protected void fireTimeEvent(String eventType, Calendar time, int detail) {
            AnimationSupport.fireTimeEvent((EventTarget)((Object)SVGAnimationEngine.this.document), eventType, time, detail);
        }

        protected void toActive(float begin) {
        }

        protected void toInactive(boolean stillActive, boolean isFrozen) {
        }

        protected void removeFill() {
        }

        protected void sampledAt(float simpleTime, float simpleDur, int repeatIteration) {
        }

        protected void sampledLastValue(int repeatIteration) {
        }

        protected TimedElement getTimedElementById(String id) {
            return AnimationSupport.getTimedElementById(id, SVGAnimationEngine.this.document);
        }

        protected EventTarget getEventTargetById(String id) {
            return AnimationSupport.getEventTargetById(id, SVGAnimationEngine.this.document);
        }

        protected EventTarget getAnimationEventTarget() {
            return null;
        }

        protected EventTarget getRootEventTarget() {
            return (EventTarget)((Object)SVGAnimationEngine.this.document);
        }

        public Element getElement() {
            return null;
        }

        public boolean isBefore(TimedElement other) {
            return false;
        }

        protected void currentIntervalWillUpdate() {
            if (SVGAnimationEngine.this.animationTickRunnable != null) {
                SVGAnimationEngine.this.animationTickRunnable.resume();
            }
        }
    }
}

