/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.filter.IntervalFilter;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Interval;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SamRecordIntervalIteratorFactory {
    public CloseableIterator<SAMRecord> makeSamRecordIntervalIterator(SamReader samReader, List<Interval> uniqueIntervals, boolean useIndex) {
        if (!samReader.hasIndex() || !useIndex) {
            int stopAfterPosition;
            int stopAfterSequence;
            if (uniqueIntervals.isEmpty()) {
                stopAfterSequence = -1;
                stopAfterPosition = -1;
            } else {
                Interval lastInterval = uniqueIntervals.get(uniqueIntervals.size() - 1);
                stopAfterSequence = samReader.getFileHeader().getSequenceIndex(lastInterval.getContig());
                stopAfterPosition = lastInterval.getEnd();
            }
            IntervalFilter intervalFilter = new IntervalFilter(uniqueIntervals, samReader.getFileHeader());
            return new StopAfterFilteringIterator(samReader.iterator(), intervalFilter, stopAfterSequence, stopAfterPosition);
        }
        QueryInterval[] queryIntervals = new QueryInterval[uniqueIntervals.size()];
        for (int i2 = 0; i2 < queryIntervals.length; ++i2) {
            Interval inputInterval = uniqueIntervals.get(i2);
            queryIntervals[i2] = new QueryInterval(samReader.getFileHeader().getSequenceIndex(inputInterval.getContig()), inputInterval.getStart(), inputInterval.getEnd());
        }
        return samReader.queryOverlapping(queryIntervals);
    }

    private class StopAfterFilteringIterator
    implements CloseableIterator<SAMRecord> {
        private final int stopAfterSequence;
        private final int stopAfterPosition;
        private final Iterator<SAMRecord> iterator;
        private final SamRecordFilter filter;
        private SAMRecord next = null;

        private StopAfterFilteringIterator(Iterator<SAMRecord> iterator, SamRecordFilter filter, int stopAfterSequence, int stopAfterPosition) {
            this.stopAfterSequence = stopAfterSequence;
            this.stopAfterPosition = stopAfterPosition;
            this.iterator = iterator;
            this.filter = filter;
            this.next = this.getNextRecord();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SAMRecord next() {
            if (this.next == null) {
                throw new NoSuchElementException("Iterator has no more elements.");
            }
            SAMRecord result = this.next;
            this.next = this.getNextRecord();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove() not supported by FilteringIterator");
        }

        @Override
        public void close() {
            CloserUtil.close(this.iterator);
        }

        protected SAMRecord getNextRecord() {
            while (this.iterator.hasNext()) {
                SAMRecord record = this.iterator.next();
                if (record.getReferenceIndex() == -1) {
                    return null;
                }
                if (record.getReferenceIndex() > this.stopAfterSequence) {
                    return null;
                }
                if (record.getReferenceIndex() == this.stopAfterSequence && record.getAlignmentStart() > this.stopAfterPosition) {
                    return null;
                }
                if (this.filter.filterOut(record)) continue;
                return record;
            }
            return null;
        }
    }
}

