/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ExternalIntegerCodec
extends AbstractBitCodec<Integer> {
    private final OutputStream outputStream;
    private final InputStream inputStream;
    private final OutputStream nullOutputStream = new OutputStream(){

        @Override
        public void write(byte[] b2) throws IOException {
        }

        @Override
        public void write(int b2) throws IOException {
        }

        @Override
        public void write(byte[] b2, int off, int length) throws IOException {
        }
    };

    public ExternalIntegerCodec(OutputStream outputStream, InputStream inputStream) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
    }

    @Override
    public Integer read(BitInputStream bitInputStream) throws IOException {
        return ITF8.readUnsignedITF8(this.inputStream);
    }

    @Override
    public long write(BitOutputStream bitOutputStream, Integer value) throws IOException {
        return ITF8.writeUnsignedITF8((int)value, this.outputStream);
    }

    @Override
    public long numberOfBits(Integer value) {
        try {
            return ITF8.writeUnsignedITF8((int)value, this.nullOutputStream);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int length) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

