/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant;

import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.GenotypeType;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.PackedFeatures;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.event.TrackGroupEvent;
import org.broad.igv.ui.event.TrackGroupEventListener;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.variant.Allele;
import org.broad.igv.variant.Genotype;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantMenu;
import org.broad.igv.variant.VariantRenderer;

@XmlType(factoryMethod="getNextTrack")
public class VariantTrack
extends FeatureTrack
implements TrackGroupEventListener {
    private static Logger log = Logger.getLogger(VariantTrack.class);
    static final DecimalFormat numFormat = new DecimalFormat("#.###");
    private static final Color GREY_170 = new Color(170, 170, 170);
    private static final int GROUP_BORDER_WIDTH = 3;
    private static final Color BAND1_COLOR = new Color(245, 245, 245);
    private static final Color BAND2_COLOR = Color.white;
    private static final Color SELECTED_BAND_COLOR = new Color(210, 210, 210);
    private static final Color borderGray = new Color(200, 200, 200);
    private static final int DEFAULT_EXPANDED_GENOTYPE_HEIGHT = 15;
    private final int DEFAULT_SQUISHED_GENOTYPE_HEIGHT = 4;
    private static final int DEFAULT_VARIANT_BAND_HEIGHT = 25;
    private static final int MAX_FILTER_LINES = 15;
    public static int METHYLATION_MIN_BASE_COUNT = 10;
    private VariantRenderer renderer;
    private boolean enableMethylationRateSupport;
    private int top;
    @XmlAttribute(name="SQUISHED_ROW_HEIGHT")
    private int squishedHeight = 4;
    private int variantBandHeight = 25;
    List<String> allSamples;
    private boolean grouped;
    private String groupByAttribute;
    LinkedHashMap<String, List<String>> samplesByGroups = new LinkedHashMap();
    private ColorMode coloring = ColorMode.GENOTYPE;
    private boolean hideFiltered = false;
    private Variant selectedVariant;
    private List<SampleBounds> sampleBounds = new ArrayList<SampleBounds>();
    private List<String> selectedSamples = new ArrayList<String>();
    Map<String, String> alignmentFiles;
    static Map<String, String> fullNames = new HashMap<String, String>();

    public static boolean isVCF(String typeString) {
        return typeString.endsWith(".vcf3") || typeString.endsWith(".vcf4") || typeString.endsWith(".vcf") || typeString.endsWith(".bcf");
    }

    public void setRenderer(VariantRenderer renderer) {
        this.renderer = renderer;
    }

    public VariantTrack(String name, FeatureSource source) {
        this(null, source, Collections.emptyList(), false);
        this.setName(name);
    }

    public VariantTrack(ResourceLocator locator, FeatureSource source, List<String> samples, boolean enableMethylationRateSupport) {
        super(locator, source);
        String vcfToBamMapping;
        String path = locator != null ? locator.getPath() : null;
        this.renderer = new VariantRenderer(this);
        this.enableMethylationRateSupport = enableMethylationRateSupport;
        if (enableMethylationRateSupport) {
            this.coloring = ColorMode.METHYLATION_RATE;
        }
        this.allSamples = samples;
        this.setupGroupsFromAttributes();
        this.setDisplayMode(Track.DisplayMode.EXPANDED);
        if (IGV.hasInstance()) {
            IGV.getInstance().addGroupEventListener(this);
        }
        boolean bypassFileAutoDiscovery = PreferenceManager.getInstance().getAsBoolean("BYPASS_FILE_AUTO_DISCOVERY");
        String string = vcfToBamMapping = path != null ? path + ".mapping" : null;
        if (!bypassFileAutoDiscovery && ParsingUtils.pathExists(vcfToBamMapping)) {
            this.loadAlignmentMappings(vcfToBamMapping);
        }
        if (!(source instanceof TribbleFeatureSource) || ((TribbleFeatureSource)source).isIndexed()) {
            int defVisibilityWindow = PreferenceManager.getInstance().getAsInt("DEFAULT_VISIBILITY_WINDOW");
            if (defVisibilityWindow > 0) {
                this.setVisibilityWindow(defVisibilityWindow * 1000);
            } else {
                int vw = Math.max(10000, 2000000 - 2000 * this.allSamples.size());
                this.setVisibilityWindow(vw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAlignmentMappings(String bamListPath) {
        this.alignmentFiles = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(bamListPath);
            while ((nextLine = br.readLine()) != null) {
                boolean isAbsolute;
                String[] tokens = ParsingUtils.TAB_PATTERN.split(nextLine);
                if (tokens.length < 2) {
                    log.info("Skipping bam mapping file line: " + nextLine);
                    continue;
                }
                String alignmentPath = tokens[1];
                if (alignmentPath.startsWith("http://") || alignmentPath.startsWith("ftp:")) {
                    isAbsolute = true;
                } else {
                    String absolutePath = new File(alignmentPath).getAbsolutePath();
                    String prefix = absolutePath.substring(0, 3);
                    isAbsolute = alignmentPath.startsWith(prefix);
                }
                if (!isAbsolute) {
                    alignmentPath = FileUtils.getAbsolutePath(alignmentPath, bamListPath);
                }
                this.alignmentFiles.put(tokens[0], alignmentPath);
            }
        }
        catch (IOException e2) {
            MessageUtils.showMessage("<html>Error loading bam mapping file: " + bamListPath + "<br>" + e2.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    String getBamFileForSample(String sample) {
        return this.alignmentFiles == null ? null : this.alignmentFiles.get(sample);
    }

    private void setupGroupsFromAttributes() {
        String newGroupByAttribute;
        AttributeManager manager = AttributeManager.getInstance();
        String string = newGroupByAttribute = !IGV.hasInstance() ? null : IGV.getInstance().getGroupByAttribute();
        if (newGroupByAttribute == this.groupByAttribute || newGroupByAttribute != null && newGroupByAttribute.equals(this.groupByAttribute)) {
            return;
        }
        this.samplesByGroups.clear();
        this.groupByAttribute = newGroupByAttribute;
        if (this.groupByAttribute == null) {
            this.grouped = false;
            return;
        }
        for (String sample : this.allSamples) {
            String sampleGroup = manager.getAttribute(sample, newGroupByAttribute);
            List<String> sampleList = this.samplesByGroups.get(sampleGroup);
            if (sampleList == null) {
                sampleList = new ArrayList<String>();
                this.samplesByGroups.put(sampleGroup, sampleList);
            }
            sampleList.add(sample);
        }
        this.grouped = this.samplesByGroups.size() > 1;
        this.groupByAttribute = newGroupByAttribute;
    }

    public void sortSamples(Comparator<String> comparator) {
        Collections.sort(this.allSamples, comparator);
        for (List<String> samples : this.samplesByGroups.values()) {
            Collections.sort(samples, comparator);
        }
    }

    public boolean isEnableMethylationRateSupport() {
        return this.enableMethylationRateSupport;
    }

    public int getGenotypeBandHeight() {
        switch (this.getDisplayMode()) {
            case SQUISHED: {
                return this.getSquishedHeight();
            }
            case COLLAPSED: {
                return 0;
            }
        }
        return 15;
    }

    @Override
    public int getHeight() {
        int sampleCount = this.allSamples.size();
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED || sampleCount == 0) {
            return this.getVariantsHeight();
        }
        int groupCount = this.samplesByGroups.size();
        int margins = groupCount * 3;
        return this.getVariantsHeight() + margins + sampleCount * this.getGenotypeBandHeight();
    }

    public Object getHeader() {
        if (this.source instanceof TribbleFeatureSource) {
            return ((TribbleFeatureSource)this.source).getHeader();
        }
        return null;
    }

    private int getVariantsHeight() {
        return this.variantBandHeight * Math.max(1, this.getNumberOfFeatureLevels());
    }

    @Override
    public void setHeight(int height) {
        int sampleCount;
        Track.DisplayMode displayMode = this.getDisplayMode();
        if (displayMode == Track.DisplayMode.COLLAPSED) {
            return;
        }
        int groupCount = this.samplesByGroups.size();
        int margins = (groupCount - 1) * 3;
        int expandedHeight = this.variantBandHeight + margins + (sampleCount = this.allSamples.size()) * this.getGenotypeBandHeight();
        if (height < expandedHeight) {
            this.setDisplayMode(Track.DisplayMode.SQUISHED);
            this.squishedHeight = Math.max(1, (height - this.variantBandHeight - margins) / sampleCount);
        } else if (displayMode != Track.DisplayMode.EXPANDED) {
            this.setDisplayMode(Track.DisplayMode.EXPANDED);
        }
    }

    @Override
    protected void renderFeatureImpl(RenderContext context, Rectangle trackRectangle, PackedFeatures packedFeatures) {
        Graphics2D g2D = context.getGraphics();
        this.top = trackRectangle.y;
        Rectangle visibleRectangle = context.getVisibleRect();
        Rectangle tmpRect = new Rectangle(trackRectangle);
        tmpRect.height = this.getGenotypeBandHeight();
        tmpRect.y = trackRectangle.y;
        Rectangle bandRect = new Rectangle(tmpRect);
        bandRect.y += this.getVariantsHeight();
        this.drawBackground(g2D, bandRect, visibleRectangle, BackgroundType.DATA);
        List<PackedFeatures.FeatureRow> rows = packedFeatures.getRows();
        int overallFeatureRectHeight = this.getVariantsHeight();
        int overallSampleRectHeight = trackRectangle.height - overallFeatureRectHeight;
        Rectangle overallSampleRect = new Rectangle(trackRectangle.x, this.top + overallFeatureRectHeight, trackRectangle.width, overallSampleRectHeight);
        int curRowTop = this.top;
        if (rows.size() > 0) {
            double locScale = context.getScale();
            double origin = context.getOrigin();
            double pXMin = tmpRect.getMinX();
            double pXMax = tmpRect.getMaxX();
            tmpRect.height = this.variantBandHeight;
            int lastEndX = -1;
            int minSpacing = 3;
            for (PackedFeatures.FeatureRow row : rows) {
                List features = row.getFeatures();
                for (Feature feature : features) {
                    int spacing;
                    int end;
                    int dX;
                    int start;
                    int pX;
                    Variant variant = (Variant)feature;
                    if (this.hideFiltered && variant.isFiltered() || (double)((pX = (int)(((double)(start = variant.getStart()) - origin) / locScale)) + (dX = (int)Math.max(2.0, (double)((end = variant.getEnd()) - start) / locScale))) < pXMin) continue;
                    if ((double)pX > pXMax) break;
                    int w2 = dX;
                    int x2 = pX;
                    if (w2 < 3) {
                        w2 = 3;
                        --x2;
                    }
                    if ((spacing = x2 - lastEndX) > 0 && spacing < minSpacing && w2 > 2 * minSpacing) {
                        x2 += minSpacing - spacing;
                    }
                    tmpRect.y = curRowTop;
                    if (tmpRect.intersects(visibleRectangle)) {
                        this.renderer.renderSiteBand(variant, tmpRect, x2, w2, context);
                        lastEndX = x2 + w2 - 1;
                    }
                    this.renderSamples(g2D, visibleRectangle, variant, context, overallSampleRect, x2, w2);
                    boolean isSelected = this.selectedVariant != null && this.selectedVariant == variant;
                    if (!isSelected) continue;
                    Graphics2D selectionGraphics = context.getGraphic2DForColor(Color.black);
                    selectionGraphics.drawRect(x2, curRowTop, w2, this.getHeight());
                }
                if (!this.areFeaturesStacked()) continue;
                curRowTop += this.variantBandHeight;
                lastEndX = -1;
            }
        } else {
            tmpRect.height = this.variantBandHeight;
            tmpRect.y = trackRectangle.y;
            g2D.setColor(Color.gray);
            GraphicUtils.drawCenteredText("No Variants Found", trackRectangle, g2D);
        }
        this.renderBoundaryLines(g2D, trackRectangle, visibleRectangle);
    }

    private void drawLineIfVisible(Graphics2D g2D, Rectangle visibleRectangle, Color color, int yLoc, int left, int right) {
        if (yLoc >= visibleRectangle.y && (double)yLoc <= visibleRectangle.getMaxY()) {
            if (color != null) {
                g2D.setColor(color);
            }
            g2D.drawLine(left, yLoc, right, yLoc);
        }
    }

    private void drawVariantBandBorder(Graphics2D g2D, Rectangle visibleRectangle, int variantBandY, int left, int right) {
        if (this.allSamples.size() > 0) {
            this.drawLineIfVisible(g2D, visibleRectangle, Color.black, variantBandY, left, right);
        }
    }

    private void renderSamples(Graphics2D g2D, Rectangle visibleRectangle, Variant variant, RenderContext context, Rectangle overallSampleRect, int x2, int w2) {
        Rectangle tmpRect = new Rectangle(overallSampleRect);
        tmpRect.height = this.getGenotypeBandHeight();
        if (this.grouped) {
            for (Map.Entry<String, List<String>> entry : this.samplesByGroups.entrySet()) {
                for (String sample : entry.getValue()) {
                    if (overallSampleRect.intersects(visibleRectangle)) {
                        this.renderer.renderGenotypeBandSNP(variant, context, tmpRect, x2, w2, sample, this.coloring, this.hideFiltered);
                    }
                    tmpRect.y += tmpRect.height;
                }
            }
        } else {
            for (String sample : this.allSamples) {
                if (tmpRect.intersects(visibleRectangle)) {
                    this.renderer.renderGenotypeBandSNP(variant, context, tmpRect, x2, w2, sample, this.coloring, this.hideFiltered);
                }
                tmpRect.y += tmpRect.height;
            }
        }
    }

    private void renderBoundaryLines(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle) {
        this.top = trackRectangle.y;
        int left = trackRectangle.x;
        int right = (int)trackRectangle.getMaxX();
        this.drawLineIfVisible(g2D, visibleRectangle, Color.black, this.top + 1, left, right);
        int bottomY = trackRectangle.y + trackRectangle.height;
        this.drawLineIfVisible(g2D, visibleRectangle, borderGray, bottomY, left, right);
        int variantGenotypeBorderY = trackRectangle.y + this.getVariantsHeight();
        this.drawVariantBandBorder(g2D, visibleRectangle, variantGenotypeBorderY, left, right);
        if (this.grouped) {
            g2D.setColor(Color.black);
            int y = trackRectangle.y + this.getVariantsHeight();
            for (Map.Entry<String, List<String>> entry : this.samplesByGroups.entrySet()) {
                g2D.drawLine(trackRectangle.x, y += entry.getValue().size() * this.getGenotypeBandHeight() + 3, trackRectangle.x + trackRectangle.width, y);
            }
        }
    }

    @Override
    public void renderName(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle) {
        this.top = trackRectangle.y;
        Rectangle rect = new Rectangle(trackRectangle);
        g2D.setFont(FontManager.getFont(this.fontSize));
        g2D.setColor(BAND2_COLOR);
        g2D.setColor(Color.black);
        rect.height = this.getVariantsHeight();
        if (rect.intersects(visibleRectangle)) {
            GraphicUtils.drawWrappedText(this.getName(), rect, g2D, false);
        }
        rect.y += rect.height;
        rect.height = this.getGenotypeBandHeight();
        if (this.areFeaturesStacked()) {
            this.sampleBounds.clear();
            this.drawBackground(g2D, rect, visibleRectangle, BackgroundType.NAME);
        }
        this.renderBoundaryLines(g2D, trackRectangle, visibleRectangle);
    }

    @Override
    public void renderAttributes(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle, List<String> attributeNames, List<MouseableRegion> mouseRegions) {
        this.top = trackRectangle.y;
        Rectangle rect = new Rectangle(trackRectangle);
        rect.height = this.getVariantsHeight();
        if (rect.intersects(visibleRectangle)) {
            super.renderAttributes(g2D, rect, visibleRectangle, attributeNames, mouseRegions);
        }
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            return;
        }
        rect.y += rect.height;
        rect.height = this.getGenotypeBandHeight();
        Rectangle bandRectangle = new Rectangle(rect);
        this.drawBackground(g2D, rect, visibleRectangle, BackgroundType.ATTRIBUTE);
        if (this.grouped) {
            for (List<String> sampleList : this.samplesByGroups.values()) {
                this.renderAttributeBand(g2D, bandRectangle, visibleRectangle, attributeNames, sampleList, mouseRegions);
                bandRectangle.y += 3;
            }
        } else {
            this.renderAttributeBand(g2D, bandRectangle, visibleRectangle, attributeNames, this.allSamples, mouseRegions);
        }
        this.renderBoundaryLines(g2D, trackRectangle, visibleRectangle);
    }

    private void renderAttributeBand(Graphics2D g2D, Rectangle bandRectangle, Rectangle visibleRectangle, List<String> attributeNames, List<String> sampleList, List<MouseableRegion> mouseRegions) {
        for (String sample : sampleList) {
            if (bandRectangle.intersects(visibleRectangle)) {
                int x2 = bandRectangle.x;
                for (String name : attributeNames) {
                    String key = name.toUpperCase();
                    String attributeValue = AttributeManager.getInstance().getAttribute(sample, key);
                    if (attributeValue != null) {
                        Rectangle rect = new Rectangle(x2, bandRectangle.y, 10, bandRectangle.height);
                        g2D.setColor(AttributeManager.getInstance().getColor(key, attributeValue));
                        g2D.fill(rect);
                        mouseRegions.add(new MouseableRegion(rect, key, attributeValue));
                    }
                    x2 += 11;
                }
            }
            bandRectangle.y += bandRectangle.height;
        }
    }

    private void drawBackground(Graphics2D g2D, Rectangle bandRectangle, Rectangle visibleRectangle, BackgroundType type) {
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            return;
        }
        boolean coloredLast = true;
        Rectangle textRectangle = new Rectangle(bandRectangle);
        --textRectangle.height;
        int bandFontSize = Math.min(this.fontSize, (int)bandRectangle.getHeight() - 1);
        Font font = FontManager.getFont(bandFontSize);
        Font oldFont = g2D.getFont();
        g2D.setFont(font);
        if (this.grouped) {
            for (Map.Entry<String, List<String>> sampleGroup : this.samplesByGroups.entrySet()) {
                String group;
                int y0 = bandRectangle.y;
                List<String> sampleList = sampleGroup.getValue();
                coloredLast = this.colorBand(g2D, bandRectangle, visibleRectangle, coloredLast, textRectangle, sampleList, type);
                bandRectangle.y += 3;
                if (type != BackgroundType.NAME || bandRectangle.height >= 3 || (group = sampleGroup.getKey()) == null) continue;
                g2D.setColor(Color.black);
                g2D.setFont(oldFont);
                int y2 = bandRectangle.y;
                Rectangle textRect = new Rectangle(bandRectangle.x, y0, bandRectangle.width, y2 - y0);
                GraphicUtils.drawWrappedText(group, textRect, g2D, true);
            }
        } else {
            coloredLast = this.colorBand(g2D, bandRectangle, visibleRectangle, coloredLast, textRectangle, this.allSamples, type);
        }
        g2D.setFont(oldFont);
    }

    private boolean colorBand(Graphics2D g2D, Rectangle bandRectangle, Rectangle visibleRectangle, boolean coloredLast, Rectangle textRectangle, List<String> sampleList, BackgroundType type) {
        boolean supressFill = this.getDisplayMode() == Track.DisplayMode.SQUISHED && this.squishedHeight < 4;
        for (String sample : sampleList) {
            if (coloredLast) {
                g2D.setColor(BAND1_COLOR);
                coloredLast = false;
            } else {
                g2D.setColor(BAND2_COLOR);
                coloredLast = true;
            }
            if (bandRectangle.intersects(visibleRectangle)) {
                if (!supressFill) {
                    if (this.selectedSamples.contains(sample) && this.hasAlignmentFiles()) {
                        g2D.setColor(SELECTED_BAND_COLOR);
                    }
                    g2D.fillRect(bandRectangle.x, bandRectangle.y, bandRectangle.width, bandRectangle.height);
                }
                if (type == BackgroundType.NAME) {
                    this.sampleBounds.add(new SampleBounds(bandRectangle.y, bandRectangle.y + bandRectangle.height, sample));
                    if (bandRectangle.height >= 3) {
                        String printName = sample;
                        textRectangle.y = bandRectangle.y + 1;
                        g2D.setColor(Color.black);
                        GraphicUtils.drawWrappedText(printName, bandRectangle, g2D, false);
                    }
                } else if (type == BackgroundType.ATTRIBUTE) {
                    // empty if block
                }
            }
            bandRectangle.y += bandRectangle.height;
        }
        return coloredLast;
    }

    public boolean getHideFiltered() {
        return this.hideFiltered;
    }

    public void setHideFiltered(boolean value) {
        this.hideFiltered = value;
    }

    @XmlAttribute
    public ColorMode getColorMode() {
        return this.coloring;
    }

    public void setColorMode(ColorMode mode) {
        this.coloring = mode;
    }

    @Override
    public String getNameValueString(int y) {
        if (y < this.top + this.variantBandHeight) {
            return this.getName();
        }
        String sample = this.getSampleAtPosition(y);
        return sample;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        try {
            double maxDistance = 10.0 * frame.getScale();
            if (y < this.top + this.getVariantsHeight()) {
                int modY = this.areFeaturesStacked() ? y : -1;
                Variant variant = this.getFeatureClosest(position, modY, frame.getName(), maxDistance);
                if (variant == null) {
                    return null;
                }
                return this.getVariantToolTip(variant);
            }
            if (this.sampleBounds == null || this.sampleBounds.isEmpty()) {
                return null;
            }
            String sample = this.getSampleAtPosition(y);
            if (sample == null) {
                return null;
            }
            Variant variant = this.getFeatureClosest(position, -1, frame.getName(), maxDistance);
            return this.getSampleToolTip(sample, variant);
        }
        catch (Exception e2) {
            log.error("Error getting value string", e2);
            return null;
        }
    }

    private String getSampleAtPosition(int y) {
        if (this.sampleBounds.isEmpty()) {
            return null;
        }
        String sample = null;
        int sampleCount = this.sampleBounds.size();
        int firstSampleY = this.sampleBounds.get((int)0).top;
        int idx = Math.max(0, Math.min((y - firstSampleY) / this.getGenotypeBandHeight(), sampleCount - 1));
        SampleBounds bounds = this.sampleBounds.get(idx);
        if (bounds.contains(y)) {
            sample = bounds.sample;
        } else if (bounds.top > y) {
            while (idx > 0) {
                if (!(bounds = this.sampleBounds.get(--idx)).contains(y)) continue;
                sample = bounds.sample;
            }
        } else {
            while (idx < sampleCount - 1) {
                if (!(bounds = this.sampleBounds.get(++idx)).contains(y)) continue;
                sample = bounds.sample;
            }
        }
        return sample;
    }

    protected Variant getFeatureClosest(double position, int y, String frameName, double maxDistance) {
        PackedFeatures packedFeatures = (PackedFeatures)this.packedFeaturesMap.get(frameName);
        if (packedFeatures == null) {
            return null;
        }
        Feature feature = null;
        int row = (y - this.top) / this.variantBandHeight;
        List features = y < 0 || row >= this.getNumberOfFeatureLevels() ? packedFeatures.getFeatures() : packedFeatures.getRows().get(row).getFeatures();
        if (features != null) {
            feature = FeatureUtils.getFeatureClosest(position, features);
        }
        if (feature == null || position < (double)feature.getStart() - maxDistance || position > (double)feature.getEnd() + maxDistance) {
            return null;
        }
        return (Variant)feature;
    }

    private String getVariantToolTip(Variant variant) {
        String id = variant.getID();
        StringBuffer toolTip = new StringBuffer();
        toolTip.append("Chr: " + variant.getChr());
        toolTip.append("<br>Position: " + variant.getPositionString());
        toolTip.append("<br>ID: " + id);
        toolTip.append("<br>Reference: " + variant.getReference());
        List<Allele> alternates = variant.getAlternateAlleles();
        if (alternates.size() > 0) {
            toolTip.append("<br>Alternate: " + StringUtils.join(alternates, ","));
        }
        toolTip.append("<br>Qual: " + numFormat.format(variant.getPhredScaledQual()));
        toolTip.append("<br>Type: " + variant.getType());
        if (variant.isFiltered()) {
            toolTip.append("<br>Is Filtered Out: Yes</b>");
            toolTip = toolTip.append(this.getFilterTooltip(variant));
        } else {
            toolTip.append("<br>Is Filtered Out: No</b><br>");
        }
        toolTip.append("<br><b>Alleles:</b>");
        toolTip.append(this.getAlleleToolTip(variant));
        double[] af = variant.getAlleleFreqs();
        if (af[0] < 0.0 && variant.getSampleNames().size() > 0) {
            af = new double[]{variant.getAlleleFraction()};
        }
        String afMsg = "Unknown";
        if (af[0] >= 0.0) {
            afMsg = numFormat.format(af[0]);
            for (int ii = 1; ii < af.length; ++ii) {
                afMsg = afMsg + ", " + numFormat.format(af[ii]);
            }
        }
        toolTip.append("<br>Allele Frequency: " + afMsg + "<br>");
        if (variant.getSampleNames().size() > 0) {
            double afrac = variant.getAlleleFraction();
            toolTip = toolTip.append("<br>Minor Allele Fraction: " + numFormat.format(afrac) + "<br>");
        }
        toolTip.append("<br><b>Genotypes:</b>");
        toolTip.append(this.getGenotypesSummaryTooltip(variant) + "<br>");
        toolTip.append(this.getVariantInfo(variant) + "<br>");
        return toolTip.toString();
    }

    protected String getVariantInfo(Variant variant) {
        Set<String> keys = variant.getAttributes().keySet();
        if (keys.size() > 0) {
            String toolTip = "<br><b>Variant Attributes</b>";
            int count = 0;
            String k2 = "AF";
            String afValue = variant.getAttributeAsString(k2);
            if (afValue != null && afValue.length() > 0 && !afValue.equals("null")) {
                toolTip = toolTip.concat("<br>" + VariantTrack.getFullName(k2) + ": " + variant.getAttributeAsString(k2));
            }
            if ((afValue = variant.getAttributeAsString(k2 = "GMAF")) != null && afValue.length() > 0 && !afValue.equals("null")) {
                toolTip = toolTip.concat("<br>" + VariantTrack.getFullName(k2) + ": " + variant.getAttributeAsString(k2));
            }
            int maxFilterLines = this.getMaxFilterLines();
            for (String key : keys) {
                ++count;
                if (key.equals("AF") || key.equals("GMAF")) continue;
                if (count > maxFilterLines) {
                    toolTip = toolTip.concat("<br>....");
                    break;
                }
                toolTip = toolTip.concat("<br>" + VariantTrack.getFullName(key) + ": " + variant.getAttributeAsString(key));
            }
            return toolTip;
        }
        return " ";
    }

    private int getMaxFilterLines() {
        return IGV.getInstance().isShowDetailsOnHover() ? 15 : 1000;
    }

    private String getGenotypeInfo(Genotype genotype) {
        Map<String, Object> attributes = genotype.getAttributes();
        Set<String> keys = attributes.keySet();
        if (keys.size() > 0) {
            String tooltip = "<br><b>Genotype Attributes</b>";
            for (String key : keys) {
                tooltip = tooltip.concat("<br>" + VariantTrack.getFullName(key) + ": " + attributes.get(key));
            }
            return tooltip;
        }
        return null;
    }

    public void clearSelectedVariant() {
        this.selectedVariant = null;
    }

    public List<String> getAllSamples() {
        return this.allSamples;
    }

    public int getSquishedHeight() {
        return this.squishedHeight;
    }

    public void setSquishedHeight(int squishedHeight) {
        this.squishedHeight = squishedHeight;
    }

    @Override
    public void onTrackGroupEvent(TrackGroupEvent e2) {
        this.setupGroupsFromAttributes();
    }

    public boolean hasAlignmentFiles() {
        return this.alignmentFiles != null && !this.alignmentFiles.isEmpty();
    }

    public Collection<String> getSelectedSamples() {
        return this.selectedSamples;
    }

    static String getFullName(String key) {
        return fullNames.containsKey(key) ? fullNames.get(key) : key;
    }

    private String getSampleToolTip(String sample, Variant variant) {
        String sInfoStr;
        if (variant == null) {
            return null;
        }
        double goodBaseCount = variant.getGenotype(sample).getAttributeAsDouble("GB");
        if (Double.isNaN(goodBaseCount)) {
            goodBaseCount = 0.0;
        }
        if (this.isEnableMethylationRateSupport() && goodBaseCount < 10.0) {
            return sample;
        }
        String id = variant.getID();
        StringBuffer toolTip = new StringBuffer();
        toolTip = toolTip.append("Chr: " + variant.getChr());
        toolTip = toolTip.append("<br>Position: " + variant.getPositionString());
        toolTip = toolTip.append("<br>ID: " + id + "<br>");
        toolTip = toolTip.append("<br><b>Genotype Information</b>");
        toolTip = toolTip.append("<br>Sample: " + sample);
        Genotype genotype = variant.getGenotype(sample);
        if (genotype != null) {
            toolTip = toolTip.append("<br>Genotype: " + genotype.getGenotypeString());
            toolTip = toolTip.append("<br>Quality: " + numFormat.format(genotype.getPhredScaledQual()));
            toolTip = toolTip.append("<br>Type: " + genotype.getTypeString());
        }
        if (variant.isFiltered()) {
            toolTip = toolTip.append("<br>Is Filtered Out: Yes</b>");
            toolTip = toolTip.append(this.getFilterTooltip(variant));
        } else {
            toolTip = toolTip.append("<br>Is Filtered Out: No</b><br>");
        }
        if (genotype != null && (sInfoStr = this.getGenotypeInfo(genotype)) != null) {
            toolTip = toolTip.append(sInfoStr + "<br>");
        }
        return toolTip.toString();
    }

    private String getFilterTooltip(Variant variant) {
        Collection<String> filters = variant.getFilters();
        String toolTip = "<br>";
        for (String filter : filters) {
            toolTip = toolTip.concat("- " + filter + "<br>");
        }
        return toolTip;
    }

    private String getAlleleToolTip(Variant counts) {
        double noCall = counts.getNoCallCount() * 2;
        double aNum = (counts.getHetCount() + counts.getHomRefCount() + counts.getHomVarCount()) * 2;
        double aCount = (counts.getHomVarCount() * 2 + counts.getHetCount()) * 2;
        String toolTip = "<br>No Call: " + (int)noCall;
        toolTip = toolTip.concat("<br>Allele Num: " + (int)aNum);
        toolTip = toolTip.concat("<br>Allele Count: " + (int)aCount);
        return toolTip;
    }

    private String getGenotypesSummaryTooltip(Variant counts) {
        int noCall = counts.getNoCallCount();
        int homRef = counts.getHomRefCount();
        int nonVar = noCall + homRef;
        int het = counts.getHetCount();
        int homVar = counts.getHomVarCount();
        int var = het + homVar;
        String toolTip = "<br>Non Variant: " + nonVar;
        toolTip = toolTip.concat("<br> - No Call: " + noCall);
        toolTip = toolTip.concat("<br> - Hom Ref: " + homRef);
        toolTip = toolTip.concat("<br>Variant: " + var);
        toolTip = toolTip.concat("<br> - Het: " + het);
        toolTip = toolTip.concat("<br> - Hom Var: " + homVar);
        return toolTip;
    }

    public Variant getSelectedVariant(TrackClickEvent te) {
        ReferenceFrame referenceFrame = te.getFrame();
        Variant selVariant = null;
        if (referenceFrame != null && referenceFrame.getName() != null) {
            double position = te.getChromosomePosition();
            double maxDistance = 10.0 * referenceFrame.getScale();
            selVariant = this.getFeatureClosest(position, te.getMouseEvent().getY(), referenceFrame.getName(), maxDistance);
        }
        return selVariant;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        this.selectedVariant = this.getSelectedVariant(te);
        if (this.selectedVariant != null) {
            IGV.getInstance().doRefresh();
        }
        return new VariantMenu(this, this.selectedVariant);
    }

    @Override
    public void handleNameClick(MouseEvent e2) {
        String sampleAtPosition = this.getSampleAtPosition(e2.getY());
        if (e2.isPopupTrigger()) {
            return;
        }
        if (e2.isMetaDown() || e2.isControlDown()) {
            if (sampleAtPosition != null && !this.selectedSamples.contains(sampleAtPosition)) {
                this.selectedSamples.add(sampleAtPosition);
            }
        } else if (e2.isShiftDown() && !this.selectedSamples.isEmpty()) {
            int idx = this.getSampleIndex(sampleAtPosition);
            int lastIDX = this.getSampleIndex(this.selectedSamples.get(this.selectedSamples.size() - 1));
            if (idx >= 0 && lastIDX >= 0) {
                this.selectedSamples.clear();
                for (int i2 = Math.min(idx, lastIDX); i2 <= Math.max(idx, lastIDX); ++i2) {
                    String s2 = this.sampleBounds.get((int)i2).sample;
                    this.selectedSamples.add(s2);
                }
            }
        } else if (sampleAtPosition != null) {
            if (this.selectedSamples.size() == 1 && this.selectedSamples.contains(sampleAtPosition)) {
                this.selectedSamples.clear();
                IGV.getInstance().repaint();
                return;
            }
            this.selectedSamples.clear();
            this.selectedSamples.add(sampleAtPosition);
        }
        IGV.getInstance().repaint();
    }

    private int getSampleIndex(String sample) {
        for (int i2 = 0; i2 < this.sampleBounds.size(); ++i2) {
            if (!sample.equals(this.sampleBounds.get((int)i2).sample)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        if (this.hasAlignmentFiles()) {
            String selectedSample;
            ReferenceFrame referenceFrame = te.getFrame();
            double position = te.getChromosomePosition();
            double maxDistance = 10.0 * referenceFrame.getScale();
            Variant f2 = this.getFeatureClosest(position, te.getMouseEvent().getY(), te.getFrame().getName(), maxDistance);
            this.selectedSamples.clear();
            if (f2 != null && (selectedSample = this.getSampleAtPosition(te.getMouseEvent().getY())) != null) {
                int idx;
                String s2;
                Genotype gt;
                int i2;
                Genotype genotype = f2.getGenotype(selectedSample);
                GenotypeType type = genotype.getType();
                for (i2 = idx = this.getSampleIndex(selectedSample); i2 < this.sampleBounds.size() && (gt = f2.getGenotype(s2 = this.sampleBounds.get((int)i2).sample)) != null && type == gt.getType(); ++i2) {
                    this.selectedSamples.add(s2);
                }
                for (i2 = idx - 1; i2 >= 0 && (gt = f2.getGenotype(s2 = this.sampleBounds.get((int)i2).sample)) != null && type == gt.getType(); --i2) {
                    this.selectedSamples.add(s2);
                }
            }
            IGV.getInstance().doRefresh();
        }
        if (IGV.getInstance().isShowDetailsOnClick()) {
            this.openTooltipWindow(te);
        }
        return true;
    }

    public void loadSelectedBams() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean proceed;
                int nSamples = VariantTrack.this.selectedSamples.size();
                if (nSamples == 0) {
                    return;
                }
                HashSet<String> bams = new HashSet<String>(nSamples);
                String name = "";
                int n2 = 0;
                for (String sample : VariantTrack.this.selectedSamples) {
                    bams.add(VariantTrack.this.getBamFileForSample(sample));
                    if (++n2 >= 7) continue;
                    if (n2 == 6) {
                        name = name + "...";
                        continue;
                    }
                    name = name + sample;
                    if (n2 >= nSamples) continue;
                    name = name + ", ";
                }
                if (bams.size() > 20 && !(proceed = MessageUtils.confirm("Are you sure you want to load " + nSamples + " bams?"))) {
                    return;
                }
                String bamList = "";
                for (String bam : bams) {
                    bamList = bamList + bam + ",";
                }
                ResourceLocator loc = new ResourceLocator(bamList);
                loc.setType("alist");
                loc.setName(name);
                List<Track> tracks = null;
                try {
                    tracks = IGV.getInstance().load(loc);
                }
                catch (Exception e2) {
                    log.error("Error loading bam: " + loc.getPath(), e2);
                }
                TrackPanel panel = IGV.getInstance().getVcfBamPanel();
                panel.clearTracks();
                panel.addTracks(tracks);
            }
        };
        LongRunningTask.submit(runnable);
    }

    @Override
    public Feature nextFeature(String chr, double center, boolean forward, ReferenceFrame frame) throws IOException {
        if (this.getHideFiltered()) {
            Feature f2;
            while ((f2 = super.nextFeature(chr, center, forward, frame)) != null) {
                if (f2 instanceof Variant && ((Variant)f2).isFiltered()) continue;
                return f2;
            }
            return null;
        }
        return super.nextFeature(chr, center, forward, frame);
    }

    private static VariantTrack getNextTrack() {
        return (VariantTrack)IGVSessionReader.getNextTrack();
    }

    static {
        fullNames.put("AA", "Ancestral Allele");
        fullNames.put("AC", "Allele Count in Genotypes");
        fullNames.put("AN", "Total Alleles in Genotypes");
        fullNames.put("AF", "Allele Frequency");
        fullNames.put("DP", "Depth");
        fullNames.put("MQ", "Mapping Quality");
        fullNames.put("NS", "Number of Samples with Data");
        fullNames.put("BQ", "RMS Base Quality");
        fullNames.put("SB", "Strand Bias");
        fullNames.put("DB", "dbSNP Membership");
        fullNames.put("GQ", "Genotype Quality");
        fullNames.put("GL", "Genotype Likelihoods");
    }

    static class SampleBounds {
        int top;
        int bottom;
        String sample;

        SampleBounds(int top, int bottom, String sample) {
            this.top = top;
            this.bottom = bottom;
            this.sample = sample;
        }

        boolean contains(int y) {
            return y >= this.top && y <= this.bottom;
        }
    }

    public static enum BackgroundType {
        NAME,
        ATTRIBUTE,
        DATA;

    }

    public static enum ColorMode {
        GENOTYPE,
        METHYLATION_RATE,
        ALLELE;

    }
}

