/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.variant.Allele;
import org.broad.igv.variant.Genotype;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantTrack;

public class VariantRenderer {
    private static Logger log = Logger.getLogger(VariantRenderer.class);
    private static final int BOTTOM_MARGIN = 0;
    private static final int TOP_MARGIN = 3;
    private static float alphaValue = 0.2f;
    private static final Color colorAlleleRef = Color.gray;
    private static Color colorAlleleRefAlpha = ColorUtilities.getCompositeColor(colorAlleleRef, alphaValue);
    static Map<Character, Color> nucleotideColors = new HashMap<Character, Color>();
    private VariantTrack track;
    private Color colorAlleleBandVar;
    private Color colorAlleleBandVarAlpha;
    private Color colorAlleleBandRef;
    private Color colorAlleleBandRefAlpha;
    private Color colorHomRef;
    private Color colorHomRefAlpha;
    private Color colorHomVar;
    private Color colorHomVarAlpha;
    private Color colorHet;
    private Color colorHetAlpha;
    private Color colorNoCall;
    private Color colorNoCallAlpha;

    public VariantRenderer(VariantTrack track) {
        this.track = track;
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        this.colorAlleleBandVar = prefMgr.getAsColor("AF_VAR.COLOR");
        this.colorAlleleBandRef = prefMgr.getAsColor("AF_REF.COLOR");
        this.colorHomRef = prefMgr.getAsColor("HOMREF.COLOR");
        this.colorHomVar = prefMgr.getAsColor("HOMVAR.COLOR");
        this.colorHet = prefMgr.getAsColor("HETVAR.COLOR");
        this.colorNoCall = prefMgr.getAsColor("NOCALL.COLOR");
        this.colorHomRefAlpha = ColorUtilities.getCompositeColor(this.colorHomRef, alphaValue);
        this.colorHomVarAlpha = ColorUtilities.getCompositeColor(this.colorHomVar, alphaValue);
        this.colorHetAlpha = ColorUtilities.getCompositeColor(this.colorHet, alphaValue);
        this.colorNoCallAlpha = ColorUtilities.getCompositeColor(this.colorNoCall, alphaValue);
        this.colorAlleleBandVarAlpha = ColorUtilities.getCompositeColor(this.colorAlleleBandVar, alphaValue);
        this.colorAlleleBandRefAlpha = ColorUtilities.getCompositeColor(this.colorAlleleBandRef, alphaValue);
    }

    protected boolean defaultUseAlpha() {
        return false;
    }

    public void renderSiteBand(Variant variant, Rectangle bandRectangle, int pixelX, int xWidth, RenderContext context) {
        Graphics2D g2;
        Color refColor;
        double percent;
        Color alleleColor;
        boolean useAlpha;
        boolean bl = useAlpha = variant.isFiltered() || this.defaultUseAlpha();
        if (this.track.getColorMode() == VariantTrack.ColorMode.METHYLATION_RATE) {
            alleleColor = this.convertMethylationRateToColor((float)variant.getMethlationRate() / 100.0f);
            percent = variant.getCoveredSampleFraction();
            refColor = useAlpha ? colorAlleleRefAlpha : colorAlleleRef;
        } else {
            double[] afreqs;
            alleleColor = useAlpha ? this.colorAlleleBandVarAlpha : this.colorAlleleBandVar;
            double af = variant.getAlleleFraction();
            if (af < 0.0 && (afreqs = variant.getAlleleFreqs()) != null && afreqs.length > 0) {
                af = afreqs[0];
            }
            if ((percent = Math.min(1.0, af)) <= 0.0) {
                percent = 0.0;
                refColor = useAlpha ? colorAlleleRefAlpha : colorAlleleRef;
            } else {
                refColor = useAlpha ? this.colorAlleleBandRefAlpha : this.colorAlleleBandRef;
            }
        }
        int bottomY = this.calculateBottomYSiteBand(bandRectangle);
        int barHeight = this.calculateBarHeightSiteBand(bandRectangle);
        int alleleBarHeight = (int)(percent * (double)barHeight);
        int remainderHeight = barHeight - alleleBarHeight;
        if (remainderHeight > 0) {
            g2 = context.getGraphic2DForColor(refColor);
            g2.fillRect(pixelX, bottomY - alleleBarHeight - remainderHeight, xWidth, remainderHeight);
        }
        if (alleleBarHeight > 0) {
            g2 = context.getGraphic2DForColor(alleleColor);
            g2.fillRect(pixelX, bottomY - alleleBarHeight, xWidth, alleleBarHeight);
        }
    }

    protected int calculateBottomYSiteBand(Rectangle bandRectangle) {
        return bandRectangle.y + bandRectangle.height - 0;
    }

    protected int calculateBarHeightSiteBand(Rectangle bandRectangle) {
        return bandRectangle.height - 3 - 0;
    }

    public void renderGenotypeBandSNP(Variant variant, RenderContext context, Rectangle bandRectangle, int pX0, int dX, String sampleName, VariantTrack.ColorMode coloring, boolean hideFiltered) {
        int pY = (int)bandRectangle.getY();
        int dY = (int)bandRectangle.getHeight();
        int tOffset = 6;
        int bOffset = 8;
        Graphics2D g2 = (Graphics2D)context.getGraphics().create();
        if (dX >= 10) {
            Font f2;
            if (dY > 24) {
                f2 = FontManager.getFont(1, Math.min(dX, 12));
                g2.setFont(f2);
            } else if (dY > 18) {
                f2 = FontManager.getFont(1, Math.min(dX, 8));
                tOffset = 4;
                bOffset = 5;
                g2.setFont(f2);
            }
        }
        boolean isFiltered = variant.isFiltered() && hideFiltered;
        Genotype genotype = variant.getGenotype(sampleName);
        if (sampleName.equals("CYP26B1-B12")) {
            System.out.println(genotype.getTypeString() + "   " + genotype.getGenotypeString() + "  " + isFiltered);
        }
        if (genotype == null) {
            log.error("Genotype not found for sample " + sampleName);
        } else {
            Color b1Color = Color.gray;
            Color b2Color = Color.gray;
            char b1 = ' ';
            char b2 = ' ';
            switch (coloring) {
                case GENOTYPE: {
                    b2Color = b1Color = this.getGenotypeColor(genotype, isFiltered);
                    break;
                }
                case ALLELE: {
                    List<Allele> alleleList = genotype.getAlleles();
                    if (alleleList.size() > 0) {
                        b1 = this.getFirstBase(alleleList.get(0));
                        b1Color = nucleotideColors.get(Character.valueOf(b1));
                    }
                    if (alleleList.size() <= 1) break;
                    b2 = this.getFirstBase(alleleList.get(1));
                    b2Color = nucleotideColors.get(Character.valueOf(b2));
                    break;
                }
                case METHYLATION_RATE: {
                    double goodBaseCount = genotype.getAttributeAsDouble("GB");
                    b2Color = b1Color = this.colorNoCall;
                    double value = genotype.getAttributeAsDouble("MR");
                    if (!Double.isNaN(goodBaseCount) && !Double.isNaN(value)) {
                        if (goodBaseCount < (double)VariantTrack.METHYLATION_MIN_BASE_COUNT || Double.isNaN(value)) {
                            b2Color = b1Color = this.colorNoCall;
                            break;
                        }
                        float mr = (float)value;
                        b2Color = b1Color = this.convertMethylationRateToColor(mr /= 100.0f);
                        break;
                    }
                    log.error("GB and MR fields must be defined for all records in a VCF methylation file.");
                    break;
                }
                default: {
                    b2Color = b1Color = this.colorNoCall;
                }
            }
            int y0 = this.track.getDisplayMode() == Track.DisplayMode.EXPANDED ? pY + 1 : pY;
            int h2 = Math.max(1, this.track.getDisplayMode() == Track.DisplayMode.EXPANDED ? dY - 2 : dY);
            if (coloring == VariantTrack.ColorMode.GENOTYPE) {
                g2.setColor(b1Color);
                g2.fillRect(pX0, y0, dX, h2);
            } else {
                g2.setColor(b1Color);
                g2.fillRect(pX0, y0, dX / 2, h2);
                g2.setColor(b2Color);
                g2.fillRect(pX0 + dX / 2, y0, dX / 2, h2);
            }
            if (dX >= 10 && dY >= 18) {
                if (b1Color == Color.blue) {
                    g2.setColor(Color.white);
                } else {
                    g2.setColor(Color.black);
                }
                this.drawCenteredText(g2, new char[]{b1}, pX0, pY - tOffset, dX, dY);
                this.drawCenteredText(g2, new char[]{b2}, pX0, pY + dY / 2 - bOffset, dX, dY);
            }
        }
        g2.dispose();
    }

    private Color convertMethylationRateToColor(float mr) {
        float v2 = 1.5f + mr / 2.0f;
        return Color.getHSBColor(v2, 0.75f, 1.0f);
    }

    public char getFirstBase(Allele allele) {
        byte[] bases = allele.getBases();
        if (bases.length > 0) {
            return (char)bases[0];
        }
        return '.';
    }

    public Color getGenotypeColor(Genotype genotype, boolean isFiltered) {
        if (genotype.isNoCall()) {
            return isFiltered ? this.colorNoCallAlpha : this.colorNoCall;
        }
        if (genotype.isHomRef()) {
            return isFiltered ? this.colorHomRefAlpha : this.colorHomRef;
        }
        if (genotype.isHomVar()) {
            return isFiltered ? this.colorHomVarAlpha : this.colorHomVar;
        }
        if (genotype.isHet()) {
            return isFiltered ? this.colorHetAlpha : this.colorHet;
        }
        return Color.white;
    }

    private void drawCenteredText(Graphics2D g2, char[] chars, int x2, int y, int w2, int h2) {
        FontMetrics fm = g2.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x2 + w2 / 2 - msg_width / 2;
        int msgY = y + h2 / 2 - descent / 2 + ascent / 2;
        g2.drawChars(chars, 0, 1, msgX, msgY);
    }

    static {
        nucleotideColors.put(Character.valueOf('A'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('a'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('C'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('c'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('T'), Color.RED);
        nucleotideColors.put(Character.valueOf('t'), Color.RED);
        nucleotideColors.put(Character.valueOf('G'), new Color(242, 182, 65));
        nucleotideColors.put(Character.valueOf('g'), new Color(242, 182, 65));
        nucleotideColors.put(Character.valueOf('N'), colorAlleleRef);
        nucleotideColors.put(Character.valueOf('n'), colorAlleleRef);
        nucleotideColors.put(Character.valueOf('.'), colorAlleleRef);
        nucleotideColors.put(null, Color.BLACK);
    }
}

