/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongocollab;

import com.mongodb.ReflectionDBObject;
import htsjdk.tribble.Feature;
import java.awt.Color;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.ui.color.ColorUtilities;

public class DBFeature
extends ReflectionDBObject
implements Feature {
    static Color DEFAULT_COLOR = IGVFeatureRenderer.DULL_BLUE;
    private String chr;
    private int start;
    private int end;
    private String description;
    private Color color = DEFAULT_COLOR;
    private String name;

    public DBFeature() {
    }

    DBFeature(String chr, int start, int end, String name, String description, Color color) {
        this.chr = chr;
        this.start = start;
        this.end = end;
        this.name = name;
        this.description = description;
        this.color = color;
    }

    static DBFeature create(Feature feature) {
        if (feature instanceof AbstractFeature) {
            return DBFeature.create((AbstractFeature)feature);
        }
        return new DBFeature(feature.getChr(), feature.getStart(), feature.getEnd(), null, null, DEFAULT_COLOR);
    }

    static DBFeature create(AbstractFeature feature) {
        Color color = feature.getColor() != null ? feature.getColor() : DEFAULT_COLOR;
        return new DBFeature(feature.getChr(), feature.getStart(), feature.getEnd(), feature.getName(), feature.getDescription(), color);
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public String getContig() {
        return this.chr;
    }

    public void setChr(String chr) {
        this.chr = chr;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUpperName() {
        return this.name != null ? this.name.toUpperCase() : null;
    }

    public void setUpperName(String upperName) {
    }

    public String getName() {
        return this.name;
    }

    public void setColor(Object color) {
        if (color instanceof Color) {
            this.color = (Color)color;
        } else if (color instanceof String) {
            this.color = ColorUtilities.stringToColor((String)color);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public IGVFeat createIGVFeature() {
        return new IGVFeat(this);
    }

    public static class IGVFeat
    extends BasicFeature {
        private DBFeature dbFeat;

        IGVFeat(DBFeature dbFeat) {
            super(dbFeat.getChr(), dbFeat.getStart(), dbFeat.getEnd());
            this.dbFeat = dbFeat;
            this.setName(dbFeat.getName());
            this.setDescription(dbFeat.getDescription());
            this.setColor(dbFeat.getColor());
        }

        DBFeature getDBFeature() {
            return this.dbFeat;
        }
    }
}

