/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DuplicateSet {
    private final List<SAMRecord> records = new ArrayList<SAMRecord>(10);
    private static final SAMRecordDuplicateComparator defaultComparator = new SAMRecordDuplicateComparator();
    private final SAMRecordDuplicateComparator comparator;
    private boolean needsSorting = false;
    private boolean setDuplicateFlag = false;

    public DuplicateSet() {
        this(true);
    }

    public DuplicateSet(boolean setDuplicateFlag) {
        this(setDuplicateFlag, defaultComparator);
    }

    public DuplicateSet(SAMRecordDuplicateComparator comparator) {
        this(true, comparator);
    }

    public DuplicateSet(boolean setDuplicateFlag, SAMRecordDuplicateComparator comparator) {
        this.setDuplicateFlag = setDuplicateFlag;
        this.comparator = comparator;
    }

    public int add(SAMRecord record) {
        int cmp;
        if (!this.records.isEmpty() && 0 != (cmp = this.comparator.duplicateSetCompare(this.getRepresentative(), record))) {
            return cmp;
        }
        this.records.add(record);
        this.needsSorting = true;
        return 0;
    }

    private void sort() {
        if (!this.records.isEmpty()) {
            Collections.sort(this.records, this.comparator);
            SAMRecord representative = this.records.get(0);
            if (this.setDuplicateFlag) {
                for (SAMRecord record : this.records) {
                    if (record.getReadUnmappedFlag() || record.isSecondaryOrSupplementary() || record.getReadName().equals(representative.getReadName())) continue;
                    record.setDuplicateReadFlag(true);
                }
                this.records.get(0).setDuplicateReadFlag(false);
            }
        }
        this.needsSorting = false;
    }

    public List<SAMRecord> getRecords() {
        if (this.needsSorting) {
            this.sort();
        }
        return this.records;
    }

    public SAMRecord getRepresentative() {
        if (this.needsSorting) {
            this.sort();
        }
        return this.records.get(0);
    }

    public int size() {
        return this.records.size();
    }

    public int numDuplicates() {
        int n2 = 0;
        for (SAMRecord record : this.records) {
            if (record.getReadUnmappedFlag() || record.isSecondaryOrSupplementary()) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public void setDuplicateFlag(boolean setDuplicateFlag) {
        this.setDuplicateFlag = setDuplicateFlag;
    }
}

