/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBCallback;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.LazyDBCallback;
import java.io.IOException;
import java.io.InputStream;
import org.bson.BSONCallback;
import org.bson.LazyBSONDecoder;

public class LazyDBDecoder
extends LazyBSONDecoder
implements DBDecoder {
    public static DBDecoderFactory FACTORY = new LazyDBDecoderFactory();

    public DBCallback getDBCallback(DBCollection collection) {
        return new LazyDBCallback(collection);
    }

    public DBObject decode(byte[] b2, DBCollection collection) {
        DBCallback cbk = this.getDBCallback(collection);
        cbk.reset();
        this.decode(b2, (BSONCallback)cbk);
        return (DBObject)cbk.get();
    }

    public DBObject decode(InputStream in, DBCollection collection) throws IOException {
        DBCallback cbk = this.getDBCallback(collection);
        cbk.reset();
        this.decode(in, (BSONCallback)cbk);
        return (DBObject)cbk.get();
    }

    static class LazyDBDecoderFactory
    implements DBDecoderFactory {
        LazyDBDecoderFactory() {
        }

        public DBDecoder create() {
            return new LazyDBDecoder();
        }
    }
}

