/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.aqua.BinaryPListParser;
import com.jidesoft.plaf.aqua.XMLElement;
import com.jidesoft.plaf.aqua.XMLParseException;
import com.jidesoft.utils.SecurityUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

class AquaPreferences {
    private static final Logger LOGGER = Logger.getLogger(AquaPreferences.class.getName());
    private static HashMap prefs;

    public static String getString(String key) {
        return (String)AquaPreferences.get(key);
    }

    public static Object get(String key) {
        if (prefs == null) {
            prefs = new HashMap();
            AquaPreferences.loadGlobalPreferences();
        }
        return prefs.get(key);
    }

    private static void loadGlobalPreferences() {
        prefs.put("AppleAquaColorVariant", "1");
        prefs.put("AppleHighlightColor", "0.709800 0.835300 1.000000");
        prefs.put("AppleCollationOrder", "en");
        prefs.put("AppleScrollBarVariant", "DoubleMax");
        prefs.put("AppleScrollerPagingBehavior", "false");
        File globalPrefsFile = new File(SecurityUtils.getProperty("user.home", "") + "/Library/Preferences/.GlobalPreferences.plist");
        try {
            XMLElement xml = AquaPreferences.readPList(globalPrefsFile);
            Iterator i0 = xml.iterateChildren();
            while (i0.hasNext()) {
                XMLElement xml1 = (XMLElement)i0.next();
                String key = null;
                Iterator i1 = xml1.iterateChildren();
                while (i1.hasNext()) {
                    XMLElement xml2 = (XMLElement)i1.next();
                    if (xml2.getName().equals("key")) {
                        key = xml2.getContent();
                        continue;
                    }
                    if (key != null) {
                        prefs.put(key, xml2.getContent());
                    }
                    key = null;
                }
            }
        }
        catch (IOException e2) {
            LOGGER.warning("AquaPreferences failed to load Mac OS X global system preferences - " + e2.getLocalizedMessage());
        }
        catch (Exception e3) {
            LOGGER.warning("AquaPreferences failed to load Mac OS X global system preferences - " + e3.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLElement readPList(File plistFile) throws IOException {
        FileReader reader = null;
        XMLElement xml = null;
        try {
            reader = new FileReader(plistFile);
            xml = new XMLElement(new HashMap(), false, false);
            try {
                xml.parseFromReader(reader);
            }
            catch (XMLParseException e2) {
                xml = new BinaryPListParser().parse(plistFile);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return xml;
    }
}

