/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import com.mongodb.util.JSON;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBSONObject
extends LinkedHashMap<String, Object>
implements BSONObject {
    private static final long serialVersionUID = -4415279469780082174L;

    public BasicBSONObject() {
    }

    public BasicBSONObject(int size) {
        super(size);
    }

    public BasicBSONObject(String key, Object value) {
        this.put(key, value);
    }

    public BasicBSONObject(Map m2) {
        super(m2);
    }

    @Override
    public Map toMap() {
        return new LinkedHashMap<String, Object>(this);
    }

    @Override
    public Object removeField(String key) {
        return this.remove(key);
    }

    @Override
    public boolean containsField(String field) {
        return super.containsKey(field);
    }

    @Override
    @Deprecated
    public boolean containsKey(String key) {
        return this.containsField(key);
    }

    @Override
    public Object get(String key) {
        return super.get(key);
    }

    public int getInt(String key) {
        Object o2 = this.get(key);
        if (o2 == null) {
            throw new NullPointerException("no value for: " + key);
        }
        return BSON.toInt(o2);
    }

    public int getInt(String key, int def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return BSON.toInt(foo);
    }

    public long getLong(String key) {
        Object foo = this.get(key);
        return ((Number)foo).longValue();
    }

    public long getLong(String key, long def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return ((Number)foo).longValue();
    }

    public double getDouble(String key) {
        Object foo = this.get(key);
        return ((Number)foo).doubleValue();
    }

    public double getDouble(String key, double def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return ((Number)foo).doubleValue();
    }

    public String getString(String key) {
        Object foo = this.get(key);
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    public String getString(String key, String def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return foo.toString();
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        if (foo instanceof Number) {
            return ((Number)foo).intValue() > 0;
        }
        if (foo instanceof Boolean) {
            return (Boolean)foo;
        }
        throw new IllegalArgumentException("can't coerce to bool:" + foo.getClass());
    }

    public ObjectId getObjectId(String field) {
        return (ObjectId)this.get(field);
    }

    public ObjectId getObjectId(String field, ObjectId def) {
        Object foo = this.get(field);
        return foo != null ? (ObjectId)foo : def;
    }

    public Date getDate(String field) {
        return (Date)this.get(field);
    }

    public Date getDate(String field, Date def) {
        Object foo = this.get(field);
        return foo != null ? (Date)foo : def;
    }

    @Override
    public Object put(String key, Object val) {
        return super.put(key, val);
    }

    @Override
    public void putAll(Map m2) {
        for (Map.Entry entry : m2.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject o2) {
        for (String k2 : o2.keySet()) {
            this.put(k2, o2.get(k2));
        }
    }

    public BasicBSONObject append(String key, Object val) {
        this.put(key, val);
        return this;
    }

    @Override
    public String toString() {
        return JSON.serialize(this);
    }

    @Override
    public boolean equals(Object o2) {
        if (!(o2 instanceof BSONObject)) {
            return false;
        }
        BSONObject other = (BSONObject)o2;
        if (!this.keySet().equals(other.keySet())) {
            return false;
        }
        for (String key : this.keySet()) {
            Object a2 = this.get(key);
            Object b2 = other.get(key);
            if (a2 == null && b2 != null) {
                return false;
            }
            if (b2 == null) {
                if (a2 == null) continue;
                return false;
            }
            if (a2 instanceof Number && b2 instanceof Number) {
                Number aNumber = (Number)a2;
                Number bNumber = (Number)b2;
                if (!(aNumber instanceof Double || bNumber instanceof Double || aNumber instanceof Float || bNumber instanceof Float ? aNumber.doubleValue() != bNumber.doubleValue() : aNumber.longValue() != bNumber.longValue())) continue;
                return false;
            }
            if (a2 instanceof Pattern && b2 instanceof Pattern) {
                Pattern p1 = (Pattern)a2;
                Pattern p2 = (Pattern)b2;
                if (p1.pattern().equals(p2.pattern()) && p1.flags() == p2.flags()) continue;
                return false;
            }
            if (a2.equals(b2)) continue;
            return false;
        }
        return true;
    }
}

