/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;

public class DataPanelPainter {
    private static Logger log = Logger.getLogger(DataPanelPainter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Collection<TrackGroup> groups, RenderContext context, int width, Color background, Rectangle visibleRect) {
        Graphics graphics2D = null;
        try {
            graphics2D = (Graphics2D)context.getGraphics().create();
            ((Graphics2D)graphics2D).setBackground(background);
            graphics2D.clearRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
            graphics2D.setColor(Color.BLACK);
            this.paintFrame(groups, context, width, visibleRect);
        }
        finally {
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintFrame(Collection<TrackGroup> groups, RenderContext context, int width, Rectangle visibleRect) {
        int trackX = 0;
        int trackY = 0;
        for (TrackGroup group : groups) {
            List<Track> trackList;
            if (visibleRect != null && trackY > visibleRect.y + visibleRect.height) break;
            if (!group.isVisible()) continue;
            if (groups.size() > 1) {
                Graphics2D greyGraphics = context.getGraphic2DForColor(UIConstants.LIGHT_GREY);
                greyGraphics.fillRect(0, trackY + 1, width, 9);
                trackY += 10;
            }
            if (group.isDrawBorder()) {
                Graphics2D graphics2D = context.getGraphic2DForColor(Color.black);
                graphics2D.drawLine(0, trackY - 1, width, trackY - 1);
            }
            List<Track> list = trackList = group.getTracks();
            synchronized (list) {
                for (Track track : trackList) {
                    if (track == null) continue;
                    int trackHeight = track.getHeight();
                    if (visibleRect != null) {
                        if (trackY > visibleRect.y + visibleRect.height) break;
                        if (trackY + trackHeight < visibleRect.y) {
                            if (!track.isVisible()) continue;
                            trackY += trackHeight;
                            continue;
                        }
                    }
                    if (!track.isVisible()) continue;
                    Rectangle rect = new Rectangle(trackX, trackY, width, trackHeight);
                    this.draw(track, rect, context);
                    trackY += trackHeight;
                }
            }
            if (!group.isDrawBorder()) continue;
            Graphics2D graphics2D = context.getGraphic2DForColor(Color.black);
            graphics2D.drawLine(0, trackY, width, trackY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void groupAutoscale(Collection<TrackGroup> groups, RenderContext context) {
        HashMap autoscaleGroups = new HashMap();
        for (TrackGroup group : groups) {
            List<Track> trackList;
            List<Track> list = trackList = group.getTracks();
            synchronized (list) {
                for (Track track : trackList) {
                    String asGroup = track.getAttributeValue("AUTOSCALE GROUP");
                    if (!autoscaleGroups.containsKey(asGroup)) {
                        autoscaleGroups.put(asGroup, new ArrayList());
                    }
                    ((List)autoscaleGroups.get(asGroup)).add(track);
                }
            }
        }
        if (autoscaleGroups.size() > 0) {
            for (List tracks : autoscaleGroups.values()) {
                this.autoscale(context, tracks);
            }
        }
    }

    private final void draw(Track track, Rectangle rect, RenderContext context) {
        track.render(context, rect);
        List<Track> overlayTracks = IGV.getInstance().getOverlayTracks(track);
        if (overlayTracks != null) {
            for (Track overlayTrack : overlayTracks) {
                if (overlayTrack == track) continue;
                overlayTrack.overlay(context, rect);
            }
        }
    }

    private List<Track> getVisibleTracks(Collection<TrackGroup> groups) {
        ArrayList<Track> visibleTracks = new ArrayList<Track>();
        for (TrackGroup group : groups) {
            ArrayList<Track> trackList = new ArrayList<Track>(group.getTracks());
            for (Track track : trackList) {
                if (track == null || !track.isVisible()) continue;
                visibleTracks.add(track);
            }
        }
        return visibleTracks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoscale(RenderContext context, List<Track> trackList) {
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation() + 1;
        Rectangle visibleRect = context.getVisibleRect();
        ArrayList<LocusScore> inViewScores = new ArrayList<LocusScore>();
        List<Track> list = trackList;
        synchronized (list) {
            for (Track track : trackList) {
                if (!(track instanceof DataTrack)) continue;
                inViewScores.addAll(((DataTrack)track).getInViewScores(context, visibleRect));
            }
            if (inViewScores.size() > 0) {
                FeatureUtils.sortFeatureList(inViewScores);
                DataTrack.InViewInterval inter = DataTrack.computeScale(start, end, inViewScores);
                for (Track track : trackList) {
                    if (!(track instanceof DataTrack)) continue;
                    DataRange dr = track.getDataRange();
                    float min = Math.min(0.0f, inter.dataMin);
                    float base = Math.max(min, dr.getBaseline());
                    float max = inter.dataMax;
                    if (max - min <= 2.8E-45f) {
                        max = min + 1.0f;
                    }
                    DataRange newDR = new DataRange(min, base, max, dr.isDrawBaseline());
                    newDR.setType(dr.getType());
                    track.setDataRange(newDR);
                }
            }
        }
    }
}

