/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import apple.dts.samplecode.osxadapter.OSXAdapter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicBorders;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.charts.ScatterPlotUtils;
import org.broad.igv.cli_plugin.PluginSpecReader;
import org.broad.igv.cli_plugin.ui.RunPlugin;
import org.broad.igv.cli_plugin.ui.SetPluginPathDialog;
import org.broad.igv.dev.db.DBProfileEditor;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ga4gh.Ga4ghAPIHelper;
import org.broad.igv.ga4gh.OAuthUtils;
import org.broad.igv.gs.GSOpenSessionMenuAction;
import org.broad.igv.gs.GSSaveSessionMenuAction;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.lists.GeneListManagerUI;
import org.broad.igv.lists.VariantListManager;
import org.broad.igv.tools.IgvToolsGui;
import org.broad.igv.track.CombinedDataSourceDialog;
import org.broad.igv.ui.AboutDialog;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.Main;
import org.broad.igv.ui.ManageGenomesDialog;
import org.broad.igv.ui.ShutdownThread;
import org.broad.igv.ui.VersionUpdateDialog;
import org.broad.igv.ui.action.BrowseEncodeAction;
import org.broad.igv.ui.action.BrowseGa4ghAction;
import org.broad.igv.ui.action.ExportRegionsMenuAction;
import org.broad.igv.ui.action.ExportTrackNamesMenuAction;
import org.broad.igv.ui.action.FilterTracksMenuAction;
import org.broad.igv.ui.action.FitDataToWindowMenuAction;
import org.broad.igv.ui.action.GroupTracksMenuAction;
import org.broad.igv.ui.action.ImportRegionsMenuAction;
import org.broad.igv.ui.action.LoadFilesMenuAction;
import org.broad.igv.ui.action.LoadFromDatabaseAction;
import org.broad.igv.ui.action.LoadFromGSMenuAction;
import org.broad.igv.ui.action.LoadFromServerAction;
import org.broad.igv.ui.action.LoadFromURLMenuAction;
import org.broad.igv.ui.action.LoadGenomeFromGSMenuAction;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.action.NavigateRegionsMenuAction;
import org.broad.igv.ui.action.NewSessionMenuAction;
import org.broad.igv.ui.action.OpenSessionMenuAction;
import org.broad.igv.ui.action.ResetPreferencesAction;
import org.broad.igv.ui.action.RunScriptMenuAction;
import org.broad.igv.ui.action.SaveSessionMenuAction;
import org.broad.igv.ui.action.SetTrackHeightMenuAction;
import org.broad.igv.ui.action.SortTracksMenuAction;
import org.broad.igv.ui.legend.LegendDialog;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.ReorderPanelsDialog;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.HistoryMenu;
import org.broad.igv.ui.util.MenuAndToolbarUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.encode.EncodeFileBrowser;

public class IGVMenuBar
extends JMenuBar {
    private static Logger log = Logger.getLogger(IGVMenuBar.class);
    public static final String GENOMESPACE_REG_TOOLTIP = "Register for GenomeSpace";
    public static final String GENOMESPACE_REG_PAGE = "http://www.genomespace.org/register";
    private JMenu fileMenu;
    private JMenu extrasMenu;
    private FilterTracksMenuAction filterTracksAction;
    private JMenu viewMenu;
    IGV igv;
    private JMenu toolsMenu;
    private JMenuItem loadFromServerMenuItem;
    private static final String LOAD_GENOME_SERVER_TOOLTIP = "Select genomes available on the server to appear in menu.";
    private static final String CANNOT_LOAD_GENOME_SERVER_TOOLTIP = "Could not reach genome server";
    private static IGVMenuBar instance;
    private JMenu googleMenu;

    public void notifyGenomeServerReachable(boolean reachable) {
        if (this.loadFromServerMenuItem != null) {
            this.loadFromServerMenuItem.setEnabled(reachable);
            String tooltip = reachable ? LOAD_GENOME_SERVER_TOOLTIP : CANNOT_LOAD_GENOME_SERVER_TOOLTIP;
            this.loadFromServerMenuItem.setToolTipText(tooltip);
        }
    }

    public void showAboutDialog() {
        new AboutDialog(IGV.getMainFrame(), true).setVisible(true);
    }

    static IGVMenuBar createInstance(IGV igv) {
        if (instance != null) {
            if (igv == IGVMenuBar.instance.igv) {
                return instance;
            }
            throw new IllegalStateException("Cannot create another IGVMenuBar, use getInstance");
        }
        instance = new IGVMenuBar(igv);
        return instance;
    }

    public static IGVMenuBar getInstance() {
        return instance;
    }

    private IGVMenuBar(IGV igv) {
        this.igv = igv;
        this.setBorder(new BasicBorders.MenuBarBorder(Color.GRAY, Color.GRAY));
        this.setBorderPainted(true);
        for (AbstractButton menu : this.createMenus()) {
            this.add(menu);
        }
        if (Globals.IS_MAC) {
            try {
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("showAboutDialog", null));
                OSXAdapter.setQuitHandler(ShutdownThread.class, ShutdownThread.class.getDeclaredMethod("runS", null));
            }
            catch (Exception e2) {
                log.error("Error setting apple-specific about and quit handlers", e2);
            }
        }
    }

    private List<AbstractButton> createMenus() {
        ArrayList<AbstractButton> menus = new ArrayList<AbstractButton>();
        this.createFileMenu();
        menus.add(this.fileMenu);
        menus.add(this.createGenomesMenu());
        menus.add(this.createViewMenu());
        menus.add(this.createTracksMenu());
        menus.add(this.createRegionsMenu());
        this.refreshToolsMenu();
        menus.add(this.toolsMenu);
        menus.add(this.createGenomeSpaceMenu());
        this.extrasMenu = this.createExtrasMenu();
        menus.add(this.extrasMenu);
        this.googleMenu = this.createGoogleMenu();
        this.googleMenu.setVisible(PreferenceManager.getInstance().get("GOOGLE_API_KEY") != null || PreferenceManager.getInstance().getAsBoolean("ENABLE_GOOGLE_MENU"));
        menus.add(this.googleMenu);
        menus.add(this.createHelpMenu());
        return menus;
    }

    void refreshToolsMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>(10);
        MenuAction menuAction = new RunScriptMenuAction("Run Batch Script...", 88, this.igv);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SortTracksMenuAction("Run igvtools...", 84, this.igv){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IgvToolsGui.launch(false, IGVMenuBar.this.igv.getGenomeManager().getGenomeId());
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        List<JComponent> otherToolMenus = this.igv.getOtherToolMenus();
        if (otherToolMenus.size() > 0) {
            for (JComponent entry : otherToolMenus) {
                menuItems.add(entry);
            }
        }
        JMenuItem addTool = new JMenuItem("Add Tool...");
        addTool.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                File pluginFi = FileDialogUtils.chooseFile("Select cli_plugin .xml spec");
                if (pluginFi == null) {
                    return;
                }
                try {
                    PluginSpecReader.addCustomPlugin(pluginFi.getAbsolutePath());
                    IGVMenuBar.this.refreshToolsMenu();
                }
                catch (IOException e1) {
                    MessageUtils.showErrorMessage("Error loading custom cli_plugin", e1);
                }
            }
        });
        for (final PluginSpecReader pluginSpecReader : PluginSpecReader.getPlugins()) {
            for (final PluginSpecReader.Tool tool : pluginSpecReader.getTools()) {
                final String toolName = tool.name;
                boolean toolVisible = tool.visible;
                if (!toolVisible) continue;
                final String toolPath = pluginSpecReader.getToolPath(tool);
                final String tool_url = tool.toolUrl;
                boolean isValid = PluginSpecReader.isToolPathValid(toolPath);
                ActionListener invalidActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        String msg = String.format("%s executable not found at %s", toolName, toolPath);
                        if (tool_url != null) {
                            msg = msg + "<br/>See " + tool_url + " to install";
                        }
                        MessageUtils.showMessage(msg);
                    }
                };
                JMenu toolMenu = new JMenu(toolName);
                for (final PluginSpecReader.Command command : tool.commandList) {
                    String cmdName = command.name;
                    JMenuItem cmdItem = new JMenuItem(cmdName);
                    ((Container)toolMenu).add(cmdItem);
                    if (isValid || toolPath == null) {
                        cmdItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e2) {
                                RunPlugin runPlugin = null;
                                try {
                                    runPlugin = new RunPlugin(IGV.getMainFrame(), pluginSpecReader, tool, command);
                                }
                                catch (IllegalStateException e1) {
                                    MessageUtils.showErrorMessage(e1.getMessage(), e1);
                                    return;
                                }
                                runPlugin.setVisible(true);
                            }
                        });
                        cmdItem.setEnabled(true);
                        continue;
                    }
                    cmdItem.setEnabled(false);
                }
                if (tool.defaultPath != null) {
                    JMenuItem setPathItem = new JMenuItem(String.format("Set path to %s...", toolName));
                    setPathItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e2) {
                            new SetPluginPathDialog(IGV.getMainFrame(), pluginSpecReader, tool).setVisible(true);
                            IGVMenuBar.this.refreshToolsMenu();
                        }
                    });
                    ((Container)toolMenu).add(setPathItem);
                }
                menuItems.add(toolMenu);
            }
        }
        boolean showDBEditor = Globals.isDevelopment();
        if (showDBEditor) {
            JMenu sqlDBProfileEditor = new JMenu("SQL DB Profile Editor");
            JMenuItem createNewProfile = new JMenuItem("Create New Profile");
            createNewProfile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    File file = FileDialogUtils.chooseFile("Save DB Profile", DirectoryManager.getUserDirectory(), FileDialogUtils.SAVE);
                    if (file != null) {
                        DBProfileEditor editor = new DBProfileEditor(IGV.getMainFrame(), file.getAbsolutePath());
                        editor.setVisible(true);
                    }
                }
            });
            JMenuItem editExistingProfile = new JMenuItem("Edit Existing Profile");
            editExistingProfile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    File file = FileDialogUtils.chooseFile("Select .dbxml database profile");
                    if (file != null) {
                        if (!file.exists()) {
                            // empty if block
                        }
                        DBProfileEditor editor = new DBProfileEditor(IGV.getMainFrame(), file.getAbsolutePath());
                        editor.setVisible(true);
                    }
                }
            });
            sqlDBProfileEditor.add(createNewProfile);
            sqlDBProfileEditor.add(editExistingProfile);
            menuItems.add(sqlDBProfileEditor);
        }
        JMenuItem combineDataItem = new JMenuItem("Combine Data Tracks");
        combineDataItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                CombinedDataSourceDialog dialog = new CombinedDataSourceDialog(IGV.getMainFrame());
                dialog.setVisible(true);
            }
        });
        menuItems.add(combineDataItem);
        MenuAction toolsMenuAction = new MenuAction("Tools", null);
        if (this.toolsMenu == null) {
            this.toolsMenu = MenuAndToolbarUtils.createMenu(menuItems, toolsMenuAction);
            this.toolsMenu.setName("Tools");
        } else {
            this.toolsMenu.removeAll();
            for (JComponent item : menuItems) {
                this.toolsMenu.add(item);
            }
        }
    }

    public void enableExtrasMenu() {
        this.extrasMenu.setVisible(true);
    }

    void createFileMenu() {
        String genomeId;
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        boolean genomeLoaded = GenomeManager.getInstance().getCurrentGenome() != null;
        menuItems.add(new JSeparator());
        menuAction = new LoadFilesMenuAction("Load from File...", 76, this.igv);
        menuAction.setToolTipText("Load tracks or sample information");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromURLMenuAction("Load from URL...", 85, this.igv);
        menuAction.setToolTipText("Load tracks or sample information");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromServerAction("Load from Server...", 83, this.igv);
        menuAction.setToolTipText("Load tracks or sample information from a server");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromURLMenuAction("Load from DAS...", 68, this.igv);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        if (PreferenceManager.getInstance().getAsBoolean("DB_ENABLED")) {
            menuAction = new LoadFromDatabaseAction("Load from Database...", 0, this.igv);
            menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        }
        if (EncodeFileBrowser.genomeSupported(genomeId = IGV.getInstance().getGenomeManager().getGenomeId())) {
            menuAction = new BrowseEncodeAction("Load from ENCODE...", 69, this.igv);
            menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        }
        if (PreferenceManager.getInstance().get("GOOGLE_API_KEY") != null || PreferenceManager.getInstance().getAsBoolean("ENABLE_GOOGLE_MENU")) {
            menuAction = new BrowseGa4ghAction("Load from Ga4gh...", 71, this.igv);
            menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        }
        if (!genomeLoaded) {
            for (JComponent menuItem : menuItems) {
                menuItem.setEnabled(false);
            }
        }
        menuItems.add(new JSeparator());
        menuAction = new NewSessionMenuAction("New Session...", 78, this.igv);
        menuAction.setToolTipText("Create a new session");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new OpenSessionMenuAction("Open Session...", 79, this.igv);
        menuAction.setToolTipText("Reload the session");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SaveSessionMenuAction("Save Session...", 86, this.igv);
        menuAction.setToolTipText("Save the current session");
        JMenuItem saveSessionItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        menuItems.add(saveSessionItem);
        saveSessionItem.setEnabled(genomeLoaded);
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Save Image ...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGVMenuBar.this.igv.saveImage(IGVMenuBar.this.igv.getMainPanel());
            }
        };
        menuAction.setToolTipText("Capture and save an image");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Exit", null, 88){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGVMenuBar.this.doExitApplication();
            }
        };
        menuAction.setToolTipText("Exit the application");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        this.igv.getRecentSessionList().clear();
        String recentSessions = PreferenceManager.getInstance().getRecentSessions();
        if (recentSessions != null) {
            String[] sessions;
            for (String sessionPath : sessions = recentSessions.split(";")) {
                if (this.igv.getRecentSessionList().contains(sessionPath)) continue;
                this.igv.getRecentSessionList().add(sessionPath);
            }
        }
        if (!IGV.getInstance().getRecentSessionList().isEmpty()) {
            menuItems.add(new JSeparator());
            for (String session : IGV.getInstance().getRecentSessionList()) {
                OpenSessionMenuAction osMenuAction = new OpenSessionMenuAction(session, session, IGV.getInstance());
                menuItems.add(MenuAndToolbarUtils.createMenuItem(osMenuAction));
            }
        }
        MenuAction fileMenuAction = new MenuAction("File", null, 70);
        if (this.fileMenu == null) {
            this.fileMenu = MenuAndToolbarUtils.createMenu(menuItems, fileMenuAction);
        } else {
            this.fileMenu.removeAll();
            for (JComponent item : menuItems) {
                this.fileMenu.add(item);
            }
        }
    }

    private void notifyGenomesAddedRemoved(List<GenomeListItem> selectedValues, boolean added) {
        if (selectedValues == null || selectedValues.size() == 0) {
            return;
        }
        int size = selectedValues.size();
        String msg = "";
        msg = size == 1 ? msg + selectedValues.get(0) + " genome" : msg + size + " genomes";
        msg = added ? msg + " added to" : msg + " removed from";
        msg = msg + " list";
        MessageUtils.setStatusBarMessage(msg);
    }

    private JMenu createGenomesMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new MenuAction("Load Genome from File...", null, 73){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ProgressMonitor monitor = new ProgressMonitor();
                    IGVMenuBar.this.igv.doLoadGenome(monitor);
                }
                catch (Exception e2) {
                    MessageUtils.showErrorMessage(e2.getMessage(), e2);
                }
            }
        };
        menuAction.setToolTipText("Load a FASTA or .genome file...");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromURLMenuAction("Load Genome from URL...", 0, this.igv);
        menuAction.setToolTipText("Load a FASTA or .genome file...");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Load Genome From Server...", null){

            @Override
            public void actionPerformed(ActionEvent event) {
                IGV.getInstance().loadGenomeFromServerAction();
            }
        };
        menuAction.setToolTipText(LOAD_GENOME_SERVER_TOOLTIP);
        this.loadFromServerMenuItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        menuItems.add(this.loadFromServerMenuItem);
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Create .genome File...", null, 68){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProgressMonitor monitor = new ProgressMonitor();
                IGVMenuBar.this.igv.doDefineGenome(monitor);
            }
        };
        menuAction.setToolTipText("Create a .genome file");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Manage Genome List...", null){

            @Override
            public void actionPerformed(ActionEvent event) {
                ManageGenomesDialog dialog2 = new ManageGenomesDialog(IGV.getMainFrame());
                dialog2.setVisible(true);
                boolean cancelled = dialog2.isCancelled();
                List<GenomeListItem> removedValuesList = dialog2.getRemovedValuesList();
                if (!cancelled) {
                    GenomeManager.getInstance().buildGenomeItemList();
                    IGVMenuBar.this.igv.getContentPane().getCommandBar().refreshGenomeListComboBox();
                    if (removedValuesList != null && !removedValuesList.isEmpty()) {
                        try {
                            GenomeManager.getInstance().deleteDownloadedGenomes(removedValuesList);
                        }
                        catch (IOException e2) {
                            MessageUtils.showErrorMessage("Error deleting genome files", e2);
                        }
                        GenomeManager.getInstance().updateImportedGenomePropertyFile();
                        IGVMenuBar.this.notifyGenomesAddedRemoved(removedValuesList, false);
                    }
                }
            }
        };
        menuAction.setToolTipText("Add, remove, or reorder genomes which appear in the dropdown list");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction genomeMenuAction = new MenuAction("Genomes", null);
        return MenuAndToolbarUtils.createMenu(menuItems, genomeMenuAction);
    }

    private JMenu createTracksMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new SortTracksMenuAction("Sort Tracks...", 83, IGV.getInstance());
        menuAction.setToolTipText("Sort tracks by attribute value");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new GroupTracksMenuAction("Group Tracks... ", 71, IGV.getInstance());
        menuAction.setToolTipText("Group tracks by attribute value");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        this.filterTracksAction = new FilterTracksMenuAction("Filter Tracks...", 70, IGV.getInstance());
        this.filterTracksAction.setToolTipText("Filter tracks by attribute value");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(this.filterTracksAction));
        menuItems.add(new JSeparator());
        menuAction = new FitDataToWindowMenuAction("Fit Data to Window", 87, IGV.getInstance());
        menuAction.setToolTipText("Resize track heights to make best use of vertical space without scrolling");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SetTrackHeightMenuAction("Set Track Height...", 72, IGV.getInstance());
        menuAction.setToolTipText("Set the height for all tracks");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction dataMenuAction = new MenuAction("Tracks", null, 75);
        return MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
    }

    private JMenu createViewMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new MenuAction("Preferences...", null, 80){

            @Override
            public void actionPerformed(ActionEvent e2) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        IGV.getInstance().doViewPreferences();
                    }
                });
            }
        };
        menuAction.setToolTipText("Set user specific preferences");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Color Legends ...", null, 72){

            @Override
            public void actionPerformed(ActionEvent e2) {
                new LegendDialog(IGV.getMainFrame()).setVisible(true);
            }
        };
        menuAction.setToolTipText("Edit color legends and scales");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Show Name Panel", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e2.getSource();
                if (menuItem.isSelected()) {
                    IGV.getInstance().getMainPanel().expandNamePanel();
                } else {
                    IGV.getInstance().getMainPanel().collapseNamePanel();
                }
                IGV.getInstance().doRefresh();
            }
        };
        boolean isShowing = IGV.getInstance().getMainPanel().isExpanded();
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
        menuItem.setSelected(isShowing);
        menuItem.setAction(menuAction);
        menuItems.add(menuItem);
        JMenuItem panelWidthmenuItem = new JMenuItem();
        menuAction = new MenuAction("Set Name Panel Width...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MainPanel mainPanel = IGV.getInstance().getMainPanel();
                String currentValue = String.valueOf(mainPanel.getNamePanelWidth());
                String newValue = MessageUtils.showInputDialog("Enter track name panel width: ", currentValue);
                if (newValue != null) {
                    try {
                        Integer w2 = Integer.parseInt(newValue);
                        if (w2 <= 0 || w2 == 1000) {
                            throw new NumberFormatException();
                        }
                        PreferenceManager.getInstance().put("NAME_PANEL_WIDTH", newValue);
                        mainPanel.setNamePanelWidth(w2);
                    }
                    catch (NumberFormatException ex) {
                        MessageUtils.showErrorMessage("Error: value must be a positive integer < 1000.", ex);
                    }
                }
            }
        };
        panelWidthmenuItem.setAction(menuAction);
        menuItems.add(panelWidthmenuItem);
        boolean isShow = PreferenceManager.getInstance().getAsBoolean("IGV.track.show.attribute.views");
        IGV.getInstance().doShowAttributeDisplay(isShow);
        menuAction = new MenuAction("Show Attribute Display", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e2.getSource();
                PreferenceManager.getInstance().setShowAttributeView(menuItem.getState());
                IGV.getInstance().getMainPanel().invalidate();
                IGV.getInstance().doRefresh();
            }
        };
        menuItem = MenuAndToolbarUtils.createMenuItem(menuAction, isShow);
        menuItems.add(menuItem);
        menuAction = new MenuAction("Select Attributes to Show...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGV.getInstance().doSelectDisplayableAttribute();
            }
        };
        menuAction.setToolTipText("Customize attribute display to show only checked attributes");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Show Header Panel", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e2.getSource();
                if (menuItem.isSelected()) {
                    IGV.getInstance().getMainPanel().restoreHeader();
                } else {
                    IGV.getInstance().getMainPanel().removeHeader();
                }
                IGV.getInstance().doRefresh();
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction, true));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Reorder Panels...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ReorderPanelsDialog dlg = new ReorderPanelsDialog(IGV.getMainFrame());
                dlg.setVisible(true);
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuItems.add(new HistoryMenu("Go to"));
        MenuAction dataMenuAction = new MenuAction("View", null, 86);
        this.viewMenu = MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
        return this.viewMenu;
    }

    private JMenu createRegionsMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new NavigateRegionsMenuAction("Region Navigator ...", IGV.getInstance());
        menuAction.setToolTipText("Navigate regions");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Gene Lists...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GeneListManagerUI.getInstance(IGV.getMainFrame()).setVisible(true);
            }
        };
        menuAction.setToolTipText("Open gene list manager");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new ExportRegionsMenuAction("Export Regions ...", 69, IGV.getInstance());
        menuAction.setToolTipText("Save all defined regions to a file");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new ImportRegionsMenuAction("Import Regions ...", 73, IGV.getInstance());
        menuAction.setToolTipText("Load regions from a file");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction dataMenuAction = new MenuAction("Regions", null, 86);
        this.viewMenu = MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
        return this.viewMenu;
    }

    private JMenu createHelpMenu() {
        Desktop desktop;
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new MenuAction("User Guide ... "){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    BrowserLauncher.openURL("http://www.broadinstitute.org/igv/UserGuide");
                }
                catch (IOException ex) {
                    log.error("Error opening browser", ex);
                }
            }
        };
        menuAction.setToolTipText("Open web help page");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
            menuAction = new MenuAction("Help Forum..."){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    try {
                        URI uri = new URI("http://groups.google.com/forum/#!forum/igv-help");
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception ex) {
                        log.error("Error opening igv-help uri", ex);
                    }
                }
            };
            menuAction.setToolTipText("Email support");
            menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        }
        menuAction = new MenuAction("Check for Updates..."){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGVMenuBar.this.checkVersion();
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("About IGV "){

            @Override
            public void actionPerformed(ActionEvent e2) {
                new AboutDialog(IGV.getMainFrame(), true).setVisible(true);
            }
        };
        menuAction.setToolTipText("Display application information");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction helpMenuAction = new MenuAction("Help");
        return MenuAndToolbarUtils.createMenu(menuItems, helpMenuAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVersion() {
        int readTimeout = Globals.READ_TIMEOUT;
        int connectTimeout = Globals.CONNECT_TIMEOUT;
        try {
            Main.Version thisVersion = Main.Version.getVersion(Globals.VERSION);
            if (thisVersion == null) {
                return;
            }
            Globals.CONNECT_TIMEOUT = 5000;
            Globals.READ_TIMEOUT = 1000;
            String serverVersionString = HttpUtils.getInstance().getContentsAsString(new URL(Globals.getVersionURL())).trim();
            String skipString = PreferenceManager.getInstance().get("SKIP_VERSION");
            HashSet<String> skipVersion = new HashSet<String>(Arrays.asList(skipString.split(",")));
            if (skipVersion.contains(serverVersionString)) {
                return;
            }
            Main.Version serverVersion = Main.Version.getVersion(serverVersionString.trim());
            if (serverVersion == null) {
                return;
            }
            if (thisVersion.lessThan(serverVersion)) {
                log.info("A later version of IGV is available (" + serverVersionString + ")");
                VersionUpdateDialog dlg = new VersionUpdateDialog(serverVersionString);
                dlg.setVisible(true);
                if (dlg.isSkipVersion()) {
                    String newSkipString = skipString + "," + serverVersionString;
                    PreferenceManager.getInstance().put("SKIP_VERSION", newSkipString);
                }
            } else {
                MessageUtils.showMessage("IGV is up to date");
            }
        }
        catch (Exception e2) {
            log.error("Error checking version", e2);
        }
        finally {
            Globals.CONNECT_TIMEOUT = connectTimeout;
            Globals.READ_TIMEOUT = readTimeout;
        }
    }

    private JMenu createGenomeSpaceMenu() {
        JMenu menu = new JMenu("GenomeSpace");
        MenuAction menuAction = null;
        menuAction = new LoadFromGSMenuAction("Load File from GenomeSpace...", 85, this.igv);
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menu.addSeparator();
        menuAction = new LoadGenomeFromGSMenuAction("Load Genome from GenomeSpace...", 90, this.igv);
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menu.addSeparator();
        menuAction = new GSSaveSessionMenuAction("Save Session to GenomeSpace...", this.igv);
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new GSOpenSessionMenuAction("Load Session from GenomeSpace...", this.igv);
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menu.add(new JSeparator());
        menuAction = new MenuAction("Logout"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GSUtils.logout();
                if (MessageUtils.confirm("You must shutdown IGV to complete the GenomeSpace logout. Shutdown now?")) {
                    IGVMenuBar.this.doExitApplication();
                }
            }
        };
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menu.add(new JSeparator());
        menuAction = new MenuAction("Register... "){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    BrowserLauncher.openURL(IGVMenuBar.GENOMESPACE_REG_PAGE);
                }
                catch (IOException ex) {
                    log.error("Error opening browser", ex);
                }
            }
        };
        menuAction.setToolTipText(GENOMESPACE_REG_TOOLTIP);
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menu.setVisible(PreferenceManager.getInstance().getAsBoolean("GENOME_SPACE_ENABLE"));
        return menu;
    }

    private JMenu createExtrasMenu() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new ResetPreferencesAction("Reset Preferences", IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Variant list ...  *EXPERIMENTAL*"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VariantListManager.openNavigator(IGV.getMainFrame());
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Set window dimensions", null, 67){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String[] vals;
                String value = JOptionPane.showInputDialog("Enter dimensions, e.g. 800x400");
                if (value != null && (vals = value.split("x")).length == 2) {
                    int w2 = Integer.parseInt(vals[0]);
                    int h2 = Integer.parseInt(vals[1]);
                    IGV.getMainFrame().setSize(w2, h2);
                }
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Save Screenshot ...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGV.getInstance().saveImage(IGV.getInstance().getContentPane());
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new ExportTrackNamesMenuAction("Export track names...", IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Scatter Plot ..."){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ReferenceFrame defaultFrame = FrameManager.getDefaultFrame();
                String chr = defaultFrame.getChrName();
                int start = (int)defaultFrame.getOrigin();
                int end = (int)defaultFrame.getEnd();
                int zoom = defaultFrame.getZoom();
                ScatterPlotUtils.openPlot(chr, start, end, zoom);
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction extrasMenuAction = new MenuAction("Extras");
        JMenu menu = MenuAndToolbarUtils.createMenu(menuItems, extrasMenuAction);
        JMenu lfMenu = new JMenu("L&F");
        LookAndFeel lf = UIManager.getLookAndFeel();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            final String lfName = info.getName();
            JMenuItem cb = new JMenuItem(lfName);
            cb.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!lfName.equals(info.getName())) continue;
                        try {
                            UIManager.setLookAndFeel(info.getClassName());
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        break;
                    }
                }
            });
            lfMenu.add(cb);
        }
        menu.add(lfMenu);
        menu.setVisible(false);
        return menu;
    }

    private JMenu createGoogleMenu() {
        JMenu menu = new JMenu("Google");
        final JMenuItem login = new JMenuItem("Login ... ");
        login.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    OAuthUtils.getInstance().openAuthorizationPage();
                }
                catch (Exception ex) {
                    MessageUtils.showErrorMessage("Error fetching oAuth tokens.  See log for details", ex);
                    log.error("Error fetching oAuth tokens", ex);
                }
            }
        });
        login.setEnabled(false);
        menu.add(login);
        final JMenuItem logout = new JMenuItem("Logout ");
        logout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                OAuthUtils.getInstance().logout();
            }
        });
        logout.setEnabled(false);
        menu.add(logout);
        final JMenuItem loadReadset = new JMenuItem("Load Genomics ReadGroupSet... ");
        loadReadset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String readsetId = MessageUtils.showInputDialog("Enter ReadGroupSet ID (e.g. CMvnhpKTFhCjz9_25e_lCw): ");
                if (readsetId != null) {
                    ResourceLocator locator = new ResourceLocator(readsetId);
                    locator.setName(readsetId);
                    locator.setType("ga4gh");
                    locator.setAttribute("provider", Ga4ghAPIHelper.GA4GH_GOOGLE_PROVIDER);
                    IGV.getInstance().loadTracks(Arrays.asList(locator));
                }
            }
        });
        loadReadset.setEnabled(false);
        menu.add(loadReadset);
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e2) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        boolean loggedIn = OAuthUtils.getInstance().isLoggedIn();
                        if (loggedIn) {
                            login.setText(OAuthUtils.getInstance().getCurrentUserName());
                        } else {
                            login.setText("Login ...");
                        }
                        login.setEnabled(!loggedIn);
                        logout.setEnabled(loggedIn);
                        loadReadset.setEnabled(loggedIn);
                    }
                };
                LongRunningTask.submit(runnable);
            }

            @Override
            public void menuDeselected(MenuEvent e2) {
            }

            @Override
            public void menuCanceled(MenuEvent e2) {
            }
        });
        return menu;
    }

    public void resetSessionActions() {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.resetTrackFilter();
        }
    }

    public void setFilterMatchAll(boolean value) {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.setFilterMatchAll(value);
        }
    }

    public boolean isFilterMatchAll() {
        if (this.filterTracksAction != null) {
            return this.filterTracksAction.isFilterMatchAll();
        }
        return false;
    }

    public void setFilterShowAllTracks(boolean value) {
        if (this.filterTracksAction != null) {
            this.filterTracksAction.setFilterShowAllTracks(value);
        }
    }

    public boolean isFilterShowAllTracks() {
        if (this.filterTracksAction != null) {
            return this.filterTracksAction.getShowAllTracksFilterCheckBox().isSelected();
        }
        return false;
    }

    public JMenu getViewMenu() {
        return this.viewMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doExitApplication() {
        try {
            IGV.getInstance().saveStateForExit();
            Frame mainFrame = IGV.getMainFrame();
            mainFrame.setVisible(false);
            mainFrame.dispose();
        }
        finally {
            System.exit(0);
        }
    }

    static void destroyInstance() {
        instance = null;
    }

    public void enableGoogleMenu(boolean aBoolean) {
        this.googleMenu.setVisible(aBoolean);
    }
}

