/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.converters;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import org.apache.commons.math.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;

public class ExpressionFormatter {
    private static Logger log = Logger.getLogger(ExpressionFormatter.class);
    FileType type;
    int dataStartColumn;
    int probeColumn;
    int descriptionColumn = -1;
    int nPts;

    public void convert(File inputFile, File outputFile) throws IOException {
        this.convert(inputFile, outputFile, this.getType(inputFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convert(File inputFile, File outputFile, FileType type) throws IOException {
        this.setType(type);
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            reader = new BufferedReader(new FileReader(inputFile));
            writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            String nextLine = null;
            while ((nextLine = reader.readLine()).startsWith("#") && nextLine != null) {
                writer.println(nextLine);
            }
            writer.println(nextLine);
            int nCols = 0;
            if (type == FileType.TAB || type == FileType.RES) {
                nCols = nextLine.split("\t").length;
            }
            if (type == FileType.GCT) {
                nextLine = reader.readLine();
                nCols = nextLine.split("\t").length;
                writer.println(nextLine);
            } else if (type == FileType.RES) {
                writer.println(reader.readLine());
                writer.println(reader.readLine());
            }
            int columnSkip = 1;
            if (type == FileType.RES) {
                columnSkip = 2;
                ++nCols;
            }
            this.nPts = (nCols - this.dataStartColumn) / columnSkip;
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                for (int i2 = 0; i2 < this.dataStartColumn; ++i2) {
                    writer.print(tokens[i2] + "\t");
                }
                DataRow row = new DataRow(tokens, nextLine);
                for (int i3 = 0; i3 < this.nPts; ++i3) {
                    if (Double.isNaN(row.scaledData[i3])) {
                        writer.print("\t");
                        continue;
                    }
                    writer.print(row.scaledData[i3]);
                    if (type == FileType.RES) {
                        writer.print("\t" + row.calls[i3]);
                    }
                    if (i3 >= this.nPts - 1) continue;
                    writer.print("\t");
                }
                writer.println();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private FileType getType(File inputFile) {
        String fn = inputFile.getName().toLowerCase();
        if (fn.endsWith(".txt") || fn.endsWith(".tab") || fn.endsWith(".xls") || fn.endsWith(".gz")) {
            fn = fn.substring(0, fn.lastIndexOf("."));
        }
        if (fn.endsWith("res")) {
            return FileType.RES;
        }
        if (fn.endsWith("gct")) {
            return FileType.GCT;
        }
        if (fn.endsWith("tab")) {
            return FileType.TAB;
        }
        throw new RuntimeException("Unknown file type: " + inputFile);
    }

    private void setType(FileType type) {
        this.type = type;
        this.descriptionColumn = -1;
        switch (type) {
            case RES: {
                this.dataStartColumn = 2;
                this.probeColumn = 1;
                this.descriptionColumn = 0;
                break;
            }
            case GCT: {
                this.dataStartColumn = 2;
                this.probeColumn = 0;
                this.descriptionColumn = 1;
                break;
            }
            case TAB: {
                this.dataStartColumn = 1;
                this.probeColumn = 0;
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: java -jar ExpressionFormatter <inputFile> <outputFile>");
            return;
        }
        File inputFile = new File(args[0]);
        File outputFile = new File(args[1]);
        new ExpressionFormatter().convert(inputFile, outputFile);
    }

    class DataRow {
        private String probe;
        private String description;
        private double[] data;
        private double[] scaledData;
        private String[] calls;
        private double median;
        private double mad;

        DataRow(String[] tokens, String line) {
            int i2;
            double[] nonNullData = new double[ExpressionFormatter.this.nPts];
            this.data = new double[ExpressionFormatter.this.nPts];
            this.scaledData = new double[ExpressionFormatter.this.nPts];
            Arrays.fill(this.data, Double.NaN);
            Arrays.fill(this.scaledData, Double.NaN);
            this.calls = new String[ExpressionFormatter.this.nPts];
            Arrays.fill(this.calls, "");
            this.probe = tokens[ExpressionFormatter.this.probeColumn];
            if (ExpressionFormatter.this.descriptionColumn >= 0) {
                this.description = tokens[ExpressionFormatter.this.descriptionColumn];
            }
            int skip = ExpressionFormatter.this.type == FileType.RES ? 2 : 1;
            int nNonNull = 0;
            for (int dataIdx = 0; dataIdx < ExpressionFormatter.this.nPts; ++dataIdx) {
                i2 = ExpressionFormatter.this.dataStartColumn + dataIdx * skip;
                if (tokens[i2] != null) {
                    try {
                        double v2;
                        this.data[dataIdx] = Double.parseDouble(tokens[i2]);
                        if (this.data[dataIdx] < 0.0) {
                            throw new RuntimeException("Negative value detected in input file: " + line);
                        }
                        this.scaledData[dataIdx] = v2 = Math.log(this.data[dataIdx]) / Globals.log2;
                        nonNullData[nNonNull] = v2;
                        ++nNonNull;
                    }
                    catch (NumberFormatException e2) {
                        // empty catch block
                    }
                }
                if (ExpressionFormatter.this.type != FileType.RES) continue;
                this.calls[dataIdx] = tokens[i2 + 1].trim();
            }
            this.median = StatUtils.percentile(nonNullData, 0, nNonNull, 50.0);
            nNonNull = 0;
            for (int i3 = 0; i3 < this.scaledData.length; ++i3) {
                if (Double.isNaN(this.scaledData[i3])) continue;
                int n2 = i3;
                this.scaledData[n2] = this.scaledData[n2] - this.median;
                nonNullData[nNonNull] = this.scaledData[i3];
                ++nNonNull;
            }
            double[] deviations = new double[nNonNull];
            for (i2 = 0; i2 < nNonNull; ++i2) {
                deviations[i2] = Math.abs(nonNullData[i2] - 0.0);
            }
            this.mad = 1.4826 * StatUtils.percentile(deviations, 50.0);
            for (i2 = 0; i2 < this.scaledData.length; ++i2) {
                if (Double.isNaN(this.scaledData[i2])) continue;
                int n3 = i2;
                this.scaledData[n3] = this.scaledData[n3] / this.mad;
            }
        }
    }

    static enum FileType {
        GCT,
        RES,
        TAB;

    }
}

