/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cursor;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.broad.igv.cursor.CursorIdeogramPanel;
import org.broad.igv.cursor.CursorMainPanel;
import org.broad.igv.cursor.CursorModel;
import org.broad.igv.cursor.CursorTrack;
import org.broad.igv.cursor.CursorUtils;

public class CursorTrackLabelPanel
extends JComponent
implements Serializable {
    final CursorModel model;
    final CursorTrack track;
    int sortDirection = 1;
    JButton sortButton;
    JRadioButton selectButton;
    CursorIdeogramPanel ideogramPanel;

    public CursorTrackLabelPanel(final CursorTrack track, final CursorModel model, final CursorMainPanel mainPanel) {
        this.track = track;
        this.model = model;
        this.sortButton = new JButton("Sort");
        this.sortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                model.sortFrames(track, CursorTrackLabelPanel.this.sortDirection);
                CursorTrackLabelPanel.this.sortDirection *= -1;
                mainPanel.repaint();
            }
        });
        this.add(this.sortButton);
        this.selectButton = new JRadioButton();
        this.add(this.selectButton);
        mainPanel.addTrackSelectionButton(this.selectButton);
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (CursorTrackLabelPanel.this.selectButton.isSelected()) {
                    model.setRegions(CursorUtils.createRegions(track));
                    mainPanel.repaint();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Rectangle bound = this.getBounds();
            this.sortButton.setBounds(0, 0, 50, bound.height);
            this.selectButton.setBounds(60, 0, bound.width - 40, bound.height);
        }
    }
}

