/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.util.HaltingThread;

public class CompositeGraphicsNode
extends AbstractGraphicsNode
implements List {
    public static final Rectangle2D VIEWPORT = new Rectangle();
    public static final Rectangle2D NULL_RECT = new Rectangle();
    protected GraphicsNode[] children;
    protected volatile int count;
    protected volatile int modCount;
    protected Rectangle2D backgroundEnableRgn = null;
    private volatile Rectangle2D geometryBounds;
    private volatile Rectangle2D primitiveBounds;
    private volatile Rectangle2D sensitiveBounds;
    private Shape outline;

    public List getChildren() {
        return this;
    }

    public void setBackgroundEnable(Rectangle2D bgRgn) {
        this.backgroundEnableRgn = bgRgn;
    }

    public Rectangle2D getBackgroundEnable() {
        return this.backgroundEnableRgn;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void primitivePaint(Graphics2D g2d) {
        if (this.count == 0) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        int i2 = 0;
        while (i2 < this.count) {
            if (HaltingThread.hasBeenHalted(currentThread)) {
                return;
            }
            GraphicsNode node = this.children[i2];
            if (node != null) {
                node.paint(g2d);
            }
            ++i2;
        }
    }

    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.geometryBounds = null;
        this.primitiveBounds = null;
        this.sensitiveBounds = null;
        this.outline = null;
    }

    public Rectangle2D getPrimitiveBounds() {
        if (this.primitiveBounds != null) {
            if (this.primitiveBounds == NULL_RECT) {
                return null;
            }
            return this.primitiveBounds;
        }
        Thread currentThread = Thread.currentThread();
        int i2 = 0;
        Rectangle2D bounds = null;
        while (bounds == null && i2 < this.count) {
            bounds = this.children[i2++].getTransformedBounds(GraphicsNode.IDENTITY);
            if ((i2 & 0xF) == 0 && HaltingThread.hasBeenHalted(currentThread)) break;
        }
        if (HaltingThread.hasBeenHalted(currentThread)) {
            this.invalidateGeometryCache();
            return null;
        }
        if (bounds == null) {
            this.primitiveBounds = NULL_RECT;
            return null;
        }
        this.primitiveBounds = bounds;
        while (i2 < this.count) {
            Rectangle2D ctb;
            if ((ctb = this.children[i2++].getTransformedBounds(GraphicsNode.IDENTITY)) != null) {
                if (this.primitiveBounds == null) {
                    return null;
                }
                this.primitiveBounds.add(ctb);
            }
            if ((i2 & 0xF) == 0 && HaltingThread.hasBeenHalted(currentThread)) break;
        }
        if (HaltingThread.hasBeenHalted(currentThread)) {
            this.invalidateGeometryCache();
        }
        return this.primitiveBounds;
    }

    public static Rectangle2D getTransformedBBox(Rectangle2D r2d, AffineTransform t2) {
        if (t2 == null || r2d == null) {
            return r2d;
        }
        double x2 = r2d.getX();
        double w2 = r2d.getWidth();
        double y = r2d.getY();
        double h2 = r2d.getHeight();
        double sx = t2.getScaleX();
        double sy = t2.getScaleY();
        if (sx < 0.0) {
            x2 = -(x2 + w2);
            sx = -sx;
        }
        if (sy < 0.0) {
            y = -(y + h2);
            sy = -sy;
        }
        return new Rectangle2D.Float((float)(x2 * sx + t2.getTranslateX()), (float)(y * sy + t2.getTranslateY()), (float)(w2 * sx), (float)(h2 * sy));
    }

    public Rectangle2D getTransformedPrimitiveBounds(AffineTransform txf) {
        AffineTransform t2 = txf;
        if (this.transform != null) {
            t2 = new AffineTransform(txf);
            t2.concatenate(this.transform);
        }
        if (t2 == null || t2.getShearX() == 0.0 && t2.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getPrimitiveBounds(), t2);
        }
        int i2 = 0;
        Rectangle2D tpb = null;
        while (tpb == null && i2 < this.count) {
            tpb = this.children[i2++].getTransformedBounds(t2);
        }
        while (i2 < this.count) {
            Rectangle2D ctb;
            if ((ctb = this.children[i2++].getTransformedBounds(t2)) == null) continue;
            tpb.add(ctb);
        }
        return tpb;
    }

    public Rectangle2D getGeometryBounds() {
        if (this.geometryBounds == null) {
            int i2 = 0;
            while (this.geometryBounds == null && i2 < this.count) {
                this.geometryBounds = this.children[i2++].getTransformedGeometryBounds(GraphicsNode.IDENTITY);
            }
            while (i2 < this.count) {
                Rectangle2D cgb;
                if ((cgb = this.children[i2++].getTransformedGeometryBounds(GraphicsNode.IDENTITY)) == null) continue;
                if (this.geometryBounds == null) {
                    return this.getGeometryBounds();
                }
                this.geometryBounds.add(cgb);
            }
        }
        return this.geometryBounds;
    }

    public Rectangle2D getTransformedGeometryBounds(AffineTransform txf) {
        AffineTransform t2 = txf;
        if (this.transform != null) {
            t2 = new AffineTransform(txf);
            t2.concatenate(this.transform);
        }
        if (t2 == null || t2.getShearX() == 0.0 && t2.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getGeometryBounds(), t2);
        }
        Rectangle2D gb = null;
        int i2 = 0;
        while (gb == null && i2 < this.count) {
            gb = this.children[i2++].getTransformedGeometryBounds(t2);
        }
        Rectangle2D cgb = null;
        while (i2 < this.count) {
            if ((cgb = this.children[i2++].getTransformedGeometryBounds(t2)) == null) continue;
            gb.add(cgb);
        }
        return gb;
    }

    public Rectangle2D getSensitiveBounds() {
        if (this.sensitiveBounds != null) {
            return this.sensitiveBounds;
        }
        int i2 = 0;
        while (this.sensitiveBounds == null && i2 < this.count) {
            this.sensitiveBounds = this.children[i2++].getTransformedSensitiveBounds(GraphicsNode.IDENTITY);
        }
        while (i2 < this.count) {
            Rectangle2D cgb;
            if ((cgb = this.children[i2++].getTransformedSensitiveBounds(GraphicsNode.IDENTITY)) == null) continue;
            if (this.sensitiveBounds == null) {
                return this.getSensitiveBounds();
            }
            this.sensitiveBounds.add(cgb);
        }
        return this.sensitiveBounds;
    }

    public Rectangle2D getTransformedSensitiveBounds(AffineTransform txf) {
        AffineTransform t2 = txf;
        if (this.transform != null) {
            t2 = new AffineTransform(txf);
            t2.concatenate(this.transform);
        }
        if (t2 == null || t2.getShearX() == 0.0 && t2.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getSensitiveBounds(), t2);
        }
        Rectangle2D sb = null;
        int i2 = 0;
        while (sb == null && i2 < this.count) {
            sb = this.children[i2++].getTransformedSensitiveBounds(t2);
        }
        while (i2 < this.count) {
            Rectangle2D csb;
            if ((csb = this.children[i2++].getTransformedSensitiveBounds(t2)) == null) continue;
            sb.add(csb);
        }
        return sb;
    }

    public boolean contains(Point2D p2) {
        Rectangle2D bounds = this.getSensitiveBounds();
        if (this.count > 0 && bounds != null && bounds.contains(p2)) {
            Point2D pt = null;
            Point2D cp = null;
            int i2 = 0;
            while (i2 < this.count) {
                AffineTransform t2 = this.children[i2].getInverseTransform();
                cp = t2 != null ? (pt = t2.transform(p2, pt)) : p2;
                if (this.children[i2].contains(cp)) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public GraphicsNode nodeHitAt(Point2D p2) {
        Rectangle2D bounds = this.getSensitiveBounds();
        if (this.count > 0 && bounds != null && bounds.contains(p2)) {
            Point2D pt = null;
            Point2D cp = null;
            int i2 = this.count - 1;
            while (i2 >= 0) {
                AffineTransform t2 = this.children[i2].getInverseTransform();
                cp = t2 != null ? (pt = t2.transform(p2, pt)) : p2;
                GraphicsNode node = this.children[i2].nodeHitAt(cp);
                if (node != null) {
                    return node;
                }
                --i2;
            }
        }
        return null;
    }

    public Shape getOutline() {
        if (this.outline != null) {
            return this.outline;
        }
        this.outline = new GeneralPath();
        int i2 = 0;
        while (i2 < this.count) {
            Shape childOutline = this.children[i2].getOutline();
            if (childOutline != null) {
                AffineTransform tr = this.children[i2].getTransform();
                if (tr != null) {
                    ((GeneralPath)this.outline).append(tr.createTransformedShape(childOutline), false);
                } else {
                    ((GeneralPath)this.outline).append(childOutline, false);
                }
            }
            ++i2;
        }
        return this.outline;
    }

    protected void setRoot(RootGraphicsNode newRoot) {
        super.setRoot(newRoot);
        int i2 = 0;
        while (i2 < this.count) {
            GraphicsNode node = this.children[i2];
            ((AbstractGraphicsNode)node).setRoot(newRoot);
            ++i2;
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object node) {
        return this.indexOf(node) >= 0;
    }

    public Iterator iterator() {
        return new Itr();
    }

    public Object[] toArray() {
        Object[] result = new GraphicsNode[this.count];
        System.arraycopy(this.children, 0, result, 0, this.count);
        return result;
    }

    public Object[] toArray(Object[] a2) {
        if (a2.length < this.count) {
            a2 = new GraphicsNode[this.count];
        }
        System.arraycopy(this.children, 0, a2, 0, this.count);
        if (a2.length > this.count) {
            a2[this.count] = null;
        }
        return a2;
    }

    public Object get(int index) {
        this.checkRange(index);
        return this.children[index];
    }

    public Object set(int index, Object o2) {
        if (!(o2 instanceof GraphicsNode)) {
            throw new IllegalArgumentException(o2 + " is not a GraphicsNode");
        }
        this.checkRange(index);
        GraphicsNode node = (GraphicsNode)o2;
        this.fireGraphicsNodeChangeStarted(node);
        if (node.getParent() != null) {
            node.getParent().getChildren().remove(node);
        }
        GraphicsNode oldNode = this.children[index];
        this.children[index] = node;
        ((AbstractGraphicsNode)node).setParent(this);
        ((AbstractGraphicsNode)oldNode).setParent(null);
        ((AbstractGraphicsNode)node).setRoot(this.getRoot());
        ((AbstractGraphicsNode)oldNode).setRoot(null);
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return oldNode;
    }

    public boolean add(Object o2) {
        if (!(o2 instanceof GraphicsNode)) {
            throw new IllegalArgumentException(o2 + " is not a GraphicsNode");
        }
        GraphicsNode node = (GraphicsNode)o2;
        this.fireGraphicsNodeChangeStarted(node);
        if (node.getParent() != null) {
            node.getParent().getChildren().remove(node);
        }
        this.ensureCapacity(this.count + 1);
        this.children[this.count++] = node;
        ((AbstractGraphicsNode)node).setParent(this);
        ((AbstractGraphicsNode)node).setRoot(this.getRoot());
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return true;
    }

    public void add(int index, Object o2) {
        if (!(o2 instanceof GraphicsNode)) {
            throw new IllegalArgumentException(o2 + " is not a GraphicsNode");
        }
        if (index > this.count || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.count);
        }
        GraphicsNode node = (GraphicsNode)o2;
        this.fireGraphicsNodeChangeStarted(node);
        if (node.getParent() != null) {
            node.getParent().getChildren().remove(node);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.children, index, this.children, index + 1, this.count - index);
        this.children[index] = node;
        ++this.count;
        ((AbstractGraphicsNode)node).setParent(this);
        ((AbstractGraphicsNode)node).setRoot(this.getRoot());
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
    }

    public boolean addAll(Collection c2) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c2) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o2) {
        if (!(o2 instanceof GraphicsNode)) {
            throw new IllegalArgumentException(o2 + " is not a GraphicsNode");
        }
        GraphicsNode node = (GraphicsNode)o2;
        if (node.getParent() != this) {
            return false;
        }
        int index = 0;
        while (node != this.children[index]) {
            ++index;
        }
        this.remove(index);
        return true;
    }

    public Object remove(int index) {
        this.checkRange(index);
        GraphicsNode oldNode = this.children[index];
        this.fireGraphicsNodeChangeStarted(oldNode);
        ++this.modCount;
        int numMoved = this.count - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.children, index + 1, this.children, index, numMoved);
        }
        this.children[--this.count] = null;
        if (this.count == 0) {
            this.children = null;
        }
        ((AbstractGraphicsNode)oldNode).setParent(null);
        ((AbstractGraphicsNode)oldNode).setRoot(null);
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return oldNode;
    }

    public boolean removeAll(Collection c2) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c2) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c2) {
        Iterator i2 = c2.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.next())) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object node) {
        if (node == null || !(node instanceof GraphicsNode)) {
            return -1;
        }
        if (((GraphicsNode)node).getParent() == this) {
            int iCount = this.count;
            GraphicsNode[] workList = this.children;
            int i2 = 0;
            while (i2 < iCount) {
                if (node == workList[i2]) {
                    return i2;
                }
                ++i2;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object node) {
        if (node == null || !(node instanceof GraphicsNode)) {
            return -1;
        }
        if (((GraphicsNode)node).getParent() == this) {
            int i2 = this.count - 1;
            while (i2 >= 0) {
                if (node == this.children[i2]) {
                    return i2;
                }
                --i2;
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.count) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private void checkRange(int index) {
        if (index >= this.count || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.count);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (this.children == null) {
            this.children = new GraphicsNode[4];
        }
        ++this.modCount;
        int oldCapacity = this.children.length;
        if (minCapacity > oldCapacity) {
            GraphicsNode[] oldData = this.children;
            int newCapacity = oldCapacity + oldCapacity / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.children = new GraphicsNode[newCapacity];
            System.arraycopy(oldData, 0, this.children, 0, this.count);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.cursor = index;
        }

        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            try {
                Object previous = CompositeGraphicsNode.this.get(--this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException e2) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object o2) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.set(this.lastRet, o2);
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException e2) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object o2) {
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.add(this.cursor++, o2);
                this.lastRet = -1;
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException e2) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = CompositeGraphicsNode.this.modCount;
        }

        public boolean hasNext() {
            return this.cursor != CompositeGraphicsNode.this.count;
        }

        public Object next() {
            try {
                Object next = CompositeGraphicsNode.this.get(this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e2) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException e2) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (CompositeGraphicsNode.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

