/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.recalibration;

import org.broadinstitute.gatk.utils.recalibration.RecalDatum;

public final class ContextDatum
extends RecalDatum {
    public static final String ROOT_CONTEXT = "";
    public final String context;

    public ContextDatum(String context, long observations, double errors) {
        super(observations, errors, (byte)30);
        this.context = context;
    }

    @Override
    public String toString() {
        return this.isRootContext() ? "x" : this.context;
    }

    public String getParentContext() {
        if (this.isRootContext()) {
            throw new IllegalArgumentException("cannot get parent of root context");
        }
        return this.size() == 1 ? ROOT_CONTEXT : this.context.substring(1, this.size());
    }

    public boolean isRootContext() {
        return this.context.equals(ROOT_CONTEXT);
    }

    public int size() {
        return this.context.length();
    }
}

