/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class HeapSizeMonitor {
    private final int monitorFrequencyMillis;
    private final MonitorRunnable monitorRunnable;
    private Thread monitorThread;

    public HeapSizeMonitor() {
        this(1000);
    }

    public HeapSizeMonitor(int monitorFrequencyMillis) {
        this.monitorFrequencyMillis = monitorFrequencyMillis;
        this.monitorRunnable = new MonitorRunnable();
    }

    public long getMaxMemoryUsed() {
        return this.monitorRunnable.getMaxMemoryUsed();
    }

    public void start() {
        this.monitorThread = new Thread(this.monitorRunnable);
        this.monitorThread.start();
    }

    public void stop() {
        this.monitorRunnable.stop = true;
        try {
            this.monitorThread.join();
        }
        catch (InterruptedException ex) {
            throw new ReviewedGATKException("Unable to connect to monitor thread");
        }
        this.monitorThread = null;
    }

    private class MonitorRunnable
    implements Runnable {
        private MemoryMXBean monitor = ManagementFactory.getMemoryMXBean();
        private long maxMemoryUsed;
        private boolean stop;

        public void reset() {
            this.maxMemoryUsed = 0L;
            this.stop = false;
        }

        public long getMaxMemoryUsed() {
            return this.maxMemoryUsed;
        }

        @Override
        public void run() {
            while (!this.stop) {
                System.gc();
                this.maxMemoryUsed = Math.max(this.monitor.getHeapMemoryUsage().getUsed(), this.maxMemoryUsed);
                try {
                    Thread.sleep(HeapSizeMonitor.this.monitorFrequencyMillis);
                }
                catch (InterruptedException ex) {
                    throw new ReviewedGATKException("Unable to continue monitoring heap consumption", ex);
                }
            }
        }
    }
}

