/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFEncoder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class VCFRecordCodec
implements SortingCollection.Codec<VariantContext> {
    final VCFCodec vcfDecoder = new VCFCodec();
    final VCFEncoder vcfEncoder;
    private PrintStream outputStream = null;
    private BufferedReader inputReader = null;

    public VCFRecordCodec(VCFHeader header) {
        this.vcfEncoder = new VCFEncoder(header, false, false);
        this.vcfDecoder.setVCFHeader(header, VCFHeaderVersion.VCF4_1);
    }

    @Override
    public void setOutputStream(OutputStream stream) {
        this.outputStream = new PrintStream(stream);
    }

    @Override
    public void setInputStream(InputStream stream) {
        this.inputReader = new BufferedReader(new InputStreamReader(stream));
    }

    @Override
    public void encode(VariantContext context) {
        this.outputStream.println(this.vcfEncoder.encode(context));
    }

    @Override
    public VariantContext decode() {
        try {
            String line = this.inputReader.readLine();
            return line != null ? this.vcfDecoder.decode(line) : null;
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Could not decode/read a VCF record for a sorting collection: " + ioe.getMessage(), ioe);
        }
    }

    public VCFRecordCodec clone() {
        return new VCFRecordCodec(this.vcfEncoder.getVCFHeader());
    }
}

