/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.AbstractGraphIterator;

public abstract class CrossComponentIterator<V, E, D>
extends AbstractGraphIterator<V, E> {
    private static final int CCS_BEFORE_COMPONENT = 1;
    private static final int CCS_WITHIN_COMPONENT = 2;
    private static final int CCS_AFTER_COMPONENT = 3;
    private final ConnectedComponentTraversalEvent ccFinishedEvent = new ConnectedComponentTraversalEvent(this, 32);
    private final ConnectedComponentTraversalEvent ccStartedEvent = new ConnectedComponentTraversalEvent(this, 31);
    private FlyweightEdgeEvent<V, E> reusableEdgeEvent;
    private FlyweightVertexEvent<V> reusableVertexEvent;
    private Iterator<V> vertexIterator = null;
    private Map<V, D> seen = new HashMap<V, D>();
    private V startVertex;
    private Specifics<V, E> specifics;
    private final Graph<V, E> graph;
    private int state = 1;

    public CrossComponentIterator(Graph<V, E> graph, V v2) {
        if (graph == null) {
            throw new IllegalArgumentException("graph must not be null");
        }
        this.graph = graph;
        this.specifics = CrossComponentIterator.createGraphSpecifics(graph);
        this.vertexIterator = graph.vertexSet().iterator();
        this.setCrossComponentTraversal(v2 == null);
        this.reusableEdgeEvent = new FlyweightEdgeEvent((Object)this, null);
        this.reusableVertexEvent = new FlyweightVertexEvent<Object>((Object)this, null);
        if (v2 == null) {
            this.startVertex = this.vertexIterator.hasNext() ? this.vertexIterator.next() : null;
        } else if (graph.containsVertex(v2)) {
            this.startVertex = v2;
        } else {
            throw new IllegalArgumentException("graph must contain the start vertex");
        }
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public boolean hasNext() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.isConnectedComponentExhausted()) {
            if (this.state == 2) {
                this.state = 3;
                if (this.nListeners != 0) {
                    this.fireConnectedComponentFinished(this.ccFinishedEvent);
                }
            }
            if (this.isCrossComponentTraversal()) {
                while (this.vertexIterator.hasNext()) {
                    V v2 = this.vertexIterator.next();
                    if (this.isSeenVertex(v2)) continue;
                    this.encounterVertex(v2, null);
                    this.state = 1;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public V next() {
        if (this.startVertex != null) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            if (this.state == 1) {
                this.state = 2;
                if (this.nListeners != 0) {
                    this.fireConnectedComponentStarted(this.ccStartedEvent);
                }
            }
            V v2 = this.provideNextVertex();
            if (this.nListeners != 0) {
                this.fireVertexTraversed(this.createVertexTraversalEvent(v2));
            }
            this.addUnseenChildrenOf(v2);
            return v2;
        }
        throw new NoSuchElementException();
    }

    protected abstract boolean isConnectedComponentExhausted();

    protected abstract void encounterVertex(V var1, E var2);

    protected abstract V provideNextVertex();

    protected D getSeenData(V v2) {
        return this.seen.get(v2);
    }

    protected boolean isSeenVertex(Object object) {
        return this.seen.containsKey(object);
    }

    protected abstract void encounterVertexAgain(V var1, E var2);

    protected D putSeenData(V v2, D d2) {
        return this.seen.put(v2, d2);
    }

    protected void finishVertex(V v2) {
        if (this.nListeners != 0) {
            this.fireVertexFinished(this.createVertexTraversalEvent(v2));
        }
    }

    static <V, E> Specifics<V, E> createGraphSpecifics(Graph<V, E> graph) {
        if (graph instanceof DirectedGraph) {
            return new DirectedSpecifics((DirectedGraph)graph);
        }
        return new UndirectedSpecifics<V, E>(graph);
    }

    private void addUnseenChildrenOf(V v2) {
        for (E e2 : this.specifics.edgesOf(v2)) {
            V v3;
            if (this.nListeners != 0) {
                this.fireEdgeTraversed(this.createEdgeTraversalEvent(e2));
            }
            if (this.isSeenVertex(v3 = Graphs.getOppositeVertex(this.graph, e2, v2))) {
                this.encounterVertexAgain(v3, e2);
                continue;
            }
            this.encounterVertex(v3, e2);
        }
    }

    private EdgeTraversalEvent<V, E> createEdgeTraversalEvent(E e2) {
        if (this.isReuseEvents()) {
            this.reusableEdgeEvent.setEdge(e2);
            return this.reusableEdgeEvent;
        }
        return new EdgeTraversalEvent(this, e2);
    }

    private VertexTraversalEvent<V> createVertexTraversalEvent(V v2) {
        if (this.isReuseEvents()) {
            this.reusableVertexEvent.setVertex(v2);
            return this.reusableVertexEvent;
        }
        return new VertexTraversalEvent<V>(this, v2);
    }

    private void encounterStartVertex() {
        this.encounterVertex(this.startVertex, null);
        this.startVertex = null;
    }

    private static class UndirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private Graph<VV, EE> graph;

        public UndirectedSpecifics(Graph<VV, EE> graph) {
            this.graph = graph;
        }

        @Override
        public Set<EE> edgesOf(VV VV) {
            return this.graph.edgesOf(VV);
        }
    }

    private static class DirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private DirectedGraph<VV, EE> graph;

        public DirectedSpecifics(DirectedGraph<VV, EE> directedGraph) {
            this.graph = directedGraph;
        }

        @Override
        public Set<? extends EE> edgesOf(VV VV) {
            return this.graph.outgoingEdgesOf(VV);
        }
    }

    static class FlyweightVertexEvent<VV>
    extends VertexTraversalEvent<VV> {
        private static final long serialVersionUID = 3834024753848399924L;

        public FlyweightVertexEvent(Object object, VV VV) {
            super(object, VV);
        }

        protected void setVertex(VV VV) {
            this.vertex = VV;
        }
    }

    static class FlyweightEdgeEvent<VV, localE>
    extends EdgeTraversalEvent<VV, localE> {
        private static final long serialVersionUID = 4051327833765000755L;

        public FlyweightEdgeEvent(Object object, localE localE) {
            super(object, localE);
        }

        protected void setEdge(localE localE) {
            this.edge = localE;
        }
    }

    static abstract class Specifics<VV, EE> {
        Specifics() {
        }

        public abstract Set<? extends EE> edgesOf(VV var1);
    }

    static interface SimpleContainer<T> {
        public boolean isEmpty();

        public void add(T var1);

        public T remove();
    }

    protected static enum VisitColor {
        WHITE,
        GRAY,
        BLACK;

    }
}

