/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.UnionFind;

public class KruskalMinimumSpanningTree<V, E> {
    private double spanningTreeCost;
    private Set<E> edgeList;

    public KruskalMinimumSpanningTree(final Graph<V, E> graph) {
        UnionFind<V> unionFind = new UnionFind<V>(graph.vertexSet());
        ArrayList<E> arrayList = new ArrayList<E>(graph.edgeSet());
        Collections.sort(arrayList, new Comparator<E>(){

            @Override
            public int compare(E e2, E e3) {
                return Double.valueOf(graph.getEdgeWeight(e2)).compareTo(graph.getEdgeWeight(e3));
            }
        });
        this.spanningTreeCost = 0.0;
        this.edgeList = new HashSet();
        for (E e2 : arrayList) {
            V v2 = graph.getEdgeSource(e2);
            V v3 = graph.getEdgeTarget(e2);
            if (unionFind.find(v2).equals(unionFind.find(v3))) continue;
            unionFind.union(v2, v3);
            this.edgeList.add(e2);
            this.spanningTreeCost += graph.getEdgeWeight(e2);
        }
    }

    public Set<E> getEdgeSet() {
        return this.edgeList;
    }

    public double getSpanningTreeCost() {
        return this.spanningTreeCost;
    }
}

